
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Mt5 Group</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

     <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
        <div class="container mx-auto px-4">
        <h1 class="text-4xl font-bold text-center mb-8 text-[#CD7F32]">Add Mt5 Group</h1>

        <!-- Group Form -->
        <form action="add_group.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-2xl shadow-2xl border border-gray-300">
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Group Name -->
                <div>
                    <label for="group_name" class="block text-[#CD7F32] text-lg font-bold uppercase tracking-wide mb-2">Group Name:</label>
                    <input type="text" id="group_name" name="group_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] transition-shadow focus:shadow-md" required placeholder="Enter group name">
                </div>

                <!-- MT5 Group Name -->
                <div>
                    <label for="mt5_group_name" class="block text-[#CD7F32] text-lg font-bold uppercase tracking-wide mb-2">MT5 Group Name:</label>
                    <input type="text" id="mt5_group_name" name="mt5_group_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] transition-shadow focus:shadow-md" required placeholder="Enter MT5 group name">
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-[#CD7F32] text-lg font-bold uppercase tracking-wide mb-2">Status:</label>
                    <select id="status" name="status" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] transition-shadow focus:shadow-md" required>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="mt-8 text-center">
                <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                    Add Mt5 Group
                </button>
            </div>
        </form>
    </div>
</div>
</main></div>
</body>
</html>