<?php
// Handle form submission to add user commission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $plan_id = $_POST['plan_id'];

    // Here you would typically save the user_id and plan_id to the database.
    // Since you requested not to use DB data, we won't perform any database operations here.
    echo "User ID: $user_id, Plan ID: $plan_id - Commission added successfully!";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add User Commission</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

      <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
          <h1 class="text-3xl font-bold text-center mb-6 text-[#CD7F32]">Add User Commission</h1>

            <!-- Add User Commission Form -->
            <form action="add_user_commission.php" method="POST" class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg border border-gray-200">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Select User ID Dropdown -->
                    <div>
                        <label for="user_id" class="block text-[#CD7F32] text-lg font-semibold mb-2">Select User ID:</label>
                        <select id="user_id" name="user_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none">
                            <option value="">-- Select User --</option>
                            <option value="1">User 1</option>
                            <option value="2">User 2</option>
                            <option value="3">User 3</option>
                            <option value="4">User 4</option>
                        </select>
                    </div>

                    <!-- Select Plan Dropdown -->
                    <div>
                        <label for="plan_id" class="block text-[#CD7F32] text-lg font-semibold mb-2">Select Plan:</label>
                        <select id="plan_id" name="plan_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none">
                            <option value="">-- Select Plan --</option>
                            <option value="1">Plan A</option>
                            <option value="2">Plan B</option>
                            <option value="3">Plan C</option>
                            <option value="4">Plan D</option>
                        </select>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-8 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                        Add Commission
                    </button>
                </div>
            </form>
        </div>

       <?php include "footer.php"; ?>
    </main> 
</div>

</body>
</html>
