<?php
session_start();
error_reporting(0);
include('config.php');
require_once('auth_guard.php');

?>


    <style>
  /* Table */
  table.table {
    border-collapse: separate;
    border-spacing: 0;
    width: 100%;
    border: 1px solid #ffd4b8;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 6px 16px rgba(255,122,26,0.1);
  }
  table.table thead th {
    background: linear-gradient(135deg,#ff7a1a,#e86500);
    color: #fff;
    font-weight: 600;
    text-align: left;
    padding: 12px 14px;
    border: none;
  }
  table.table tbody tr:nth-child(even) {
    background: #fff8f3;
  }
  table.table tbody tr:hover {
    background: #ffe7d6;
    transition: 0.2s ease;
  }
  table.table td {
    padding: 12px 14px;
    vertical-align: middle;
    color: #333;
  }

  /* Buttons */
  .btn-dark {
    background: linear-gradient(135deg,#ff7a1a,#e86500);
    border: none;
    color: #fff !important;
    font-weight: 600;
    border-radius: 20px;
    transition: all 0.2s ease;
  }
  .btn-dark:hover {
    background: #e86500;
    box-shadow: 0 6px 14px rgba(255,122,26,0.3);
    transform: translateY(-1px);
  }

  /* Badges (Status) */
  .badge {
    padding: 6px 12px;
    border-radius: 9999px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    border: 1px solid transparent;
  }
  .badge-success {
    background: #fff3e8;
    color: #e86500;
    border-color: #ffbb85;
  }
  .badge-primary {
    background: #ffe0c7;
    color: #ff7a1a;
    border-color: #ffc299;
  }
  .badge-danger {
    background: #fff0e6;
    color: #cc5200;
    border-color: #ffb380;
  }

  /* Page header buttons */
  .btn-fill-lmd {
    display: inline-flex;
    align-items: center;
    gap: .4rem;
    padding: .6rem 1rem;
    border-radius: 30px;
    font-weight: 600;
    transition: all .2s ease;
  }
  .bg-dark-pastel-green {
    background: linear-gradient(135deg,#ff7a1a,#e86500) !important;
    box-shadow: 0 6px 14px rgba(255,122,26,.3) !important;
  }
  .bg-dark-pastel-green:hover {
    filter: brightness(.95);
    transform: translateY(-1px);
  }
  .bg-orange-peel {
    background: #fff !important;
    color: #ff7a1a !important;
    border: 2px solid #ff7a1a !important;
  }
  .bg-orange-peel:hover {
    background: #ff7a1a !important;
    color: #fff !important;
  }
</style>

  <!-- Preloader End Here -->
 <body class="bg-gray-100">
<?php include('header.php');?>

<div class="flex flex-col md:flex-row h-screen">
  <!-- Sidebar -->
  <?php include "side_bar.php";?>

  <main class="flex-1 p-4 md:p-6 md:ml-64">
  

    <!-- Sidebar Area End Here -->
   <div class="dashboard-content-one">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <button type="button" class="btn-fill-lmd radius-30 text-light shadow-dark-pastel-green bg-dark-pastel-green">
      KYC History
    </button>
    <a href="dashboard.php" class="btn-fill-lmd radius-30 text-light shadow-dodger-blue bg-orange-peel">
      Get Back
    </a>
  </div>
</div>

      <div class="row" style="padding-top: 10px;">
       <div class="col-lg-10 grid-margin stretch-card">
        <div class="card">
          <div class="card-body">
            <div class="table-responsive pt-3">
              <table id="example" class="table table-striped mb-0">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Email</th>
                    <th>Type</th>
                    <th>Reg_Date</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $sql = "SELECT * from kyc_update where status=1 order by registered_date_js DESC";
                  $query = $dbh -> prepare($sql);
                  $query->execute();
                  $results=$query->fetchAll(PDO::FETCH_OBJ);
                  $cnt=1;
                  if($query->rowCount() > 0)
                  {
                    foreach($results as $result)
                    {
                      ?>
                      <tr>
                        <td>
                          <div> <?php echo htmlentities($result->id);?></div>
                        </td>
                         <td>
                          <div> <?php echo htmlentities($result->email);?></div>
                        </td>
                        <td>
                          <div class="amount">
                            <?php echo htmlentities($result->kyc_type);?>
                          </div>
                        </td>

                        <td>
                          <div><?php echo htmlentities($result->registered_date_js);?></div>
                        </td>

                        <td>
                          <?php
                          $stats=$result->Status;
                          if($stats==1)
                          {
                            ?>
                            <div class="badge badge-success badge-pill">Success</div>
                          <?php }
                          if($stats==2)
                            { ?>
                             <div class="badge badge-primary badge-pill">Cancelled</div>
                           <?php }

                           if($stats==0)
                            { ?>
                              <div class="badge badge-danger badge-pill">Pending</div>
                              <?php
                            } ?>
                          </td>
                          <td>
                            <div> <a href="view_kyc.php? id=<?php echo htmlentities($result->id);?>&email=<?php echo htmlentities($result->email);?>" style="padding: 5px 20px;font-size: 12px;" class="btn btn-dark btn-sm">View</a></div>
                          </td>
                        </tr>
                      <?php }}?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </body>
        <?php include('footer.php');?>
