<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
   
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head><style>/* General Styles */
body {
    font-family: Arial, sans-serif;
    background-color: #f9f9f9;
    margin: 0;
    padding: 0;
}

.container {
    max-width: 800px;
    margin: 30px auto;
    padding: 20px;
    background-color: #fff;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
}

/* Title */
h2 {
    font-size: 28px;
    color: #333;
    text-align: center;
    margin-bottom: 30px;
}

/* Form Styling */
.subadmin-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.form-group {
    display: flex;
    flex-direction: column;
}

label {
    font-size: 16px;
    color: #333;
    margin-bottom: 8px;
}

input, select {
    padding: 12px;
    font-size: 16px;
    border: 1px solid #ddd;
    border-radius: 5px;
}

input:focus, select:focus {
    outline: none;
    border-color: #007bff;
}

/* Button Styling */
.submit-btn {
    background-color: #007bff;
    color: white;
    padding: 15px 30px;
    font-size: 18px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease;
    margin-top: 20px;
}

.submit-btn:hover {
    background-color: #0056b3;
}

/* Responsive Design */
@media (max-width: 768px) {
    .container {
        padding: 15px;
    }

    h2 {
        font-size: 24px;
    }

    .subadmin-form {
        gap: 15px;
    }

    .submit-btn {
        width: 100%;
    }
}
</style>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
     
        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container"> 
      <h2>Create Sub-Admin</h2>
        <form class="subadmin-form" id="subadmin-form">
            <!-- Name Field -->
            <div class="form-group">
                <label for="subadmin-name">Full Name</label>
                <input type="text" id="subadmin-name" name="name" placeholder="Enter Full Name" required>
            </div>

            <!-- Email Field -->
            <div class="form-group">
                <label for="subadmin-email">Email Address</label>
                <input type="email" id="subadmin-email" name="email" placeholder="Enter Email Address" required>
            </div>

            <!-- Password Field -->
            <div class="form-group">
                <label for="subadmin-password">Password</label>
                <input type="password" id="subadmin-password" name="password" placeholder="Enter Password" required>
            </div>

            <!-- Type Field -->
            <div class="form-group">
                <label for="subadmin-type">Type</label>
                <select id="subadmin-type" name="type" required>
                    <option value="editor">Editor</option>
                    <option value="viewer">Viewer</option>
                    <option value="admin">Admin</option>
                </select>
            </div>

            <!-- Select Group Field -->
            <div class="form-group">
                <label for="subadmin-group">Select Group</label>
                <select id="subadmin-group" name="group" required>
                    <option value="group1">Group 1</option>
                    <option value="group2">Group 2</option>
                    <option value="group3">Group 3</option>
                </select>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="submit-btn">Create Sub-Admin</button>
        </form>
    </div>
</main>

<?php
// Include the footer
include "footer.php";
?></div>
<script>document.getElementById('subadmin-form').addEventListener('submit', function(e) {
    e.preventDefault();

    // Fetch form values
    const name = document.getElementById('subadmin-name').value;
    const email = document.getElementById('subadmin-email').value;
    const password = document.getElementById('subadmin-password').value;
    const type = document.getElementById('subadmin-type').value;
    const group = document.getElementById('subadmin-group').value;

    // Simple validation before submission
    if (name && email && password && type && group) {
        alert(`Sub-Admin Created!\nName: ${name}\nEmail: ${email}\nType: ${type}\nGroup: ${group}`);
        // You can add further AJAX or form submission logic here
    } else {
        alert('Please fill all fields!');
    }
});
</script>