<?php
session_start();
error_reporting(0);
include('config.php');       // must define $conn as PDO
require_once('auth_guard.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>IB Plans List</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">

<?php include "header.php"; ?>

<div class="flex h-screen">
  <!-- Sidebar -->
  <?php include "side_bar.php"; ?>

  <!-- Main Content -->
  <main class="flex-1 p-6 md:ml-64">
    <div class="container">
      <h1 class="text-3xl font-bold text-center mb-6">List of IB Plans</h1>

      <!-- Button to Add New IB Plan -->
      <div class="text-center mb-6">
        <a href="add_ib_plan.php" class="bg-blue-600 text-white px-6 py-3 rounded-md shadow-md hover:bg-blue-700 transition duration-300">
          Add New IB Plan
        </a>
      </div>

      <!-- Table for displaying IB Plans -->
      <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow-md">
        <thead>
          <tr class="bg-[#CD7F32] text-white">
            <th class="py-2 px-4 text-left">ID</th>
            <th class="py-2 px-4 text-left">Plan Name</th>
          </tr>
        </thead>
        <tbody>
          <?php
          try {
              $sql = "SELECT ac_index, ac_name FROM account_types ORDER BY ac_index ASC";
              $stmt = $conn->prepare($sql);
              $stmt->execute();
              $plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

              if ($plans) {
                  foreach ($plans as $plan) {
                      echo "<tr class='border-b'>";
                      echo "<td class='py-2 px-4'>" . htmlspecialchars($plan['ac_index']) . "</td>";
                      echo "<td class='py-2 px-4'>" . htmlspecialchars($plan['ac_name']) . "</td>";
                      echo "</tr>";
                  }
              } else {
                  echo "<tr><td colspan='2' class='py-2 px-4 text-center text-gray-500'>No IB plans found</td></tr>";
              }
          } catch (PDOException $e) {
              echo "<tr><td colspan='2' class='py-2 px-4 text-center text-red-500'>Error: " . $e->getMessage() . "</td></tr>";
          }
          ?>
        </tbody>
      </table>
    </div>
  </main>
</div>

</body>
</html>
