
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Investor PAMM Request List</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>

    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>

        <main class="flex-1 p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-2xl font-semibold text-center text-[#CD7F32] mb-6">Investor PAMM Request List</h1>

                <!-- Table for displaying PAMM Requests -->
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow-md">
                        <thead class="bg-[#CD7F32] text-white">
                            <tr>
                                <th class="py-2 px-4 text-left">Request ID</th>
                                <th class="py-2 px-4 text-left">Investor Name</th>
                                <th class="py-2 px-4 text-left">Amount</th>
                                <th class="py-2 px-4 text-left">Requested Date</th>
                                <th class="py-2 px-4 text-left">Status</th>
                                <th class="py-2 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Dummy Data Rows -->
                            <?php 
                            $requests = [
                                ["id" => 1, "name" => "John Doe", "amount" => "$5000", "date" => "2025-02-01", "status" => "Approved"],
                                ["id" => 2, "name" => "Jane Smith", "amount" => "$2000", "date" => "2025-02-02", "status" => "Pending"],
                                ["id" => 3, "name" => "Michael Lee", "amount" => "$15000", "date" => "2025-02-03", "status" => "Rejected"],
                                ["id" => 4, "name" => "Emily Zhang", "amount" => "$8000", "date" => "2025-02-03", "status" => "Pending"],
                            ];
                            foreach ($requests as $req) {
                                $statusColor = ($req["status"] == "Approved") ? "text-green-500" : (($req["status"] == "Pending") ? "text-yellow-500" : "text-red-500");
                                echo "<tr class='border-b hover:bg-[#F8E6D1] transition'>
                                        <td class='py-3 px-4'>{$req["id"]}</td>
                                        <td class='py-3 px-4'>{$req["name"]}</td>
                                        <td class='py-3 px-4'>{$req["amount"]}</td>
                                        <td class='py-3 px-4'>{$req["date"]}</td>
                                        <td class='py-3 px-4 $statusColor'>{$req["status"]}</td>
                                        <td class='py-3 px-4 flex gap-3'>
                                            <a href='approve_request.php?id={$req["id"]}' class='text-green-500 hover:underline'>Approve</a>
                                            <a href='reject_request.php?id={$req["id"]}' class='text-red-500 hover:underline'>Reject</a>
                                        </td>
                                    </tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>

        <?php include "footer.php"; ?>
    </div>
</body>
</html>