<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-100">
<?php //include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
            <div class="container">
                <input type="text" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-1/3">
          

            <!-- Filter Options -->
            <div class="bg-white shadow p-4 rounded-lg mt-6">
                <form action="" method="GET" class="flex space-x-4">
                    <div>
                        <label for="fromDate" class="block text-gray-700">From Date</label>
                        <input type="date" id="fromDate" name="fromDate" class="p-2 border border-gray-300 rounded-lg" value="<?php echo isset($_GET['fromDate']) ? $_GET['fromDate'] : ''; ?>">
                    </div>
                    <div>
                        <label for="toDate" class="block text-gray-700">To Date</label>
                        <input type="date" id="toDate" name="toDate" class="p-2 border border-gray-300 rounded-lg" value="<?php echo isset($_GET['toDate']) ? $_GET['toDate'] : ''; ?>">
                    </div>
                    <div>
                        <label for="marketingName" class="block text-gray-700">Marketing Name</label>
                        <select id="marketingName" name="marketingName" class="p-2 border border-gray-300 rounded-lg">
                            <option value="">Select Marketing Name</option>
                            <option value="Techysquad" <?php echo (isset($_GET['marketingName']) && $_GET['marketingName'] == 'Techysquad') ? 'selected' : ''; ?>>Techysquad</option>
                            <!-- Add other options here -->
                        </select>
                    </div>
                    <div>
                        <label for="country" class="block text-gray-700">Country</label>
                        <select id="country" name="country" class="p-2 border border-gray-300 rounded-lg">
                            <option value="">Select Country</option>
                            <option value="USA" <?php echo (isset($_GET['country']) && $_GET['country'] == 'USA') ? 'selected' : ''; ?>>USA</option>
                            <option value="UK" <?php echo (isset($_GET['country']) && $_GET['country'] == 'UK') ? 'selected' : ''; ?>>UK</option>
                            <!-- Add other countries here -->
                        </select>
                    </div>
                    <button type="submit" class="bg-blue-500 text-white p-2 rounded-lg mt-6">Apply Filters</button>
                </form>
            </div>

            <!-- Dashboard Cards -->
            <div class="grid grid-cols-3 gap-4 mt-6">
                <?php 
                    $stats = [
                        'Total Clients' => 26,
                        'Total IB' => 25,
                        'Pending Clients' => 1,
                        'Pending Deposit' => 6,
                        'Pending Withdraw' => 3,
                        'Pending IB Withdraw' => 2,
                        'Active Traders' => 6,
                        'FTD Users' => 6,
                        'Non FTD Users' => 45,
                        'Pending IB Request' => 2,
                        'Pending Bank Details Request' => 1
                    ];

                    // Apply Filters in PHP logic (You can use the values from $_GET)
                    $fromDate = isset($_GET['fromDate']) ? $_GET['fromDate'] : '';
                    $toDate = isset($_GET['toDate']) ? $_GET['toDate'] : '';
                    $marketingName = isset($_GET['marketingName']) ? $_GET['marketingName'] : '';
                    $country = isset($_GET['country']) ? $_GET['country'] : '';

                    // Loop through the stats and display them
                    foreach ($stats as $title => $value) {
                        echo "<div class='bg-white shadow p-6 rounded-lg'>
                                <h2 class='text-xl font-semibold'>$title</h2>
                                <p class='text-2xl font-bold text-orange-600'>$value</p>
                              </div>";
                    }
                ?>
            </div>

            <!-- Tab Navigation -->
            <div class="mb-6"><br><br>
                <ul class="flex border-b-2 border-gray-300">
                    <li class="mr-4">
                        <button id="tab-1" class="py-2 px-4 text-lg text-gray-700 font-semibold focus:outline-none" onclick="showTab(1)">Deposits & Withdrawals</button>
                    </li>
                    <li>
                        <button id="tab-2" class="py-2 px-4 text-lg text-gray-700 font-semibold focus:outline-none" onclick="showTab(2)">Client Registrations</button>
                    </li>
                </ul>
            </div>

            <!-- Graphical Representation -->
            <div id="chart-1" class="bg-white shadow p-6 rounded-lg">
                <h2 class="text-xl font-semibold mb-4">Deposits vs Withdrawals vs IB Withdrawals</h2>
                <canvas id="depositWithdrawalChart"></canvas>
            </div>

            <div id="chart-2" class="bg-white shadow p-6 rounded-lg hidden">
                <h2 class="text-xl font-semibold mb-4">Client Registrations Over Time</h2>
                <canvas id="clientRegistrationChart"></canvas>
            </div>

            <div class="grid grid-cols-4 gap-4 mt-6">
                <?php 
                    $stats = [
                        'Daily Deposits' => 26,
                        'Weekly Deposits ' => 25,
                        'Monthly Deposits' => 1,
                        'Total Deposits' => 2,
                        'Daily Withdrawal' => 6,
                        'Weekly Withdrawal' => 3,
                        'Monthly Withdrawal' => 2,
                        'Total Withdrawal' => 1,
                        'Daily IB Withdrawal' => 6,
                        'Weekly IB Withdrawal' => 6,
                        'Monthly IB Withdrawal' => 45,
                        'Total IB Withdrawal' => 1234
                    ];

                    foreach ($stats as $title => $value) {
                        echo "<div class='bg-white shadow p-6 rounded-lg'>
                                <h2 class='text-xl font-semibold'>$title</h2>
                                <p class='text-2xl font-bold text-orange-600'>$value</p>
                              </div>";
                    }
                ?>
            </div><br><br><br>
<?php include "footer.php";?>
        </main>
    </div>

</body>
</html>
