<?php
// Include the database connection
include "db_connection.php";

// Include PHPMailer for email functionality
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_POST['user_id'];

    // Query to fetch user details based on selected user ID
    $query = "SELECT username, email, password FROM users WHERE id = ?";
    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($username, $email, $password);
        $stmt->fetch();

        if ($stmt->num_rows > 0) {
            // Send email with login details
            try {
                $mail = new PHPMailer(true);
                $mail->isSMTP();
                $mail->Host = 'smtp.example.com'; // Use your SMTP server
                $mail->SMTPAuth = true;
                $mail->Username = 'your_email@example.com'; // Your SMTP username
                $mail->Password = 'your_email_password'; // Your SMTP password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port = 587;

                $mail->setFrom('your_email@example.com', 'Your Company Name');
                $mail->addAddress($email, $username);

                $mail->isHTML(true);
                $mail->Subject = 'Your Login Details';
                $mail->Body    = "<h3>Login Details</h3><p>Username: <strong>$username</strong></p><p>Password: <strong>$password</strong></p>";

                $mail->send();
                echo 'The login details have been sent to the user email.';
            } catch (Exception $e) {
                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
            }
        } else {
            echo 'No user found with that ID.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resend Login Details</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
            <!-- Top Navigation -->
            <div class="flex justify-between items-center bg-white shadow p-4 rounded-lg mb-6">
                <div class="flex items-center">
                    <span class="text-gray-700 font-semibold text-lg">Resend User Login Details</span>
                </div>
            </div>

            <!-- Form Section -->
            <div class="container mx-auto p-6">
                <h2 class="text-2xl font-bold text-gray-700 mb-4">Select User and Resend Login Details</h2>

                <!-- Resend Login Details Form -->
                <form action="resend_login_details.php" method="POST" class="bg-white p-6 rounded-lg shadow-md w-full max-w-lg mx-auto space-y-6">
                    <!-- User Selection -->
                    <div class="flex items-center space-x-4">
                        <i class="fas fa-user-secret text-blue-600"></i>
                        <div class="w-full">
                            <label for="user_id" class="block text-gray-700 text-sm font-semibold mb-2">Select User</label>
                            <select id="user_id" name="user_id" required class="w-full p-3 border border-gray-300 rounded-md text-sm focus:outline-none focus:ring-2 focus:ring-blue-400">
                                <option value="">-- Select User ID --</option>
                                <?php
                                // Fetch user IDs dynamically from the database
                                $query = "SELECT id, username FROM users";
                                $result = $conn->query($query);
                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        echo "<option value='" . $row['id'] . "'>" . $row['username'] . " (" . $row['id'] . ")</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="w-full bg-blue-600 text-white py-3 rounded-md font-semibold text-sm hover:bg-blue-700 transition duration-300 flex items-center justify-center space-x-2">
                        <i class="fas fa-envelope"></i>
                        <span>Resend Login Details</span>
                    </button>
                </form>
            </div><?php include "footer.php";?>
        </main>
    </div>

    <!-- Footer -->
    

</body>
</html>
