<?php
// update_credentials.php
declare(strict_types=1);
session_start();
require_once __DIR__ . "/config.php"; // must provide $conn (PDO)

if (empty($_SESSION["alogin"]) || ($_SESSION["role"] ?? "") !== "ADMIN") {
    header("Location: login.php");
    exit;
}

$email = $_SESSION["alogin"];
$msgPwd = "";
$msgPin = "";

// --- Update Password ---
if (isset($_POST["update_password"])) {
    $current = $_POST["current_password"] ?? "";
    $new     = $_POST["new_password"] ?? "";
    $confirm = $_POST["confirm_password"] ?? "";

    if ($new !== $confirm) {
        $msgPwd = "❌ New password and confirm password do not match.";
    } else {
        $stmt = $conn->prepare("SELECT password FROM emplist WHERE email=? LIMIT 1");
        $stmt->execute([$email]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row && password_verify($current, $row["password"])) {
            $hash = password_hash($new, PASSWORD_DEFAULT);
            $up   = $conn->prepare("UPDATE emplist SET password=? WHERE email=?");
            $up->execute([$hash, $email]);
            $msgPwd = "✅ Password updated successfully.";
        } else {
            $msgPwd = "❌ Current password is incorrect.";
        }
    }
}

// --- Update PIN ---
if (isset($_POST["update_pin"])) {
    $current = $_POST["current_pin"] ?? "";
    $new     = $_POST["new_pin"] ?? "";
    $confirm = $_POST["confirm_pin"] ?? "";

    if ($new !== $confirm) {
        $msgPin = "❌ New PIN and confirm PIN do not match.";
    } else {
        $stmt = $conn->prepare("SELECT pin FROM emplist WHERE email=? LIMIT 1");
        $stmt->execute([$email]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row && hash_equals((string)$row["pin"], $current)) {
            $up = $conn->prepare("UPDATE emplist SET pin=? WHERE email=?");
            $up->execute([$new, $email]);
            $msgPin = "✅ PIN updated successfully.";
        } else {
            $msgPin = "❌ Current PIN is incorrect.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Update Credentials</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
  <style>
    body { background:#f3f6fa; font-family:"Segoe UI",sans-serif; }
    .card-box {
      border-radius:16px;
      box-shadow:0 6px 18px rgba(0,0,0,.08);
      background:#fff;
      padding:2rem;
      margin-bottom:2rem;
    }
    .form-control { border-radius:12px; padding:.8rem 1rem; }
    .btn-submit { border-radius:12px; font-weight:600; padding:.8rem; }
  </style>
</head>
<body class="bg-gray-100">
<?php include "header.php"; ?>
<div class="flex h-screen">
  <?php include "side_bar.php"; ?>
  <main class="flex-1 p-6 md:ml-64">
    <div class="container py-5">
      <h2 class="mb-4 text-center"><i class="fa-solid fa-user-shield me-2"></i>Update Credentials</h2>

      <div class="row g-4">
        <!-- Update Password -->
        <div class="col-md-6">
          <div class="card-box">
            <h4 class="mb-3 text-primary"><i class="fa-solid fa-lock me-2"></i>Change Password</h4>
            <?php if ($msgPwd): ?>
              <div class="alert <?= str_starts_with($msgPwd,"✅")?"alert-success":"alert-danger" ?>">
                <?= htmlspecialchars($msgPwd) ?>
              </div>
            <?php endif; ?>
            <form method="post">
              <div class="mb-3">
                <label class="form-label">Current Password</label>
                <input type="password" name="current_password" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">New Password</label>
                <input type="password" name="new_password" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Confirm New Password</label>
                <input type="password" name="confirm_password" class="form-control" required>
              </div>
              <button type="submit" name="update_password" class="btn btn-primary btn-submit w-100">Update Password</button>
            </form>
          </div>
        </div>

        <!-- Update PIN -->
        <div class="col-md-6">
          <div class="card-box">
            <h4 class="mb-3 text-success"><i class="fa-solid fa-key me-2"></i>Change PIN</h4>
            <?php if ($msgPin): ?>
              <div class="alert <?= str_starts_with($msgPin,"✅")?"alert-success":"alert-danger" ?>">
                <?= htmlspecialchars($msgPin) ?>
              </div>
            <?php endif; ?>
            <form method="post">
              <div class="mb-3">
                <label class="form-label">Current PIN</label>
                <input type="password" name="current_pin" maxlength="6" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">New PIN</label>
                <input type="password" name="new_pin" maxlength="6" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Confirm New PIN</label>
                <input type="password" name="confirm_pin" maxlength="6" class="form-control" required>
              </div>
              <button type="submit" name="update_pin" class="btn btn-success btn-submit w-100">Update PIN</button>
            </form>
          </div>
        </div>
      </div><!-- /row -->
    </div>
  </main>
</div>
</body>
</html>
