<?php
// side_bar.php â€” Orange/White Sidebar (keeps your exact menu)
// Detect current file for "active" highlighting
$current = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

// Helper to mark active
function is_active($files = []) {
  global $current;
  return in_array($current, (array)$files) ? 'is-active' : '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

  <!-- Tailwind (if you already include globally, remove this) -->
  <script src="https://cdn.tailwindcss.com"></script>
  <!-- Font Awesome 6 -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" referrerpolicy="no-referrer"/>

<style>
  :root{
    --brand:#ff6a00; --brand-600:#ff7a1c; --brand-700:#e45f00;
    --chip:#fff5ed; --line:#f2f2f4; --shadow:0 10px 24px rgba(0,0,0,.08);
    --sbw:270px;           /* expanded width */
    --sbw-c:76px;          /* collapsed width */
  }

  /* Sidebar */
  .sb{ width:var(--sbw); transition:width .25s ease; box-shadow:var(--shadow); }
  .sb .logoBox{ background:var(--chip); color:var(--brand); }
  .sb a.item{ border-radius:12px; transition:transform .12s ease, background .2s ease, color .2s ease; }
  .sb a.item:hover{ background:rgba(255,106,0,.08); transform:translateY(-1px); }
  .sb a.item.is-active{ background:linear-gradient(180deg, rgba(255,122,28,.14), rgba(255,106,0,.14)); outline:1px solid rgba(255,106,0,.35); }
  .sb .item .ico{ color:var(--brand); }
  .sb .badge{ background:var(--chip); color:var(--brand); font-weight:700; }
  .sb .chev{ transition:transform .18s ease; }
  .sb .submenu{ display:none; border-left:2px solid rgba(255,106,0,.2); }
  .sb .submenu.open{ display:block; }
  .sb .submenu a{ border-radius:10px; }
  .sb .submenu a:hover{ background:rgba(255,106,0,.08); }
  .sb .submenu a.is-active{ background:rgba(255,106,0,.14); outline:1px dashed rgba(255,106,0,.35); }
  .groupTitle{ letter-spacing:.12rem }

  /* Collapsed */
  .sb.collapsed{ width:var(--sbw-c); }
  .sb.collapsed .hide-when-collapsed{ display:none !important; }
  .sb.collapsed .item{ justify-content:center; }
  .sb.collapsed .badge,
  .sb.collapsed .chev,
  .sb.collapsed .submenu{ display:none !important; }

  /* Page padding to make room for sidebar */
  .with-sidebar.sidebar-collapsed{ padding-left:var(--sbw-c); }

  /* Mobile drawer */
  @media (max-width:1024px){
    .with-sidebar, .with-sidebar.sidebar-collapsed{ padding-left:0; }
    .sb{ transform:translateX(-100%); position:fixed; }
    .sb.show{ transform:translateX(0); transition:transform .25s ease; }
  }

  /* Hide ALL scrollbars inside the sidebar */
  #appSidebar, #appSidebar * { scrollbar-width:none !important; -ms-overflow-style:none !important; }
  #appSidebar::-webkit-scrollbar, #appSidebar *::-webkit-scrollbar { width:0 !important; height:0 !important; background:transparent !important; }
</style>

</head>


  <!-- Sidebar -->
  <aside id="appSidebar" class="sb fixed top-0 left-0 bottom-0 bg-white border-r border-[var(--line)] flex flex-col z-50">
    <!-- Brand -->
    <div class="flex items-center gap-3 px-4 py-3 border-b border-[var(--line)]">
      <div class="logoBox w-10 h-10 rounded-xl grid place-items-center text-xl font-extrabold">
        <i class="fa-solid fa-bolt"></i>
      </div>
      <div class="hide-when-collapsed">
        <div class="font-bold">Admin</div>
        <div class="text-[11px] text-slate-500">Control Panel</div>
      </div>
      <span class="ml-auto hide-when-collapsed px-2.5 py-1 text-[11px] rounded-full bg-[var(--chip)] text-[var(--brand)] font-semibold">PRO</span>
    </div>

    <!-- Menu -->
    <nav id="sidebarMenu" class="flex-1 overflow-y-auto px-2 py-2">
      <!-- TOP LEVEL -->
      <a style="text-decoration:none;" href="dashboard.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1 <?= is_active(['dashboard.php','index.php']); ?>">
        <i class="ico fa-solid fa-gauge-high w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Dashboard</span>
        <span class="badge hide-when-collapsed ml-auto text-[11px] px-2 py-0.5 rounded-full">New</span>
      </a>
     
      <a style="text-decoration:none;" href="add_bonus.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1 <?= is_active(['add_bonus.php']); ?>">
        <i class="ico fa-solid fa-gift w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Bonus</span>
      </a>
      <a style="text-decoration:none;" href="send_email.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1 <?= is_active(['send_email.php']); ?>">
        <i class="ico fa-solid fa-envelope w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Send Email</span>
      </a>
      <a style="text-decoration:none;" href="news.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1 <?= is_active(['news.php']); ?>">
        <i class="ico fa-solid fa-newspaper w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">News</span>
      </a>
 <a style="text-decoration:none;" href="change_mt5_leverage.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1 <?= is_active(['change_mt5_leverage.php']); ?>">
        <i class="ico fa-solid fa-key w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Change Mt5 Leverage</span>
      </a> 
      <!-- GROUP: User Management -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">User Management</div>
      <button data-sub="#sub-user" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-users w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">User Management</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-user" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="user_list.php" class="block px-3 py-2 my-1 <?= is_active(['user_list.php']); ?>">Clients List</a>
        <a style="text-decoration:none;" href="liveaccount.php" class="block px-3 py-2 my-1 <?= is_active(['liveaccount.php']); ?>">Clients Live Account</a>
        <a style="text-decoration:none;" href="follow_up_list.php" class="block px-3 py-2 my-1 <?= is_active(['follow_up_list.php']); ?>">Follow Up List</a>
        <a style="text-decoration:none;" href="kyc.php" class="block px-3 py-2 my-1 <?= is_active(['kyc.php']); ?>">Pending Document</a>
        <a style="text-decoration:none;" href="approved_kyc.php" class="block px-3 py-2 my-1 <?= is_active(['approved_kyc.php']); ?>">Approved Document</a>
        <a style="text-decoration:none;" href="change_password.php" class="block px-3 py-2 my-1 <?= is_active(['change_password.php']); ?>">Change User Password</a>
        <a style="text-decoration:none;" href="change_user_leverage.php" class="block px-3 py-2 my-1 <?= is_active(['change_user_leverage.php']); ?>">Update MT5 Leverage</a>
      <a style="text-decoration:none;" href="change_mt5_password.php" class="block px-3 py-2 my-1 <?= is_active(['change_mt5_password.php']); ?>">
        <!--<i class="ico fa-solid fa-key w-5 text-center"></i>-->
        Change Mt5 Password
      </a> </div>

      <!-- GROUP: IB Management -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">IB Management</div>
      <button data-sub="#sub-ib" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-user-tie w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">IB Management</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-ib" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="ib_users.php" class="block px-3 py-2 my-1 <?= is_active(['ib_users.php']); ?>">IB Users</a>
        <a style="text-decoration:none;" href="ib_request.php" class="block px-3 py-2 my-1 <?= is_active(['ib_request.php']); ?>">IB Requests</a>
        <a style="text-decoration:none;" href="ib_plan_list.php" class="block px-3 py-2 my-1 <?= is_active(['ib_plan_list.php']); ?>">IB Plan</a>
        <a style="text-decoration:none;" href="add_ib_commission.php" class="block px-3 py-2 my-1 <?= is_active(['add_ib_commission.php']); ?>">Set IB Commission</a>
        <a style="text-decoration:none;" href="add_client_ib.php" class="block px-3 py-2 my-1 <?= is_active(['add_client_ib.php']); ?>">Move Client to IB</a>
      </div>

      <!-- GROUP: Group Management -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Group Management</div>
      <button data-sub="#sub-group" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-layer-group w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Group Management</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-group" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="add_group.php" class="block px-3 py-2 my-1 <?= is_active(['add_group.php']); ?>">ADD Group</a>
        <a style="text-decoration:none;" href="add_mt5_group.php" class="block px-3 py-2 my-1 <?= is_active(['add_mt5_group.php']); ?>">ADD MT5 Group</a>
      </div>

      <!-- GROUP: Transaction -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Transaction</div>
      <button data-sub="#sub-txn" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-money-check-dollar w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Transaction</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-txn" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="wallet_deposit.php" class="block px-3 py-2 my-1 <?= is_active(['wallet_deposit.php']); ?>">Pending Deposit</a>
        <a style="text-decoration:none;" href="approved_deposit.php" class="block px-3 py-2 my-1 <?= is_active(['approved_deposit.php']); ?>">Approved Deposit</a>
        <a style="text-decoration:none;" href="declined_deposit.php" class="block px-3 py-2 my-1 <?= is_active(['declined_deposit.php']); ?>">Declined Deposit</a>
        <a style="text-decoration:none;" href="wallet_withdraw.php" class="block px-3 py-2 my-1 <?= is_active(['wallet_withdraw.php']); ?>">Pending Withdrawal</a>
        <a style="text-decoration:none;" href="approved_withdraw.php" class="block px-3 py-2 my-1 <?= is_active(['approved_withdraw.php']); ?>">Approved Withdrawal</a>
        <a style="text-decoration:none;" href="declined_withdraw.php" class="block px-3 py-2 my-1 <?= is_active(['declined_withdraw.php']); ?>">Declined Withdrawal</a>
        <a style="text-decoration:none;" href="ib_withdrawal.php" class="block px-3 py-2 my-1 <?= is_active(['ib_withdrawal.php']); ?>">Pending IB Withdrawal</a>
      </div>

      <!-- GROUP: Marketing -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Marketing</div>
      <button data-sub="#sub-mkt" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-bullhorn w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Marketing</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-mkt" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="add_marketing.php" class="block px-3 py-2 my-1 <?= is_active(['add_marketing.php']); ?>">Add Marketing</a>
        <a style="text-decoration:none;" href="marketing_list.php" class="block px-3 py-2 my-1 <?= is_active(['marketing_list.php']); ?>">Marketing List</a>
        <a style="text-decoration:none;" href="incentive_list.php" class="block px-3 py-2 my-1 <?= is_active(['incentive_list.php']); ?>">Incentive Report</a>
        <a style="text-decoration:none;" href="mark_withdraw_report.php" class="block px-3 py-2 my-1 <?= is_active(['mark_withdraw_report.php']); ?>">Marketing Withdraw Report</a>
        <a style="text-decoration:none;" href="bulk_upload.php" class="block px-3 py-2 my-1 <?= is_active(['bulk_upload.php']); ?>">Bulk Lead Upload</a>
        <a style="text-decoration:none;" href="load_list" class="block px-3 py-2 my-1 <?= is_active(['load_list']); ?>">Load List</a>
      </div>

      <!-- GROUP: Pamm Copier -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Pamm Copier</div>
      <button data-sub="#sub-pamm" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-copy w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Pamm Copier</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-pamm" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="investor_pamm_request.php" class="block px-3 py-2 my-1 <?= is_active(['investor_pamm_request.php']); ?>">PAMM Investor Requests</a>
        <a style="text-decoration:none;" href="manager_pamm_request.php" class="block px-3 py-2 my-1 <?= is_active(['manager_pamm_request.php']); ?>">PAMM MM Requests</a>
        <a style="text-decoration:none;" href="slave_copier_request.php" class="block px-3 py-2 my-1 <?= is_active(['slave_copier_request.php']); ?>">Slave Copier Requests</a>
        <a style="text-decoration:none;" href="master_copier_request.php" class="block px-3 py-2 my-1 <?= is_active(['master_copier_request.php']); ?>">Master Copier Requests</a>
      </div>

      <!-- GROUP: Reward Management -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Reward Management</div>
      <button data-sub="#sub-reward" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-trophy w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Reward Management</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-reward" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="add_reward.php" class="block px-3 py-2 my-1 <?= is_active(['add_reward.php']); ?>">ADD Rewards</a>
        <a style="text-decoration:none;" href="reward_list.php" class="block px-3 py-2 my-1 <?= is_active(['reward_list.php']); ?>">Rewards List</a>
      </div>

      <!-- All Reports (top-level) -->
      <a style="text-decoration:none;" href="#" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1">
        <i class="ico fa-solid fa-chart-line w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">All Reports</span>
      </a>

      <!-- GROUP: Risk Management Report -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Risk Management Report</div>
      <button data-sub="#sub-risk" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-shield-halved w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Risk Management Reports</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-risk" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="risk_management_profit.php" class="block px-3 py-2 my-1 <?= is_active(['risk_management_profit.php']); ?>">Profit Risk Report</a>
        <a style="text-decoration:none;" href="#" class="block px-3 py-2 my-1">scalping Trade Report</a>
      </div>

      <!-- Tickets (top-level) -->
      <a style="text-decoration:none;" href="tickets.php" class="item flex items-center gap-3 px-3 py-2 mx-1 my-1">
        <i class="ico fa-solid fa-ticket w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Tickets</span>
      </a>

      <!-- GROUP: Settings -->
      <div class="hide-when-collapsed mt-4 mb-1 px-3 text-[11px] uppercase tracking-widest text-slate-500 groupTitle">Settings</div>
      <button data-sub="#sub-settings" class="w-full item flex items-center gap-3 px-3 py-2 mx-1 my-1 submenu-toggle">
        <i class="ico fa-solid fa-gear w-5 text-center"></i>
        <span class="hide-when-collapsed font-medium">Settings</span>
        <i class="chev fa-solid fa-chevron-right ml-auto text-slate-500"></i>
      </button>
      <div id="sub-settings" class="submenu ml-3 pl-2">
        <a style="text-decoration:none;" href="#" class="block px-3 py-2 my-1">Deposit Bank Details</a>
        <a style="text-decoration:none;" href="#" class="block px-3 py-2 my-1">Promotion List</a>
        <a style="text-decoration:none;" href="#" class="block px-3 py-2 my-1">PSP Setting</a>
        <a style="text-decoration:none;" href="#" class="block px-3 py-2 my-1">Default Setting</a>
      </div>
    </nav>

    <!-- Footer card -->
    <div class="px-3 py-3 border-t border-[var(--line)]">
      <div class="flex items-center gap-3 rounded-xl border border-orange-200 bg-[var(--chip)] px-3 py-2">
        <div class="w-9 h-9 rounded-lg bg-[var(--brand)] grid place-items-center text-white">
          <i class="fa-solid fa-crown"></i>
        </div>
        <div class="text-sm">
          <div class="font-semibold">Upgrade</div>
          <div class="text-xs text-slate-600">Get advanced reports & automations</div>
        </div>
        <a style="text-decoration:none;" href="#" class="ml-auto text-xs font-bold px-2.5 py-1 rounded-lg text-white" style="background:var(--brand)">Go PRO</a>
      </div>
    </div>
  </aside>



<script>
(function(){
  const sb = document.getElementById('appSidebar');
  const STORAGE = { collapsed:'sb_collapsed', open:'sb_open_subs' };

  // Always add page padding class
  document.body.classList.add('with-sidebar');

  // Start expanded on desktop by default; use saved state if present
  const persisted = localStorage.getItem(STORAGE.collapsed);
  const startCollapsed = (window.innerWidth > 1024) ? (persisted === '1') : false;

  sb.classList.toggle('collapsed', startCollapsed);
  document.body.classList.toggle('sidebar-collapsed', startCollapsed);

  // Restore open submenus
  const openIds = JSON.parse(localStorage.getItem(STORAGE.open) || '[]');
  openIds.forEach(id => {
    const el = document.querySelector(id);
    if (el) el.classList.add('open');
    const t = document.querySelector('[data-sub="'+id+'"] .chev');
    if (t) t.style.transform = 'rotate(90deg)';
  });

  // Submenu toggles
// Submenu toggles (accordion behavior)
document.querySelectorAll('.submenu-toggle').forEach(btn => {
  btn.addEventListener('click', () => {
    const id   = btn.getAttribute('data-sub');
    const sub  = document.querySelector(id);
    const chev = btn.querySelector('.chev');
    if (!sub) return;

    // 1) Close all other submenus
    document.querySelectorAll('.submenu.open').forEach(openSub => {
      if (openSub !== sub) {
        openSub.classList.remove('open');
        // reset chevron of other toggles
        const otherToggle = document.querySelector('[data-sub="#' + openSub.id + '"] .chev');
        if (otherToggle) otherToggle.style.transform = 'rotate(0deg)';
      }
    });

    // 2) Toggle the clicked submenu
    sub.classList.toggle('open');
    if (chev) chev.style.transform = sub.classList.contains('open') ? 'rotate(90deg)' : 'rotate(0deg)';

    // 3) Save open submenu state
    const ids = Array.from(document.querySelectorAll('.submenu.open')).map(x => '#' + x.id);
    localStorage.setItem(STORAGE.open, JSON.stringify(ids));
  });
});


  // Header toggle support (desktop collapse / mobile drawer)
  document.addEventListener('click', (e)=>{
    const toggle = e.target.closest('#sidebarToggle');
    if (!toggle) return;

    if(window.innerWidth <= 1024){
      sb.classList.toggle('show');              // mobile drawer
      return;
    }
    sb.classList.toggle('collapsed');           // desktop collapse
    const collapsed = sb.classList.contains('collapsed');
    document.body.classList.toggle('sidebar-collapsed', collapsed);
    localStorage.setItem(STORAGE.collapsed, collapsed ? '1' : '0');
  });
})();
</script>


</html>