
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Follow Up Details</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100">

<div class="flex h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 ml-64">
        <!-- Top Navigation -->
          

        <!-- Follow Up Details -->
        <div class="container ">
                        <input type="text" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-1/3">

            <h2 class="text-2xl font-bold text-gray-700 mb-6">Follow Up Details</h2>

            <div class="grid grid-cols-1 gap-4">
                <!-- Follow-up Information -->
                <div class="p-4">
                    <p><strong>ID:</strong> <?php echo $row['id']; ?></p>
                    <p><strong>Name:</strong> <?php echo $row['name']; ?></p>
                    <p><strong>Email:</strong> <?php echo $row['email']; ?></p>
                    <p><strong>Country:</strong> <?php echo $row['country']; ?></p>
                    <p><strong>Document Type:</strong> <?php echo $row['document_type']; ?></p>
                    <p><strong>Status:</strong> <span class="<?php echo $row['status'] == 'Approved' ? 'text-green-500' : 'text-red-500'; ?>"><?php echo $row['status']; ?></span></p>
                    <p><strong>Date:</strong> <?php echo $row['date']; ?></p>
                    <p><strong>Comment:</strong> <?php echo $row['comment']; ?></p>
                </div>

                <!-- Document Image -->
                <div class="p-4">
                    <p><strong>Document Image:</strong></p>
                    <img src="<?php echo $row['document_image']; ?>" alt="Document Image" class="w-1/2 mt-4 rounded-lg shadow-lg">
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex space-x-4 mt-6">
                <form action="accept_follow_up.php" method="POST">
                    <input type="hidden" name="follow_up_id" value="<?php echo $row['id']; ?>">
                    <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-md">Accept</button>
                </form>
                <form action="reject_follow_up.php" method="POST">
                    <input type="hidden" name="follow_up_id" value="<?php echo $row['id']; ?>">
                    <button type="submit" class="bg-red-600 text-white px-6 py-2 rounded-md">Reject</button>
                </form>
            </div>
        </div><?php include "footer.php";?>
    </main>
</div>

<?php //include "footer.php";?>

</body>
</html>

<?php
// Close the database connection
$conn->close();
?>
