<?php
// Connect to your database
$conn = new mysqli('localhost', 'username', 'password', 'database_name');

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the follow-up ID from the form submission
$follow_up_id = isset($_POST['follow_up_id']) ? $_POST['follow_up_id'] : null;

// If no ID is provided, redirect to the follow-up list
if ($follow_up_id === null) {
    header("Location: follow_up_list.php");
    exit();
}

// Update the status of the follow-up to 'Accepted'
$sql = "UPDATE follow_ups SET status = 'Accepted' WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $follow_up_id);
$stmt->execute();

// Check if the update was successful
if ($stmt->affected_rows > 0) {
    // Redirect to the follow-up list page with a success message
    header("Location: follow_up_list.php?status=accepted");
    exit();
} else {
    // Redirect to the follow-up list page with an error message
    header("Location: follow_up_list.php?status=error");
    exit();
}

// Close the database connection
$conn->close();
?>
