<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add User</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
  <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
        <div class="container mx-auto p-8 w-full max-w-5xl bg-white rounded-2xl shadow-lg">
            <h2 class="text-3xl font-bold text-[#CD7F32] mb-6 text-center">Add New User</h2>

            <form action="add_user.php" method="POST" class="w-full">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Username -->
                    <div>
                        <label for="username" class="block text-[#CD7F32] text-lg font-semibold mb-2">Username:</label>
                        <input type="text" id="username" name="username" required class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" placeholder="Enter username">
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-[#CD7F32] text-lg font-semibold mb-2">Email:</label>
                        <input type="email" id="email" name="email" required class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" placeholder="Enter email">
                    </div>

                    <!-- Password -->
                    <div>
                        <label for="password" class="block text-[#CD7F32] text-lg font-semibold mb-2">Password:</label>
                        <input type="password" id="password" name="password" required class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" placeholder="Enter password">
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-8 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                        Add User
                    </button>
                </div>
            </form>
        </div>
    </div><br><br><br>
</main>
    </div> <!-- End of Flex Container -->
<?php include "footer.php";?>
</body>

</html>
