<?php
// Dummy data (not fetching from database)
$clients = [
    1 => 'John Doe',
    2 => 'Jane Smith',
    3 => 'Michael Johnson'
];

$mt5_ids = [
    1 => 'MT5-1001',
    2 => 'MT5-1002',
    3 => 'MT5-1003'
];

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $client_id = $_POST['client_id'];
    $mt5_id = $_POST['mt5_id'];
    $amount = $_POST['amount'];
    $comment = $_POST['comment'];

    echo "✅ Withdrawal Processed: <br> 
          🔹 Client ID: $client_id <br> 
          🔹 MT5 ID: $mt5_id <br> 
          🔹 Amount: $$amount <br> 
          🔹 Comment: $comment";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Withdrawal</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
<?php include "header.php"; ?>

<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
         <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Client Withdrawal</h1>

            <!-- Withdrawal Form -->
            <form action="withdrawal.php" method="POST" class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow-lg border border-gray-200">

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Select Client -->
                    <div>
                        <label for="client_id" class="block text-lg font-semibold text-[#CD7F32] mb-2">Select Client:</label>
                        <select id="client_id" name="client_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" required>
                            <option value="">-- Select Client --</option>
                            <?php foreach ($clients as $id => $name): ?>
                                <option value="<?php echo $id; ?>" <?php echo ($id == 1) ? 'selected' : ''; ?>>
                                    <?php echo $name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Select MT5 ID -->
                    <div>
                        <label for="mt5_id" class="block text-lg font-semibold text-[#CD7F32] mb-2">Select MT5 ID:</label>
                        <select id="mt5_id" name="mt5_id" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" required>
                            <option value="">-- Select MT5 ID --</option>
                            <?php foreach ($mt5_ids as $id => $name): ?>
                                <option value="<?php echo $id; ?>" <?php echo ($id == 1) ? 'selected' : ''; ?>>
                                    <?php echo $name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <!-- Withdrawal Amount -->
                <div class="mt-6">
                    <label for="amount" class="block text-lg font-semibold text-[#CD7F32] mb-2">Withdrawal Amount:</label>
                    <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" required placeholder="Enter amount" min="1" value="100">
                </div>

                <!-- Comment -->
                <div class="mt-6">
                    <label for="comment" class="block text-lg font-semibold text-[#CD7F32] mb-2">Comment:</label>
                    <textarea id="comment" name="comment" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] focus:outline-none" rows="3" placeholder="Optional comment">Test withdrawal</textarea>
                </div>

                <!-- Submit Button -->
                <div class="mt-8 text-center">
                    <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                        Process Withdrawal
                    </button>
                </div>
            </form>
        </div>
<br>
       
    </main> <?php include "footer.php"; ?>
</div>

</body>
</html>
