<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bank Details List</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
<div class="flex flex-col md:flex-row h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>
<style>
/* Container styling */
.container {
    margin-bottom: 1.5rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

/* Table styling */
.table {
    width: 100%;
    border-collapse: collapse;
    background-color: white;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    overflow: hidden;
}

.table thead {
    background-color: #CD7F32;
    color: white;
}

.table th {
    padding: 12px 16px;
    text-align: left;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 14px;
    letter-spacing: 0.5px;
}

.table td {
    padding: 12px 16px;
    border-bottom: 1px solid #e5e7eb;
    vertical-align: middle;
}

.table tbody tr:hover {
    background-color: #f9fafb;
}

/* Status badges */
.btn-dark {
    display: inline-block;
    padding: 5px 20px;
    font-size: 12px;
    border-radius: 20px;
    text-align: center;
    font-weight: 500;
}

/* Input and select styling */
#search, #status-filter {
    padding: 10px 16px;
    border: 1px solid #d1d5db;
    border-radius: 8px;
    font-size: 14px;
    transition: all 0.2s ease;
    background-color: white;
}

#search:focus, #status-filter:focus {
    outline: none;
    border-color: #CD7F32;
    box-shadow: 0 0 0 2px rgba(205, 127, 50, 0.2);
}

/* Pagination styling */
.mt-4 nav ul {
    display: flex;
    gap: 0.5rem;
    list-style: none;
    padding: 0;
}

.mt-4 nav ul li a {
    display: block;
    padding: 8px 16px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    text-decoration: none;
    color: #374151;
    font-weight: 500;
    transition: all 0.2s ease;
}

.mt-4 nav ul li a:hover {
    background-color: #f3f4f6;
}

.mt-4 nav ul li a.bg-\[\#CD7F32\] {
    background-color: #CD7F32;
    color: white;
    border-color: #CD7F32;
}

/* Modal styling */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
}

.modal-dialog {
    position: relative;
    margin: 10% auto;
    width: 90%;
    max-width: 600px;
}

.modal-content {
    background-color: white;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
}

.modal-header {
    padding: 20px;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-title {
    font-size: 20px;
    font-weight: 600;
    color: #dc2626;
    margin: 0;
}

.modal-body {
    padding: 20px;
    background-color: #ededed;
}

.modal-footer {
    padding: 20px;
    border-top: 1px solid #e5e7eb;
    text-align: right;
}

.close {
    font-size: 24px;
    font-weight: bold;
    color: #6b7280;
    cursor: pointer;
    border: none;
    background: none;
}

.close:hover {
    color: #374151;
}

/* Responsive design */
@media (min-width: 768px) {
    .container {
        flex-direction: row;
        justify-content: space-between;
        align-items: center;
    }
    
    #search {
        width: 33.333%;
    }
    
    #status-filter {
        width: 25%;
    }
}

@media (max-width: 767px) {
    .table {
        display: block;
        overflow-x: auto;
    }
    
    .table th,
    .table td {
        padding: 8px 12px;
        font-size: 14px;
    }
    
    .modal-dialog {
        margin: 5% auto;
        width: 95%;
    }
}

/* Animation for modal */
.modal.fade {
    transition: opacity 0.15s linear;
}

.modal.fade:not(.show) {
    opacity: 0;
}

.modal-dialog {
    transition: transform 0.3s ease-out;
    transform: translate(0, -50px);
}

.modal.fade.show .modal-dialog {
    transform: translate(0, 0);
}
</style>
    <!-- Main Content -->
   <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container"><!-- Search Input -->
            <input type="text" id="search" placeholder="Search..." class="p-2 border border-gray-300 rounded-lg w-full md:w-1/3 mb-4 md:mb-0 focus:ring-2 focus:ring-[#CD7F32]" oninput="filterTable()">

            <!-- Filter Dropdown for Status -->
            <select id="status-filter" class="p-2 border border-gray-300 rounded-lg w-full md:w-1/4 focus:ring-2 focus:ring-[#CD7F32]" onchange="filterTable()">
                <option value="">All Status</option>
                <option value="pending">Pending</option>
                <option value="approved">Approved</option>
            </select>
        </div>

        <!-- Table Section -->
        <div class="container mx-auto p-6">
            <h2 class="text-2xl font-bold text-[#CD7F32] mb-4">Bank Details List</h2>
<br>
            <div class="overflow-x-auto">
            <table id="example" class="table table-striped mb-0">
              <thead>
                <tr>
                  <th>ID</th>
                  <th>Email</th>
                  <th>Name</th>
                  <th>Bank</th>
                  <th>Acc No</th>
                  <th>IFSC</th>
                  <th>SWIFT</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $sql = "SELECT * from aspnetusers order by reg_date";
                $query = $dbh -> prepare($sql);
                $query->execute();
                $results=$query->fetchAll(PDO::FETCH_OBJ);
                $cnt=1;
                if($query->rowCount() > 0)
                {
                  foreach($results as $result)
                  {
                    ?>
                    <tr>
                      <td>
                        <div> <?php echo htmlentities($result->id);?></div>
                      </td>
                      <td>
                        <div> <?php echo htmlentities($result->email);?></div>
                      </td>
                      <td>
                        <div class="amount">
                          <?php echo htmlentities($result->fullname);?>
                        </div>
                      </td>
                      <td>
                        <div class="amount">
                          <?php echo htmlentities($result->bank_name);?>
                        </div>
                      </td>
                      <td>
                        <div><?php echo htmlentities($result->bank_account_no);?></div>
                      </td>
                      <td>
                        <div><?php echo htmlentities($result->IFSC_Code);?></div>
                      </td>
                      <td>
                        <div><?php echo htmlentities($result->swift_code);?></div>
                      </td>
                      <td>
                        <div style="padding-top: 10px;"> 
                         <?php
                                  $stats=$result->bank_status;
                                  if($stats==0)
                                  {
                                    ?>
                                     <p class="btn-dark btn-sm " style="padding: 5px 20px;font-size: 12px;color:red;">
                        Not Updated</p>
                                    <?php
                                  }
                                  if($stats==1)
                                  {
                                    ?>
                                    <p class="btn-dark btn-sm " style="padding: 5px 20px;font-size: 12px;color:white;">
                        Updated</p>
                                    <?php
                                  }
                                  ?>
                       
                        </div>
                      </td>
                      <!-- platform model -->
                      <div class="modal fade" id="exampleModal-2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2" aria-hidden="true" style="display: none;">
                        <div class="modal-dialog" role="document">
                          <div class="modal-content">
                            <div class="modal-header" style="background-color: white;">
                              <center>
                                 <h3 class="modal-title" id="exampleModalLabel-2" style="color:red;">Client Bank Details Proof</h3>
                              </center>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                              </button>
                            </div>
                            <div class="modal-body" style="background-color: #ededed;">
                              <div class="row" style="padding-top:24px;">
                                <div class="col-md-12">
                                  <img src="http://client.zarafx.uk/_docs/<?php echo htmlentities($result->bank_detail);?>" style="width:100%;height:100%">
                                </div>
                              </div>
                            </div>
                            <div class="modal-footer">
                              <button style="padding: 5px 20px;font-size: 16px;" type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </tr>
                  <?php }}?>
                </tbody>
              </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <nav>
                    <ul class="flex justify-center space-x-2">
                        <?php
                        for ($i = 1; $i <= $total_pages; $i++) {
                            echo "<li><a href='?page=$i&status=$status_filter' class='p-2 border rounded " . ($page == $i ? 'bg-[#CD7F32] text-white' : 'bg-gray-200 hover:bg-gray-300 transition') . "'>$i</a></li>";
                        }
                        ?>
                    </ul>
                </nav>
            </div>
        </div> 
    </main><?php include "footer.php";?>
</div>

    <!-- Footer -->
   

    <script>
        // Function to filter the table based on search input and status filter
        function filterTable() {
            const searchInput = document.getElementById("search").value.toLowerCase();
            const statusFilter = document.getElementById("status-filter").value;
            const tableRows = document.querySelectorAll("#table-body tr");

            tableRows.forEach(row => {
                const cells = row.querySelectorAll("td");
                let match = false;

                // Loop through each cell and check if it contains the search input or status filter
                cells.forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchInput)) {
                        match = true;
                    }
                });

                // Show or hide the row based on match
                row.style.display = match && (statusFilter === "" || row.cells[9].textContent.toLowerCase().includes(statusFilter.toLowerCase())) ? "" : "none";
            });
        }
    </script>
</body>
</html>
