<?php
// Hardcoded commission data for example purposes
$commission_id = $_GET['id'] ?? 1; // Default ID if not provided
$plans = ["Plan A", "Plan B", "Plan C"];
$groups = ["Group 1", "Group 2", "Group 3"];

// Default values for the commission form
$plan_name = "Plan A";
$group_name = "Group 1";
$level_commissions = [
    "level_1_commission" => 50,
    "level_2_commission" => 45,
    "level_3_commission" => 40,
    "level_4_commission" => 35,
    "level_5_commission" => 30,
    "level_6_commission" => 25,
    "level_7_commission" => 20,
    "level_8_commission" => 15,
    "level_9_commission" => 10,
    "level_10_commission" => 5
];

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $plan_name = $_POST['plan_name'];
    $group_name = $_POST['group_name'];

    // Loop through the commissions and update values
    for ($i = 1; $i <= 10; $i++) {
        $level_commissions["level_{$i}_commission"] = $_POST["level_{$i}_commission"];
    }

    echo "<p class='text-green-600 font-bold text-center mt-4'>Commission Updated Successfully!</p>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Commission</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

   <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container"> 
     <h1 class="text-3xl font-bold text-center mb-6" style="color:#CD7F32;">Edit Commission</h1>

        <!-- Edit Commission Form -->
        <form action="" method="POST" class="max-w-5xl mx-auto bg-white p-8 rounded-lg shadow-md">
            
            <!-- Select Plan and Group in One Row -->
            <div class="grid grid-cols-2 gap-6 mb-6">
                <!-- Select Plan Dropdown -->
                <div>
                    <label for="plan_name" class="block text-gray-600 text-lg font-medium mb-2">Select Plan:</label>
                    <select id="plan_name" name="plan_name" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600">
                        <?php foreach ($plans as $plan): ?>
                            <option value="<?= $plan ?>" <?= ($plan == $plan_name) ? "selected" : "" ?>><?= $plan ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <!-- Select Group Dropdown -->
                <div>
                    <label for="group_name" class="block text-gray-600 text-lg font-medium mb-2">Select Group:</label>
                    <select id="group_name" name="group_name" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600">
                        <?php foreach ($groups as $group): ?>
                            <option value="<?= $group ?>" <?= ($group == $group_name) ? "selected" : "" ?>><?= $group ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <!-- Level 1 to Level 10 Commission Inputs (Grouped in Three Columns) -->
            <div class="grid grid-cols-3 gap-6">
                <?php foreach ($level_commissions as $level => $value): ?>
                    <div>
                        <label for="<?= $level ?>" class="block text-gray-600 text-lg font-medium mb-2">
                            <?= str_replace("_", " ", ucfirst($level)) ?>:
                        </label>
                        <input type="number" step="0.01" id="<?= $level ?>" name="<?= $level ?>" value="<?= $value ?>"
                            class="w-full px-4 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-600" required>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full py-4 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-blue-700 transition duration-300 mt-6">
                Update Commission
            </button>
        </form>
    </div>
    <br><br><br>
</main>
<?php include "footer.php";?>
</div>
</body>
</html>
