<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Sub-Admin Permissions</title>
    <style>
        /* General Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 0;
            color: #CD7F32;
        }

        .container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 20px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            background-color: #fff;
        }

        h2 {
            font-size: 28px;
            color: #CD7F32;
            text-align: center;
            margin-bottom: 20px;
        }

        /* Form Layout */
        .form-group {
            margin-bottom: 20px;
            display: flex;
            flex-direction: column;
        }

        label {
            font-size: 16px;
            margin-bottom: 8px;
            color: #CD7F32;
        }

        select, button {
            padding: 12px;
            border-radius: 8px;
            border: 1px solid #ddd;
            font-size: 16px;
        }

        select {
            width: 100%;
        }

      button {
    background-color: #CD7F32;
    color: white;
    cursor: pointer;
    border: none;
    padding: 25px 40px; /* Increased padding for larger button size */
    font-size: 28px; /* Increased font size */
    border-radius: 14px;
    margin-top: 20px;
    transition: background-color 0.3s ease;
}

button:hover {
    background-color: #b07829;
    color:white;
}


        /* Permissions Section Styles */
        .permissions-section {
            margin: 20px 0;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }

        .permissions-section h3 {
            margin-bottom: 15px;
            color: #444;
            font-size: 20px;
            border-bottom: 2px solid #eee;
            padding-bottom: 5px;
        }

        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 10px;
        }

        .checkbox-group label {
            font-size: 14px;
            color: #CD7F32;
            display: inline-block;
            margin-left: 10px;
        }

        .checkbox-group input {
            margin-right: 8px;
            transform: scale(1.1);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }

            .form-group {
                margin-bottom: 15px;
            }

            .permissions-section h3 {
                font-size: 18px;
            }

            .checkbox-group {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
     <div class="container">
        <h2>Edit Sub-Admin Permissions</h2>

        <!-- Permissions Form -->
        <form id="permissionForm">
            <!-- Sub-Admin Selection -->
            <div class="form-group">
                <label for="subAdmin">Select Sub-Admin:</label>
                <select id="subAdmin" name="subAdmin" required>
                    <option value="1">John Doe</option>
                    <option value="2">Jane Smith</option>
                    <option value="3">Alice Johnson</option>
                </select>
            </div>

            <!-- User Management Section -->
            <div class="permissions-section">
                <h3>User Management</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="addUser" name="userPermissions" value="add">
                        <label for="addUser">Add User</label>
                    </div>
                    <div>
                        <input type="checkbox" id="editUser" name="userPermissions" value="edit">
                        <label for="editUser">Edit User</label>
                    </div>
                    <div>
                        <input type="checkbox" id="deleteUser" name="userPermissions" value="delete">
                        <label for="deleteUser">Delete User</label>
                    </div>
                    <div>
                        <input type="checkbox" id="userList" name="userPermissions" value="list">
                        <label for="userList">View User List</label>
                    </div>
                </div>
            </div>

            <!-- Bonus Section -->
            <div class="permissions-section">
                <h3>Bonus Section</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="addBonus" name="bonusPermissions" value="add">
                        <label for="addBonus">Add Bonus</label>
                    </div>
                    <div>
                        <input type="checkbox" id="editBonus" name="bonusPermissions" value="edit">
                        <label for="editBonus">Edit Bonus</label>
                    </div>
                    <div>
                        <input type="checkbox" id="deleteBonus" name="bonusPermissions" value="delete">
                        <label for="deleteBonus">Delete Bonus</label>
                    </div>
                    <div>
                        <input type="checkbox" id="bonusList" name="bonusPermissions" value="list">
                        <label for="bonusList">View Bonus List</label>
                    </div>
                </div>
            </div>

            <!-- Ticket Management Section -->
            <div class="permissions-section">
                <h3>Ticket Management</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="ticketManagement" name="ticketPermissions" value="tickets">
                        <label for="ticketManagement">Manage Tickets</label>
                    </div>
                </div>
            </div>

            <!-- Rewards Management Section -->
            <div class="permissions-section">
                <h3>Rewards Management</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="rewardList" name="rewardPermissions" value="list">
                        <label for="rewardList">View Rewards List</label>
                    </div>
                    <div>
                        <input type="checkbox" id="addReward" name="rewardPermissions" value="add">
                        <label for="addReward">Add Reward</label>
                    </div>
                </div>
            </div>

            <!-- Settings Management Section -->
            <div class="permissions-section">
                <h3>Settings Management</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="depositBank" name="settingsPermissions" value="depositBank">
                        <label for="depositBank">Manage Deposit Bank Details</label>
                    </div>
                    <div>
                        <input type="checkbox" id="promotionList" name="settingsPermissions" value="promotionList">
                        <label for="promotionList">View Promotion List</label>
                    </div>
                    <div>
                        <input type="checkbox" id="pspSetting" name="settingsPermissions" value="pspSetting">
                        <label for="pspSetting">Manage PSP Settings</label>
                    </div>
                    <div>
                        <input type="checkbox" id="defaultSetting" name="settingsPermissions" value="defaultSetting">
                        <label for="defaultSetting">Manage Default Settings</label>
                    </div>
                </div>
            </div>

            <!-- Sub-Admin Section -->
            <div class="permissions-section">
                <h3>Sub-Admin Section</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="createSubAdmin" name="subAdminPermissions" value="create">
                        <label for="createSubAdmin">Create Sub-Admin</label>
                    </div>
                    <div>
                        <input type="checkbox" id="listSubAdmin" name="subAdminPermissions" value="list">
                        <label for="listSubAdmin">View Sub-Admin List</label>
                    </div>
                    <div>
                        <input type="checkbox" id="addPermission" name="subAdminPermissions" value="addPermission">
                        <label for="addPermission">Add Permission</label>
                    </div>
                    <div>
                        <input type="checkbox" id="editPermission" name="subAdminPermissions" value="editPermission">
                        <label for="editPermission">Edit Permission</label>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
           <center> <button type="submit">Submit</button></center>
        </form>
    </div><br><br><?php include "footer.php";?></main>
    </div>

    <script>
        document.getElementById('permissionForm').addEventListener('submit', function (event) {
            event.preventDefault();
            alert("Permissions updated successfully!");
        });
    </script>
</body>
</html>
