<?php
@session_start();
$displayName = $_SESSION['cname'] ?? $_SESSION['clogin'] ?? 'Admin';
$email       = $_SESSION['cemail'] ?? (strpos($_SESSION['clogin'] ?? '', '@') !== false ? $_SESSION['clogin'] : '');
function initials($nameOrEmail) {
  $s = trim($nameOrEmail ?: 'A');
  if (strpos($s, '@') !== false) $s = strstr($s, '@', true);
  $parts = preg_split('/[\s._-]+/', $s);
  $letters = '';
  foreach ($parts as $p) { if ($p !== '') { $letters .= mb_strtoupper(mb_substr($p,0,1)); if (mb_strlen($letters)===2) break; } }
  return $letters ?: 'A';
}
$avatar = initials($displayName ?: $email);
?>
<style>:root { --header-h: 56px; } /* will be updated by JS to match your header height */

/* Keep the header above everything */
header.sticky { z-index: 10000 !important; }

/* Sidebar sits BELOW header and fills rest of the screen */
#sidebar {
  position: fixed;
  left: 0;
  top: var(--header-h) !important;
  height: calc(100dvh - var(--header-h)) !important;
  width: 16rem;                 /* adjust if needed */
  transform: translateX(-100%); /* hidden by default on mobile */
  transition: transform .28s ease;
  z-index: 9990;                /* below the header */
  overflow-y: auto;
}

/* When body has .sidebar-open, show the sidebar */
body.sidebar-open #sidebar { transform: translateX(0); }

/* Backdrop covers only the area below the header */
#sidebarBackdrop {
  position: fixed;
  left: 0;
  top: var(--header-h);
  width: 100%;
  height: calc(100dvh - var(--header-h));
  background: rgba(0,0,0,.4);
  z-index: 4000;       /* below sidebar, below header */
}
#sidebarBackdrop.show { display: block; }

/* (Optional) On md+ screens, leave the sidebar visible by default */
@media (min-width: 768px){
  #sidebar { transform: none; }
  #sidebarBackdrop { display: none !important; }
}
</style>
<header class="sticky top-0 z-40 w-full border-b border-gray-200 bg-white/95 backdrop-blur">
  <div class="max-w-7xl mx-auto px-3 sm:px-4">
    <div class="h-14 flex items-center gap-2">
      <!-- Left: Sidebar toggle + Brand -->
      <div class="flex items-center gap-2 min-w-0">
       <button id="sidebarToggle"
        class="w-10 h-10 grid place-items-center rounded-lg text-[var(--brand)] hover:bg-[var(--chip)]"
        title="Toggle sidebar">
  <i class="fa-solid fa-bars"></i>
</button>



        <a href="dashboard.php" class="flex items-center gap-2 min-w-0">
          <span class="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-brand-600 text-white shadow-sm">
            <i class="ri-pie-chart-2-fill text-base"></i>
          </span>
          <span class="font-semibold truncate">Admin Console</span>
        </a>
      </div>

      <!-- Center: Search -->
      <div class="hidden sm:flex flex-1 items-center justify-center px-2">
        <div class="w-full max-w-xl relative">
       <h3>Demo Company</h3>
        </div>
      </div>

      <!-- Right: Actions (no theme toggle) -->
      <div class="ml-auto flex items-center gap-2">
        <!-- Notifications -->
        <button class="relative inline-flex items-center justify-center h-9 w-9 rounded-xl border border-gray-200 hover:bg-gray-50"
                title="Notifications">
          <i class="ri-notification-3-line text-[18px]"></i>
          <span class="absolute top-1.5 right-1.5 inline-block h-2 w-2 rounded-full bg-rose-500"></span>
        </button>

        <!-- User menu -->
        <div class="relative">
          <button id="userMenuBtn"
                  class="inline-flex items-center gap-2 h-9 pl-2 pr-3 rounded-xl border border-gray-200 hover:bg-gray-50">
            <span class="inline-flex h-7 w-7 items-center justify-center rounded-lg bg-brand-100 text-brand-700 text-sm font-semibold">
              <?= htmlspecialchars($avatar) ?>
            </span>
            <span class="hidden sm:block max-w-[140px] truncate text-sm"><?= htmlspecialchars($displayName) ?></span>
            <i class="ri-arrow-down-s-line text-gray-400"></i>
          </button>

          <div id="userMenu"
               class="hidden absolute right-0 mt-2 w-56 rounded-xl border border-gray-200 bg-white shadow-xl overflow-hidden">
            <div class="px-3 py-2">
              <div class="text-sm font-medium truncate"><?= htmlspecialchars($displayName) ?></div>
              <?php if ($email): ?>
                <div class="text-xs text-gray-500 truncate"><?= htmlspecialchars($email) ?></div>
              <?php endif; ?>
            </div>
            <div class="h-px bg-gray-100"></div>
            <a href="profile.php" class="flex items-center gap-2 px-3 py-2 text-sm hover:bg-gray-50">
              <i class="ri-user-3-line"></i> Profile
            </a>
            <a href="settings.php" class="flex items-center gap-2 px-3 py-2 text-sm hover:bg-gray-50">
              <i class="ri-settings-3-line"></i> Settings
            </a>
            <div class="h-px bg-gray-100"></div>
            <a href="logout.php" class="flex items-center gap-2 px-3 py-2 text-sm text-rose-600 hover:bg-rose-50">
              <i class="ri-logout-box-r-line"></i> Logout
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
<div id="sidebarBackdrop" class="hidden"></div>
<script>
(function(){
  const header     = document.querySelector('header.sticky') || document.querySelector('header');
  const sidebar    = document.getElementById('sidebar');
  const toggleBtn  = document.getElementById('sidebarToggle');
  const backdrop   = document.getElementById('sidebarBackdrop');

  if (!sidebar || !toggleBtn) return;

  // Keep CSS var --header-h in sync with real header height
  function syncHeaderHeight(){
    if (!header) return;
    const h = header.offsetHeight;
    document.documentElement.style.setProperty('--header-h', h + 'px');
  }
  syncHeaderHeight();
  window.addEventListener('resize', syncHeaderHeight);

  // Helpers
  const isOpen  = () => document.body.classList.contains('sidebar-open');
  const open    = () => { document.body.classList.add('sidebar-open'); backdrop?.classList.add('show'); };
  const closeIt = () => { document.body.classList.remove('sidebar-open'); backdrop?.classList.remove('show'); };

  // Toggle via button
  toggleBtn.addEventListener('click', (e) => {
    e.stopPropagation();
    isOpen() ? closeIt() : open();
  });

  // Close on outside click/touch (anything not inside sidebar or on the toggle)
  function outsideClose(e){
    if (!isOpen()) return;
    const t = e.target;
    if (sidebar.contains(t)) return;
    if (toggleBtn.contains(t)) return;
    closeIt();
  }
  document.addEventListener('click', outsideClose, true);
  document.addEventListener('touchstart', outsideClose, { passive: true, capture: true });

  // Close on Esc
  document.addEventListener('keydown', (e) => { if (e.key === 'Escape') closeIt(); });

  // Backdrop click closes too
  backdrop?.addEventListener('click', closeIt);

  // If you resize up to md and keep a static sidebar, ensure state is sane
  function onResize(){
    if (window.matchMedia('(min-width: 768px)').matches) {
      // Desktop: backdrop always hidden; you may keep sidebar open permanently here
      backdrop?.classList.remove('show');
    } else {
      // Mobile: keep current state; nothing else to do
    }
  }
  window.addEventListener('resize', onResize);
  onResize();
})();
</script>
<script>
(function(){
  const btn  = document.getElementById('userMenuBtn');
  const menu = document.getElementById('userMenu');

  if (!btn || !menu) return;

  // show/hide
  function openMenu(){ menu.classList.remove('hidden'); }
  function closeMenu(){ menu.classList.add('hidden'); }
  function isOpen(){ return !menu.classList.contains('hidden'); }

  // toggle on click
  btn.addEventListener('click', (e) => {
    e.stopPropagation();
    isOpen() ? closeMenu() : openMenu();
  });

  // close on outside click
  document.addEventListener('click', (e) => {
    if (!isOpen()) return;
    const t = e.target;
    if (menu.contains(t) || btn.contains(t)) return;
    closeMenu();
  }, true);

  // close on Esc
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') closeMenu();
  });

  // optional: close when a menu item is clicked
  menu.addEventListener('click', (e) => {
    const a = e.target.closest('a');
    if (a) closeMenu();
  });

  // ensure it renders above other UI (if you don’t already have Tailwind z utilities)
  menu.style.zIndex = '10001';
})();
</script>

