<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Marketing Withdrawal Report</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php"; ?>
        
        <!-- Main Content -->
        <main class="flex-1 p-4 md:p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-2xl md:text-3xl font-bold text-center mb-6">Marketing Withdrawal Report</h1>
                
                <!-- Responsive Table -->
                <div class="overflow-x-auto bg-white border border-gray-300 rounded-lg shadow-md">
                    <table class="w-full text-sm md:text-base">
                        <thead class="bg-[#CD7F32] text-white">
                            <tr>
                                <th class="px-4 py-3 text-left">Transaction ID</th>
                                <th class="px-4 py-3 text-left">User</th>
                                <th class="px-4 py-3 text-left">Amount</th>
                                <th class="px-4 py-3 text-left">Status</th>
                                <th class="px-4 py-3 text-left">Date</th>
                                <th class="px-4 py-3 text-left">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-b hover:bg-gray-100">
                                <td class="px-4 py-3">TXN001</td>
                                <td class="px-4 py-3">John Doe</td>
                                <td class="px-4 py-3">$500.00</td>
                                <td class="px-4 py-3 text-green-600">Approved</td>
                                <td class="px-4 py-3">2024-02-01</td>
                                <td class="px-4 py-3 flex gap-2">
                                    <a href="#" class="text-blue-600 hover:underline">Edit</a>
                                    <a href="#" class="text-red-600 hover:underline">Delete</a>
                                </td>
                            </tr>
                            <tr class="border-b hover:bg-gray-100">
                                <td class="px-4 py-3">TXN002</td>
                                <td class="px-4 py-3">Jane Smith</td>
                                <td class="px-4 py-3">$750.00</td>
                                <td class="px-4 py-3 text-yellow-600">Pending</td>
                                <td class="px-4 py-3">2024-02-02</td>
                                <td class="px-4 py-3 flex gap-2">
                                    <a href="#" class="text-blue-600 hover:underline">Edit</a>
                                    <a href="#" class="text-red-600 hover:underline">Delete</a>
                                </td>
                            </tr>
                            <tr class="border-b hover:bg-gray-100">
                                <td class="px-4 py-3">TXN003</td>
                                <td class="px-4 py-3">Michael Johnson</td>
                                <td class="px-4 py-3">$1,200.00</td>
                                <td class="px-4 py-3 text-red-600">Rejected</td>
                                <td class="px-4 py-3">2024-02-03</td>
                                <td class="px-4 py-3 flex gap-2">
                                    <a href="#" class="text-blue-600 hover:underline">Edit</a>
                                    <a href="#" class="text-red-600 hover:underline">Delete</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Add New Withdrawal Button -->
                <div class="mt-6 text-center">
                    <a href="#" class="py-2 px-4 bg-[#CD7F32] text-white rounded-md shadow-md hover:bg-[#B76E29] transition duration-300">Add New Withdrawal</a>
                </div>
            </div>
        </main>
    </div>
    <?php include "footer.php"; ?>
</body>
</html>
