<?php
// Sample Data
$accounts = [
    1 => "Account 1",
    2 => "Account 2"
];

$positions = [
    1 => [
        [
            "loginId" => 12345,
            "symbol" => "EURUSD",
            "ticket" => 10001,
            "date" => "2025-02-04",
            "type" => "Buy",
            "volume" => 1,
            "openPrice" => 1.1000,
            "sl" => 1.0900,
            "tp" => 1.1100,
            "currentPrice" => 1.1050,
            "profit" => 50,
        ],
        [
            "loginId" => 12345,
            "symbol" => "GBPUSD",
            "ticket" => 10002,
            "date" => "2025-02-04",
            "type" => "Sell",
            "volume" => 2,
            "openPrice" => 1.3000,
            "sl" => 1.3100,
            "tp" => 1.2900,
            "currentPrice" => 1.2950,
            "profit" => 100,
        ]
    ],
    2 => [
        [
            "loginId" => 67890,
            "symbol" => "USDJPY",
            "ticket" => 20001,
            "date" => "2025-02-04",
            "type" => "Buy",
            "volume" => 1.5,
            "openPrice" => 110.50,
            "sl" => 109.50,
            "tp" => 111.50,
            "currentPrice" => 111.00,
            "profit" => 75,
        ]
    ]
];

$balance = 10000;
$equity = 10500;
$profit = 500;
$freeMargin = 4500;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Position Report</title>
    <link rel="stylesheet" href="style.css">
</head>
<style>body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f4;
    padding: 20px;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
}
/* Container for the summary boxes */
.summary {
    display: flex;                   /* Use flexbox layout */
    justify-content: space-between;   /* Space out items evenly */
    margin-bottom: 20px;              /* Space below the summary section */
    flex-wrap: wrap;                  /* Allow wrapping on smaller screens */
}

/* Individual box styles */
.summary div {
    background-color: #fff;          /* Clean white background */
    border: 1px solid #e0e0e0;       /* Subtle light grey border */
    padding: 25px;                    /* Padding inside the box */
    width: 22%;                       /* Adjust width for 4 items */
    text-align: center;               /* Center text horizontally */
    border-radius: 12px;              /* Rounded corners */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); /* Subtle shadow for depth */
    transition: transform 0.3s ease, box-shadow 0.3s ease; /* Smooth transitions */
}

/* Bold text inside the boxes */
.summary div strong {
    font-size: 20px;  /* Larger size for the labels */
    font-weight: bold; /* Ensure bold text */
    display: block;    /* Block level to separate label from value */
    margin-bottom: 15px; /* Space between the label and value */
    color: #333;       /* Dark color for better readability */
}

/* Value text inside the boxes */
.summary div span {
    font-size: 24px;     /* Larger font for the value */
    font-weight: 600;    /* Slightly bolder for emphasis */
    color: #007BFF;      /* Blue color for value text */
}

/* Hover effect to highlight the boxes */
.summary div:hover {
    transform: translateY(-5px); /* Slight lift effect on hover */
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15); /* Enhanced shadow on hover */
}

/* Responsive Design */
@media (max-width: 768px) {
    .summary {
        flex-direction: column;  /* Stack items vertically on smaller screens */
        align-items: center;      /* Center the items */
    }

    .summary div {
        width: 90%;    /* Each box takes up 90% width */
        margin-bottom: 15px; /* Add space between boxes */
    }
}


.account-selector {
    margin-bottom: 20px;
}

#mt5_id {
    padding: 10px;
    font-size: 16px;
}

.positions-table {
    margin-top: 20px;
}

table {
    width: 100%;
    border-collapse: collapse;
    border: 1px solid #ddd;
    margin-top: 20px;
}

table th, table td {
    padding: 10px;
    text-align: center;
    border: 1px solid #ddd;
}

table th {
    background-color: #f0f0f0;
}

table tr:nth-child(even) {
    background-color: #f9f9f9;
}

table tr:hover {
    background-color: #f1f1f1;
}
</style>
<body class="bg-gray-100 bg-white">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen ">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->



   

    <div class="container">
       
<div class="summary">
    <div><strong>Balance:</strong> <span>$<?php echo $balance; ?></span></div>
    <div><strong>Equity:</strong> <span>$<?php echo $equity; ?></span></div>
    <div><strong>Profit:</strong> <span>$<?php echo $profit; ?></span></div>
    <div><strong>Free Margin:</strong> <span>$<?php echo $freeMargin; ?></span></div>
</div>



        <div class="account-selector">
            <label for="mt5_id">Select MT5 Account:</label>
            <select id="mt5_id" name="mt5_id" onchange="showPositions()">
                <option value="">--Select--</option>
                <?php foreach ($accounts as $id => $name): ?>
                    <option value="<?php echo $id; ?>"><?php echo $name; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div id="positions" class="positions-table">
            <!-- Blank table will be displayed initially -->
            <table>
                <thead>
                    <tr>
                        <th>Login ID</th>
                        <th>Symbol</th>
                        <th>Ticket</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Volume</th>
                        <th>Open Price</th>
                        <th>SL</th>
                        <th>TP</th>
                        <th>Current Price</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <tr><td colspan="11">Please select an MT5 account.</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</main><?php include "footer.php";?>
</div>
    <script>
        function showPositions() {
            var mt5Id = document.getElementById("mt5_id").value;
            var positionsContainer = document.getElementById("positions");

            var positions = <?php echo json_encode($positions); ?>;
            var selectedPositions = positions[mt5Id] || [];

            if (mt5Id === "") {
                positionsContainer.innerHTML = `
                    <table>
                        <thead>
                            <tr>
                                <th>Login ID</th>
                                <th>Symbol</th>
                                <th>Ticket</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Volume</th>
                                <th>Open Price</th>
                                <th>SL</th>
                                <th>TP</th>
                                <th>Current Price</th>
                                <th>Profit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td colspan="11">Please select an MT5 account.</td></tr>
                        </tbody>
                    </table>
                `;
                return;
            }

            if (selectedPositions.length > 0) {
                var tableHTML = `
                    <table>
                        <thead>
                            <tr>
                                <th>Login ID</th>
                                <th>Symbol</th>
                                <th>Ticket</th>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Volume</th>
                                <th>Open Price</th>
                                <th>SL</th>
                                <th>TP</th>
                                <th>Current Price</th>
                                <th>Profit</th>
                            </tr>
                        </thead>
                        <tbody>`;

                selectedPositions.forEach(function(position) {
                    tableHTML += `
                        <tr>
                            <td>${position.loginId}</td>
                            <td>${position.symbol}</td>
                            <td>${position.ticket}</td>
                            <td>${position.date}</td>
                            <td>${position.type}</td>
                            <td>${position.volume}</td>
                            <td>${position.openPrice}</td>
                            <td>${position.sl}</td>
                            <td>${position.tp}</td>
                            <td>${position.currentPrice}</td>
                            <td>${position.profit}</td>
                        </tr>
                    `;
                });

                tableHTML += "</tbody></table>";
                positionsContainer.innerHTML = tableHTML;
            } else {
                positionsContainer.innerHTML = "<p>No positions found for this account.</p>";
            }
        }
    </script>
</body>
</html>
