<?php
session_start();
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}



// Debug: Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Log the POST data for debugging
    error_log(print_r($_POST, true));  // Log entire $_POST array

    // Retrieve and sanitize form data
    $deposit_type = isset($_POST['deposit_type']) ? $_POST['deposit_type'] : '';
    $deposit_amount = isset($_POST['amount']) ? $_POST['amount'] : 0;
    $wallet_address = isset($_POST['wallet_address']) ? $_POST['wallet_address'] : '';
    $usdt_address = isset($_POST['usdt_address']) ? $_POST['usdt_address'] : '';
    $neteller_email = isset($_POST['neteller_email']) ? $_POST['neteller_email'] : '';
    $paypal_email = isset($_POST['paypal_email']) ? $_POST['paypal_email'] : '';
    $account_name = isset($_POST['account_name']) ? $_POST['account_name'] : '';
    $account_number = isset($_POST['account_number']) ? $_POST['account_number'] : '';

    // Prepare SQL query based on deposit type
    switch ($deposit_type) {
        case 'bitcoin':
            $query = "INSERT INTO bitcoin_deposits (wallet_address, amount) VALUES (?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sd", $wallet_address, $deposit_amount);
            break;
        case 'usdt':
            $query = "INSERT INTO usdt_deposits (usdt_address, amount) VALUES (?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sd", $usdt_address, $deposit_amount);
            break;
        case 'neteller':
            $query = "INSERT INTO neteller_deposits (neteller_email, amount) VALUES (?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sd", $neteller_email, $deposit_amount);
            break;
        case 'paypal':
            $query = "INSERT INTO paypal_deposits (paypal_email, amount) VALUES (?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sd", $paypal_email, $deposit_amount);
            break;
        case 'bank':
            $query = "INSERT INTO bank_deposits (account_name, account_number, amount) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssd", $account_name, $account_number, $deposit_amount);
            break;
        default:
            echo "Invalid deposit type.";
            exit;
    }

    // Execute the query
    if ($stmt->execute()) {
        echo "Deposit successfully added!";
    } else {
        // Show error message and log error details
        echo "Error: " . $stmt->error;
        error_log("SQL Error: " . $stmt->error);
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
} else {
    echo "Invalid request method.";
}
?>
