<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Become a PAMM Investor</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

   <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
   <div class="container">
        <h1 class="text-3xl font-bold text-center text-[#CD7F32] mb-6">Become a PAMM Investor</h1>

            <form action="" method="POST">
                <!-- Checkbox for Terms and Privacy Policy -->
                <div class="mb-6">
                    <input type="checkbox" id="agree" name="agree" required class="mr-2">
                    <label for="agree" class="text-gray-700">
                        I agree to the 
                        <a href="terms.php" class="text-[#CD7F32] font-semibold underline">Terms & Conditions</a> and 
                        <a href="privacy.php" class="text-[#CD7F32] font-semibold underline">Privacy Policy</a>.
                    </label>
                </div>

                <!-- Submit Button -->
                <div class="text-center">
                    <button type="submit" class="w-full px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                        Submit
                    </button>
                </div>
            </form>
        </div><br><br><br><?php include "footer.php";?>
    </main>
</div>
</body>
</html>
