<?php
// ---- place this at the very top of the page (before any HTML output) ----
session_start();
require_once 'config.php'; // this defines $conn (PDO)

// identify current user
if (empty($_SESSION['clogin'])) {
    // If you store user id instead, use: $currentId = (int)$_SESSION['user_id'];
    http_response_code(401);
    // For full page flows, you could redirect to login
    // echo "<script>location.href='login.php';</script>"; exit;
}

// Handle password change submit
if (isset($_POST['change_pass_submit'])) {
    $email            = $_SESSION['clogin'];                // OR use id: $currentId
    $currentPassword  = trim($_POST['current_password'] ?? '');
    $newPassword      = trim($_POST['new_password'] ?? '');
    $confirmPassword  = trim($_POST['confirm_password'] ?? '');

    // Basic validations
    if ($newPassword === '' || $confirmPassword === '' || $currentPassword === '') {
        $flash = ['type'=>'danger','msg'=>'All fields are required.'];
    } elseif ($newPassword !== $confirmPassword) {
        $flash = ['type'=>'danger','msg'=>'New password and confirm password do not match.'];
    } elseif (strlen($newPassword) < 8) {
        $flash = ['type'=>'danger','msg'=>'Password must be at least 8 characters.'];
    } else {
        // Fetch user row
        // If using id: $stmt = $conn->prepare("SELECT id, password FROM aspnetusers WHERE id = :id LIMIT 1");
        // $stmt->bindValue(':id', $currentId, PDO::PARAM_INT);
        $stmt = $conn->prepare("SELECT id, password FROM aspnetusers WHERE email = :email LIMIT 1");
        $stmt->bindValue(':email', $email, PDO::PARAM_STR);
        $stmt->execute();
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            $flash = ['type'=>'danger','msg'=>'User not found.'];
        } else {
            $stored = $user['password'];

            // Verify current password (support old plaintext storage)
            $currentOk = false;
            if (!empty($stored)) {
                if (password_get_info($stored)['algo'] !== 0) {
                    // stored is hashed
                    $currentOk = password_verify($currentPassword, $stored);
                } else {
                    // stored appears plaintext – do a direct compare
                    $currentOk = hash_equals($stored, $currentPassword);
                }
            }

            if (!$currentOk) {
                $flash = ['type'=>'danger','msg'=>'Current password is incorrect.'];
            } else {
                // Hash the new password and update
                $newHash = password_hash($newPassword, PASSWORD_DEFAULT);

                $up = $conn->prepare("UPDATE aspnetusers SET password = :p WHERE id = :id");
                $up->bindValue(':p', $newHash, PDO::PARAM_STR);
                $up->bindValue(':id', $user['id'], PDO::PARAM_INT);
                $up->execute();

                $flash = ['type'=>'success','msg'=>'Password changed successfully.'];
            }
        }
    }
}
?>

<!-- Change Password Modal -->
<div class="modal fade" id="changePassModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title mb-0"><i class="fas fa-key mr-2"></i>Change Password</h5>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">×</button>
      </div>

      <form method="post">
        <div class="modal-body">
          <?php if (!empty($flash)): ?>
            <div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?> mb-3">
              <?php echo htmlspecialchars($flash['msg']); ?>
            </div>
          <?php endif; ?>

          <div class="form-group">
            <label for="current_password">Current Password</label>
            <input type="password" class="form-control" id="current_password" name="current_password" required>
          </div>

          <div class="form-group">
            <label for="new_password">New Password <small class="text-muted">(min 8 chars)</small></label>
            <input type="password" class="form-control" id="new_password" name="new_password" minlength="8" required>
          </div>

          <div class="form-group">
            <label for="confirm_password">Confirm New Password</label>
            <input type="password" class="form-control" id="confirm_password" name="confirm_password" minlength="8" required>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" name="change_pass_submit" class="btn btn-primary">
            <i class="fas fa-save mr-1"></i> Save
          </button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">
            Close
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

   
