<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


// Ensure you have a proper database connection

// Get parameters for filtering and pagination
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $per_page;

$date_filter = isset($_GET['date_filter']) ? $_GET['date_filter'] : '';
$search = isset($_GET['search']) ? strtolower($_GET['search']) : '';

// Base Query (Start with WHERE 1=1 to ensure valid SQL)
$query = "SELECT * FROM wallet_deposit WHERE 1=1";
$params = [];

// Apply Date Filter
if ($date_filter) {
    $query .= " AND date = ?";
    $params[] = $date_filter;
}

// Apply Search Filter
if ($search) {
    $query .= " AND (LOWER(name) LIKE ? OR LOWER(trade_id) LIKE ? OR LOWER(deposit_type) LIKE ?)";
    $search_param = "%$search%";
    $params = array_merge($params, [$search_param, $search_param, $search_param]);
}

// Get Total Count for Pagination
$count_query = "SELECT COUNT(*) as total FROM wallet_deposit WHERE 1=1"; // Same base query for count
if ($date_filter) {
    $count_query .= " AND date = ?";
}
if ($search) {
    $count_query .= " AND (LOWER(name) LIKE ? OR LOWER(trade_id) LIKE ? OR LOWER(deposit_type) LIKE ?)";
}

$stmt = $conn->prepare($count_query);
$stmt->execute($params);
$total_deposits = $stmt->fetchColumn();
$total_pages = ceil($total_deposits / $per_page);

// Ensure $start and $per_page are integers
$start = (int)$start;
$per_page = (int)$per_page;

// Apply Pagination
$query .= " LIMIT ?, ?";
$params[] = $start;
$params[] = $per_page;

// Prepare and execute the query with the pagination parameters
$stmt = $conn->prepare($query);
$stmt->bindParam(1, $params[0], PDO::PARAM_INT); // Bind start
$stmt->bindParam(2, $params[1], PDO::PARAM_INT); // Bind per_page
$stmt->execute();

// Fetch the results
$deposits_to_display = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit Report</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex flex-col md:flex-row h-screen">
    <?php include "side_bar.php"; ?>
    <main class="flex-1 p-6 md:ml-64">
        <div class="container">
            <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Deposit Report</h1>
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200 rounded-lg shadow-md">
                    <thead>
                        <tr class="bg-gray-100">
                            
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">Email</th>
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">MT5 ID</th>
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">deposit_amount</th>
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">Payment Method</th>
                            
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">Status</th>
                            <th class="px-3 py-2 border-b text-left text-[#CD7F32]">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($deposits_to_display as $deposit): ?>
                            <tr class="hover:bg-gray-50">
                                <!--<td class="px-3 py-4 border-b"><?php echo $deposit['id']; ?></td>-->
                                <td class="px-3 py-4 border-b"><?php echo $deposit['email']; ?></td>
                                <td class="px-3 py-4 border-b"><?php echo $deposit['trade_id']; ?></td>
                                <td class="px-3 py-4 border-b"><?php echo '$' . number_format($deposit['deposit_amount'], 2); ?></td>
                                <td class="px-3 py-4 border-b"><?php echo $deposit['deposit_type']; ?></td>
                               
                                <td class="px-3 py-4 border-b"><?php echo $deposit['Status']; ?></td>
                                <td class="px-3 py-4 border-b"><?php echo $deposit['deposted_date']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody><br><br>
                </table>
            </div>
        </div><br><br>
    </main>
    <?php include "footer.php"; ?>
</div>
</body>
</html>
