<?php
session_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
include "config.php"; // Ensure this file connects to your database

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}


 // Include your database connection

if (isset($_GET['account_type'])) {
    $account_type = $_GET['account_type'];
    $sql = "SELECT * FROM leverage WHERE account_type = :account_type ORDER BY account_leverage DESC";
    $query = $dbh->prepare($sql);
    $query->bindParam(':account_type', $account_type, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);

    // Retrieve the group for the selected account type
    $sql_group = "SELECT ac_group FROM account_types WHERE ac_name = :account_type";
    $query_group = $dbh->prepare($sql_group);
    $query_group->bindParam(':account_type', $account_type, PDO::PARAM_STR);
    $query_group->execute();
    $group_result = $query_group->fetch(PDO::FETCH_OBJ);

    // Prepare the response including both leverage options and group
    $response = [
        'leverage_options' => $results,
        'account_group' => $group_result->ac_group
    ];

    // Convert results to JSON format
    echo json_encode($response);
}
?>
