
<?php


$email = $_SESSION['clogin'];
?>


  
<style>
  
         /* Full-screen overlay */
.overlay {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(255, 255, 255, 0.7);  /* Semi-transparent white */
  z-index: 9999;  /* Makes sure the overlay is on top */
  display: flex;
  justify-content: center;
  align-items: center;
  backdrop-filter: blur(5px);  /* Adds a blur effect to the background */
}

/* Loader animation */
#loader {
  border: 12px solid #f3f3f3;
  border-radius: 50%;
  border-top: 12px solid #444444;
  width: 70px;
  height: 70px;
  animation: spin 1s linear infinite;
}

/* Spin animation */
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

/* Centering the loader */
.center {
  display: flex;
  justify-content: center;
  align-items: center;
}

        
</style>


    <!-- loader Start -->
<div id="overlay" class="overlay">
  <div id="loader" class="center"></div>
</div>    <!-- loader END -->




 <script>
        document.onreadystatechange = function () {
            if (document.readyState !== "complete") {
                document.querySelector(
                    "body").style.visibility = "hidden";
                document.querySelector(
                    "#loader").style.visibility = "visible";
            } else {
                document.querySelector(
                    "#loader").style.display = "none";
                document.querySelector(
                    "body").style.visibility = "visible";
            }
        };
        
        
        window.onload = function() {
  document.getElementById("overlay").style.visibility = "hidden";
}
    </script>
    
    
    
<div class="container-fluid content-inner mt-n5 py-0">
    <div class="text-center mb-5"><br>
        <h2 class="display-5 fw-bold text-gradient-primary" style="margin-top:100px;">Choose Your Trading Account</h2>
        <p class="lead text-muted">Select the account type that matches your trading style</p>
    </div>

    <div class="row justify-content-center g-4">
        <div class="col-md-3"></div>
        <?php
        include 'config.php';
        $sql = "SELECT * FROM account_types";
        $query = $conn->prepare($sql);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);

        if ($query->rowCount() > 0) {
            foreach ($results as $index => $result) {
                // Determine badge color based on account group
                $badgeColor = 'bg-primary';
                if (strpos($result->ac_group, 'RAW') !== false) $badgeColor = 'bg-danger';
                if (strpos($result->ac_group, 'PRO') !== false) $badgeColor = 'bg-warning text-dark';
                if (strpos($result->ac_group, 'Standard') !== false) $badgeColor = 'bg-success';
        ?>
        <div class="col-md-6 col-lg-4">
            <div class="card card-hover h-100 border-0 shadow-lg overflow-hidden">
                <div class="card-header bg-gradient-dark-orange text-white py-4 position-relative">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="h5 mb-0 text-white"><?php echo htmlentities($result->ac_name); ?></h3>
                        <span class="badge <?php echo $badgeColor; ?> rounded-pill"><?php echo htmlentities($result->ac_group); ?></span>
                    </div>
                    <div class="mt-3">
                        <span class="h2 fw-bold">$<?php echo htmlentities($result->ac_min_deposit); ?></span>
                        <span class="text-white-50">minimum deposit</span>
                    </div>
                    <div class="position-absolute top-0 end-0 p-3">
                        <i class="fas fa-info-circle fa-lg" data-bs-toggle="tooltip" data-bs-placement="left" 
                           title="<?php echo htmlentities($result->ac_name); ?> account details"></i>
                    </div>
                </div>

                <div class="card-body p-4">
                    <div class="d-flex flex-column h-100">
                        <ul class="list-unstyled mb-4">
                            <li class="d-flex align-items-center mb-3">
                                <i class="fas fa-chart-line text-primary me-2"></i>
                                <span>Spread: <strong>From <?php echo htmlentities($result->ac_spread); ?> pips</strong></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="fas fa-percentage text-primary me-2"></i>
                                <span>Commission: <strong>$0 per lot</strong></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="fas fa-exchange-alt text-primary me-2"></i>
                                <span>Swap: <strong>Competitive rates</strong></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="fas fa-bell text-primary me-2"></i>
                                <span>Margin call: <strong>60% / Stop out 50%</strong></span>
                            </li>
                            <li class="d-flex align-items-center mb-3">
                                <i class="fas fa-balance-scale text-primary me-2"></i>
                                <span>Min trade: <strong>0.01 lots</strong></span>
                            </li>
                        </ul>

                        <div class="mt-auto">
                            <button class="btn btn-lg btn-outline-primary w-100 open-modal-btn" 
                                    type="button" data-bs-toggle="modal" 
                                    data-bs-target="#openAccountModal"
                                    data-account-type="<?php echo htmlspecialchars($result->ac_name); ?>" 
                                    data-account-group="<?php echo htmlspecialchars($result->ac_group); ?>">
                                Open Account
                                <i class="fas fa-arrow-right ms-2"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <?php if (strpos($result->ac_group, 'PRO') !== false) { ?>
                    <div class="position-absolute top-0 start-0 m-3">
                        <span class="badge bg-warning text-dark shadow-sm">Most Popular</span>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
                // Add empty spacer div after every 2 cards
                if (($index + 1) % 2 == 0) {
                    echo '<div class="col-lg-3"></div>';
                }
            }
        }
        ?>
    </div>
</div>

<style>
    .card-hover {
        transition: all 0.3s ease;
        border-radius: 12px;
    }
    .card-hover:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    .bg-gradient-dark-orange {
       background: linear-gradient(135deg, #ff6a00 0%, #cc3300 100%);
    }
    .text-gradient-primary {
        background: linear-gradient(90deg, #4b6cb7, #182848);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
    }
    .list-unstyled li {
        padding: 8px 0;
        border-bottom: 1px solid rgba(0,0,0,0.05);
    }
</style>










<!-- Modal -->
<div class="modal fade" id="openAccountModal" tabindex="-1" aria-labelledby="openAccountModalLabel" aria-hidden="true" data-bs-backdrop="static" style="margin">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header" style="background: radial-gradient(circle, #ffb300, #b8860b); color: white;">
                <h5 class="modal-title" id="openAccountModalLabel" style="color:white">Open Live Account</h5>
                <button type="button"  data-bs-dismiss="modal" aria-label="Close" style="color:white;background-color:transparent;border:none;font-size:26px"><span>&times;</span></button>
            </div>
            <div class="modal-body">
                <form action="" method="POST" onsubmit="disableButtonliveacc()">
                    <div class="mb-3">
                        <label for="accountType" class="form-label"  style="color:black">Account Type</label></br>
                        <input type="text"  id="accountType" name="acname" style="padding: .5rem 3rem .5rem 1rem;width:100%" readonly>
                        
                        <input type="hidden"  id="accountGroup" name="user[group]" style="padding: .5rem 3rem .5rem 1rem;width:100%" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="leverage" class="form-label" style="color:black">Leverage</label>
                        <select style="padding: .5rem 3rem .5rem 1rem;width:100%" id="leverage" name="user[leverage]">
                            <option value="50">1:50</option>
                            <option value="100">1:100</option>
                            <option value="200">1:200</option>
                            <option value="300">1:300</option>
                            <option value="500">1:500</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="accountType" class="form-label"  style="color:black">Nickname</label></br>
                        <input type="text"  id="accountType" name="user[name]" style="padding: .5rem 3rem .5rem 1rem;width:100%" required>
                        
                    </div>
                    
                    <div class="mb-3">
                        <label for="accountType" class="form-label"  style="color:black">Master Password</label></br>
                        <input type="text" name="user[password]"  style="padding: .5rem 3rem .5rem 1rem;width:100%" pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$" 
        title="Password must be at least 8 characters long, and include uppercase, lowercase, number, and special character." required>
                        
                    </div>
                    
                    
                    <div class="mb-3">
                        <label for="accountType" class="form-label"  style="color:black">Investor Password</label></br>
                        <input type="text"  name="user[invest_password]"  style="padding: .5rem 3rem .5rem 1rem;width:100%" pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$" 
        title="Password must be at least 8 characters long, and include uppercase, lowercase, number, and special character." required>
                        
                    </div>
                    
                    
                    
                    
                    
                  

<?php
function generatePassword($length = 8) {
    $uppercase = chr(rand(65, 90)); // Random uppercase letter
    $lowercase = chr(rand(97, 122)); // Random lowercase letter
    $digit = rand(0, 9); // Random digit
    $specialChars = "@#$%^&*()-_=+";
    $special = $specialChars[rand(0, strlen($specialChars) - 1)]; // Random special character

    // Create a base password including one of each required character type
    $basePassword = $uppercase . $lowercase . $digit . $special;

    // Fill the rest of the password length with random characters
    $allChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$%^&*()-_=+";
    for ($i = 4; $i < $length; $i++) {
        $basePassword .= $allChars[rand(0, strlen($allChars) - 1)];
    }

    // Shuffle the result to randomize character positions
    return str_shuffle($basePassword);
}
?>                      



<div class="form-group col-sm-12 no-padding-xs">
    <input type='hidden' value='<?php echo generatePassword(8); ?>' name="user[phone_password]" required class="form-control fill">
</div>


<?php
include 'config.php';
$sql = "SELECT * FROM aspnetusers WHERE email = :eid";
$query = $conn->prepare($sql);
$query->bindParam(':eid', $email, PDO::PARAM_STR);
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);
if ($query->rowCount() > 0) {
    foreach ($results as $result) {
        echo '<input type="hidden" name="user[zip]" value="' . htmlentities($result->zipcode) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[email]" value="' . htmlentities($result->email) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[country]" value="' . htmlentities($result->country) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[state]" value="' . htmlentities($result->state) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[city]" value="' . htmlentities($result->city) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[address]" value="' . htmlentities($result->address) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[phone]" value="' . htmlentities($result->number) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[refer_email1]" value="' . htmlentities($result->ib1) . '" class="form-control fill">';
        echo '<input type="hidden" name="user[refer_email2]" value="' . htmlentities($result->ib2) . '" class="form-control fill">';
                echo '<input type="hidden" name="user[refer_email3]" value="' . htmlentities($result->ib3) . '" class="form-control fill">';
                        echo '<input type="hidden" name="user[refer_email4]" value="' . htmlentities($result->ib4) . '" class="form-control fill">';
                                echo '<input type="hidden" name="user[refer_email5]" value="' . htmlentities($result->ib5) . '" class="form-control fill">';
                                        echo '<input type="hidden" name="user[refer_email6]" value="' . htmlentities($result->ib6) . '" class="form-control fill">';
                                                echo '<input type="hidden" name="user[refer_email7]" value="' . htmlentities($result->ib7) . '" class="form-control fill">';
                                                        echo '<input type="hidden" name="user[refer_email8]" value="' . htmlentities($result->ib8) . '" class="form-control fill">';
                                                                echo '<input type="hidden" name="user[refer_email9]" value="' . htmlentities($result->ib9) . '" class="form-control fill">';
                                                                
                                                                        echo '<input type="hidden" name="user[refer_email10]" value="' . htmlentities($result->ib10) . '" class="form-control fill">';
        // Add more hidden fields as needed
    }
}
?>

                    
                    
                    
                   
                   <center>
                                           <button id="submitbutton" type="submit" name="a[register]"  class="btn btn-primary" style="background: linear-gradient(135deg, #a8ff78, #78ffd6);color:black">Submit</button>

                   </center>                    

                </form>
            </div>
        </div>
    </div>
</div>

<script>

 function disableButtonliveacc() {
    var button = document.getElementById("submitbutton");
        if (button) {
    setTimeout(function() {
      button.disabled = true;
    }, 1);  // delay just enough to let the form submit
  }
  }


    // JavaScript to populate the modal dynamically
    document.addEventListener('DOMContentLoaded', () => {
        const modal = document.getElementById('openAccountModal');
        const accountTypeInput = document.getElementById('accountType');
        const accountTypeGroup = document.getElementById('accountGroup');

        document.querySelectorAll('.open-modal-btn').forEach(button => {
            button.addEventListener('click', function () {
                const accountType = this.getAttribute('data-account-type');
                const accountGroup = this.getAttribute('data-account-group');
                accountTypeInput.value = accountType; // Autofill Account Type
                accountTypeGroup.value = accountGroup; // Autofill Account Type
            });
        });
    });
</script>
