<?php
// Database connection
include "config.php";error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $user = $_POST['user'];
    $bank_name = $_POST['bank_name'];
    $account_name = $_POST['account_name'];
    $account_number = $_POST['account_number'];
    $ifsc_code = $_POST['ifsc_code'];
    $iban_number = $_POST['iban_number'];
    $bank_address = $_POST['bank_address'];
    $country = $_POST['country'];

    // File upload
    $targetDir = "uploads/"; // Corrected path (relative)
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0755, true); // Create directory if it doesn't exist
    }

    // Ensure unique file name
    $fileName = time() . "_" . basename($_FILES["book_bank"]["name"]);
    $targetFilePath = $targetDir . $fileName;
    $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));

    // Check for file upload errors
    if ($_FILES["book_bank"]["error"] !== UPLOAD_ERR_OK) {
        echo "<script>alert('Upload error code: " . $_FILES["book_bank"]["error"] . "'); window.history.back();</script>";
        exit;
    }

    // Validate file type
    if (in_array($fileType, ['jpg', 'jpeg', 'png', 'gif'])) {

        // Check folder writability
        if (!is_writable($targetDir)) {
            echo "<script>alert('Upload directory is not writable.'); window.history.back();</script>";
            exit;
        }

        // Move uploaded file
        if (move_uploaded_file($_FILES["book_bank"]["tmp_name"], $targetFilePath)) {

            // Insert into database
            $sql = "INSERT INTO bank_details (user_id, bank_name, account_name, account_number, ifsc_code, iban_number, bank_address, country, bank_book, created_at)
                    VALUES (:user, :bank_name, :account_name, :account_number, :ifsc_code, :iban_number, :bank_address, :country, :bank_book, NOW())";

            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':user', $user);
            $stmt->bindParam(':bank_name', $bank_name);
            $stmt->bindParam(':account_name', $account_name);
            $stmt->bindParam(':account_number', $account_number);
            $stmt->bindParam(':ifsc_code', $ifsc_code);
            $stmt->bindParam(':iban_number', $iban_number);
            $stmt->bindParam(':bank_address', $bank_address);
            $stmt->bindParam(':country', $country);
            $stmt->bindParam(':bank_book', $targetFilePath);

            if ($stmt->execute()) {
                echo "<script>alert('Bank details saved successfully.'); window.location.href='bank_details_list.php';</script>";
            } else {
                echo "<script>alert('Failed to save bank details in the database.'); window.history.back();</script>";
            }
        } else {
            echo "<script>alert('Failed to upload the bank book. Please check folder permissions.'); window.history.back();</script>";
        }
    } else {
        echo "<script>alert('Invalid file format. Only JPG, JPEG, PNG, and GIF are allowed.'); window.history.back();</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Bank Details</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-50">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        
        <?php include "side_bar.php";?>

        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
       <h2 class="text-3xl font-semibold text-gray-800 mb-6 text-center">Add Bank Details</h2>

    <!-- Form -->
    <form action="add_bank_details.php" method="POST" enctype="multipart/form-data">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-6">
            <!-- Select User -->
            <div>
                <label for="user" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Select User:
                </label>
                <select id="user" name="user" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32] text-gray-800" required>
                    <option value="">Select a User</option>
                    <option value="1">John Doe</option>
                    <option value="2">Jane Smith</option>
                </select>
            </div>

            <!-- Bank Name -->
            <div>
                <label for="bank_name" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Bank Name:
                </label>
                <input type="text" id="bank_name" name="bank_name" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- Account Name -->
            <div>
                <label for="account_name" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Account Name:
                </label>
                <input type="text" id="account_name" name="account_name" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- Account Number -->
            <div>
                <label for="account_number" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Account Number:
                </label>
                <input type="text" id="account_number" name="account_number" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- IFSC/SWIFT Code -->
            <div>
                <label for="ifsc_code" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    IFSC/SWIFT Code:
                </label>
                <input type="text" id="ifsc_code" name="ifsc_code" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- IBAN Number -->
            <div>
                <label for="iban_number" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    IBAN Number:
                </label>
                <input type="text" id="iban_number" name="iban_number" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- Bank Address -->
            <div>
                <label for="bank_address" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Bank Address:
                </label>
                <input type="text" id="bank_address" name="bank_address" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>

            <!-- Country -->
            <div>
                <label for="country" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Country:
                </label>
                <select id="country" name="country" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
                    <option value="">Select a Country</option>
                    <option value="India">India</option>
                    <option value="USA">USA</option>
                    <option value="UK">UK</option>
                </select>
            </div>

            <!-- Upload Bank Book -->
            <div class="md:col-span-2">
                <label for="book_bank" class="block text-[#CD7F32] text-lg font-semibold tracking-wide mb-2 uppercase hover:underline">
                    Upload Bank Book:
                </label>
                <input type="file" id="book_bank" name="book_bank" accept="image/*" class="w-full p-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-[#CD7F32]" required>
            </div>
        </div>

        <!-- Submit Button -->
        <div class="mt-6 text-center">
            <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-green-700 transition duration-300">
                Save Bank Details
            </button>
        </div>
    </form><br>
</div><br><br>

        </main><?php include "footer.php";?>
    </div>

    <!-- Footer -->
    

</body>

</html>
