<?php
// Hardcoded commission data for example purposes
$plans = ["Plan A", "Plan B", "Plan C"];
$groups = ["Group 1", "Group 2", "Group 3"];

// Default values for the commission form
$level_commissions = array_fill_keys(
    ["level_1_commission", "level_2_commission", "level_3_commission", "level_4_commission",
     "level_5_commission", "level_6_commission", "level_7_commission", "level_8_commission",
     "level_9_commission", "level_10_commission"], ""
);

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $plan_name = $_POST['plan_name'];
    $group_name = $_POST['group_name'];

    // Loop through the commissions and store values
    foreach ($level_commissions as $key => &$value) {
        $value = $_POST[$key] ?? "";
    }

    // Database insertion logic goes here (for example, using PDO or MySQLi)
    echo "<p class='text-green-600 font-bold text-center mt-4'>Commission Added Successfully!</p>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Commission</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
        <div class="container">
            <h1 class="text-3xl font-bold text-center mb-6 text-[#CD7F32]">ADD IB Commission</h1>

            <!-- Commission Form -->
            <form action="" method="POST" class="max-w-5xl mx-auto bg-white p-8 rounded-lg shadow-md">

                <!-- Select Plan and Group -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Select Plan -->
                    <div>
                        <label for="plan_name" class="block text-gray-600 text-lg font-small mb-2">Select Plan:</label>
                        <select id="plan_name" name="plan_name" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-600" required>
                            <option value="">-- Select Plan --</option>
                            <?php foreach ($plans as $plan): ?>
                                <option value="<?= $plan ?>"><?= $plan ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Select Group -->
                    <div>
                        <label for="group_name" class="block text-gray-600 text-lg font-small mb-2">Select Group:</label>
                        <select id="group_name" name="group_name" class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-600" required>
                            <option value="">-- Select Group --</option>
                            <?php foreach ($groups as $group): ?>
                                <option value="<?= $group ?>"><?= $group ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <!-- Commission Levels -->
                <div class="grid grid-cols-2 gap-6">
                    <?php foreach ($level_commissions as $level => $value): ?>
                        <div>
                            <label for="<?= $level ?>" class="block text-gray-600 text-lg font-medium mb-2">
                                <?= str_replace("_", " ", ucfirst($level)) ?>:
                            </label>
                            <input type="number" step="0.01" id="<?= $level ?>" name="<?= $level ?>" value="<?= $value ?>"
                                class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-2 focus:ring-blue-600" required>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="w-full py-3 mt-6 bg-[#CD7F32] text-white font-semibold rounded-md shadow-md hover:bg-blue-700 transition duration-300">Add Commission</button>
            </form>
        </div><br><br><br>
    </main>
    <?php include "footer.php"; ?>
</div>
</body>
</html>
