<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add IB Plan</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-50">

    <?php include "header.php"; ?>

    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php"; ?>

        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
        <div class="container mx-auto p-8 bg-white rounded-2xl border border-gray-200 w-full max-w-3xl">
        
        <h2 class="text-4xl font-bold text-center text-[#CD7F32] mb-8">Add IB Plan</h2>

        <!-- Form -->
        <form action="process_ib_plan.php" method="POST" class="space-y-6">
            <!-- Plan Name -->
            <div>
                <label for="plan_name" class="block text-[#CD7F32] text-lg font-bold uppercase tracking-wide mb-2">Plan Name:</label>
                <input type="text" id="plan_name" name="plan_name" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32] transition-shadow focus:shadow-md" required placeholder="Enter IB Plan Name">
            </div>

            <!-- Submit Button -->
            <div class="text-center">
                <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-bold rounded-lg shadow-md hover:bg-[#B87333] hover:scale-105 transition duration-300">
                    Add IB Plan
                </button>
            </div>
        </form>
    </div>
</div>

            <?php include "footer.php"; ?>
        </main>
    </div>

</body>
</html>
