<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bonus List</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-50">
    <?php include "header.php"; ?>
    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>
        
        <main class="flex-1 p-4 md:p-6 md:ml-64 overflow-auto">
            <!-- Top Navigation -->
            <div class="container mx-auto">
                <h2 class="text-2xl md:text-3xl font-semibold text-[#CD7F32] mb-4 md:mb-6">Bonus List</h2>
                
                <div class="overflow-x-auto">
                    <table class="w-full border-collapse bg-white shadow-lg rounded-lg overflow-hidden min-w-[600px]">
                        <thead>
                            <tr class="bg-[#CD7F32] text-white uppercase text-xs md:text-sm leading-normal">
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">ID</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">MT5 ID</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">Amount ($)</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">Equity</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">Type</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">Comment</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-left">Date</th>
                                <th class="py-2 md:py-3 px-4 md:px-6 text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="text-gray-700 text-xs md:text-sm">
                            <tr class="border-b border-gray-200 hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-4">1</td>
                                <td class="py-2 px-4">MT5-12345</td>
                                <td class="py-2 px-4">$1000</td>
                                <td class="py-2 px-4">$5000</td>
                                <td class="py-2 px-4">Bonus</td>
                                <td class="py-2 px-4">Referral Bonus</td>
                                <td class="py-2 px-4">2025-02-03</td>
                                <td class="py-2 px-4 text-center">
                                    <button class="bg-red-500 text-white px-2 py-1 md:px-3 md:py-1 rounded-md hover:bg-red-700 focus:outline-none">Delete</button>
                                </td>
                            </tr>
                            <tr class="border-b border-gray-200 hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-4">2</td>
                                <td class="py-2 px-4">MT5-67890</td>
                                <td class="py-2 px-4">$2000</td>
                                <td class="py-2 px-4">$8000</td>
                                <td class="py-2 px-4">Bonus</td>
                                <td class="py-2 px-4">Performance Bonus</td>
                                <td class="py-2 px-4">2025-02-02</td>
                                <td class="py-2 px-4 text-center">
                                    <button class="bg-red-500 text-white px-2 py-1 md:px-3 md:py-1 rounded-md hover:bg-red-700 focus:outline-none">Delete</button>
                                </td>
                            </tr>
                            <tr class="border-b border-gray-200 hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-4">3</td>
                                <td class="py-2 px-4">MT5-11223</td>
                                <td class="py-2 px-4">$1500</td>
                                <td class="py-2 px-4">$7000</td>
                                <td class="py-2 px-4">Bonus</td>
                                <td class="py-2 px-4">Loyalty Bonus</td>
                                <td class="py-2 px-4">2025-02-01</td>
                                <td class="py-2 px-4 text-center">
                                    <button class="bg-red-500 text-white px-2 py-1 md:px-3 md:py-1 rounded-md hover:bg-red-700 focus:outline-none">Delete</button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
    <?php include "footer.php"; ?>
</body>
</html>
