<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Commission List</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-50">
    <?php include "header.php"; ?>
    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>
        
        <main class="flex-1 p-4 md:p-6 md:ml-64 overflow-auto">
            <div class="container mx-auto">
                <h2 class="text-2xl md:text-3xl font-semibold text-[#CD7F32] mb-4 md:mb-6">Commission List</h2>
                
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow-md">
                        <thead class="bg-[#CD7F32] text-white">
                            <tr>
                                <th class="py-2 px-2 text-left">ID</th>
                                <th class="py-2 px-2 text-left">Plan Name</th>
                                <th class="py-2 px-2 text-left">Group Name</th>
                                <th class="py-2 px-2 text-left">Level 1</th>
                                <th class="py-2 px-2 text-left">Level 2</th>
                                <th class="py-2 px-2 text-left">Level 3</th>
                                <th class="py-2 px-2 text-left">Level 4</th>
                                <th class="py-2 px-2 text-left">Level 5</th>
                                <th class="py-2 px-2 text-left">Level 6</th>
                                <th class="py-2 px-2 text-left">Level 7</th>
                                <th class="py-2 px-2 text-left">Level 8</th>
                                <th class="py-2 px-2 text-left">Level 9</th>
                                <th class="py-2 px-2 text-left">Level 10</th>
                                <th class="py-2 px-2 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="border-b hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-2">1</td>
                                <td class="py-2 px-2">Plan A</td>
                                <td class="py-2 px-2">Group 1</td>
                                <td class="py-2 px-2">$50</td>
                                <td class="py-2 px-2">$45</td>
                                <td class="py-2 px-2">$40</td>
                                <td class="py-2 px-2">$35</td>
                                <td class="py-2 px-2">$30</td>
                                <td class="py-2 px-2">$25</td>
                                <td class="py-2 px-2">$20</td>
                                <td class="py-2 px-2">$15</td>
                                <td class="py-2 px-2">$10</td>
                                <td class="py-2 px-2">$20</td>
                                <td class="py-2 px-2">
                                    <a href="edit_commission.php?id=1" class="text-[#CD7F32] hover:underline">Edit</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
    <?php include "footer.php"; ?>
</body>
</html>
