<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$response = ["status" => "error", "message" => "Invalid request"];

if (isset($_GET['from']) && isset($_GET['to']) && isset($_GET['page']) && isset($_GET['recordsPerPage'])) {
    $fromDate = $_GET['from'];
    $toDate = $_GET['to'];
    $page = (int)$_GET['page'];
    $recordsPerPage = (int)$_GET['recordsPerPage'];

    // Dummy Data
    $dummyData = [
        ["login_id" => 1001, "date" => "2025-01-25", "ticket" => 5001, "symbol" => "AAPL", "price" => 150.25, "profit" => 50.00, "volume" => 10, "action" => "Buy"],
        ["login_id" => 1002, "date" => "2025-01-26", "ticket" => 5002, "symbol" => "GOOG", "price" => 2800.75, "profit" => -30.50, "volume" => 5, "action" => "Sell"],
        ["login_id" => 1003, "date" => "2025-01-27", "ticket" => 5003, "symbol" => "TSLA", "price" => 720.00, "profit" => 100.75, "volume" => 15, "action" => "Buy"],
        ["login_id" => 1004, "date" => "2025-01-30", "ticket" => 5004, "symbol" => "MSFT", "price" => 299.99, "profit" => 20.00, "volume" => 8, "action" => "Sell"],
        ["login_id" => 1005, "date" => "2025-02-01", "ticket" => 5005, "symbol" => "AMZN", "price" => 3400.50, "profit" => 75.25, "volume" => 12, "action" => "Buy"],
     ["login_id" => 1001, "date" => "2025-01-25", "ticket" => 5001, "symbol" => "AAPL", "price" => 150.25, "profit" => 50.00, "volume" => 10, "action" => "Buy"],
        ["login_id" => 1002, "date" => "2025-01-26", "ticket" => 5002, "symbol" => "GOOG", "price" => 2800.75, "profit" => -30.50, "volume" => 5, "action" => "Sell"],
        ["login_id" => 1003, "date" => "2025-01-27", "ticket" => 5003, "symbol" => "TSLA", "price" => 720.00, "profit" => 100.75, "volume" => 15, "action" => "Buy"],
        ["login_id" => 1004, "date" => "2025-01-30", "ticket" => 5004, "symbol" => "MSFT", "price" => 299.99, "profit" => 20.00, "volume" => 8, "action" => "Sell"],
        ["login_id" => 1005, "date" => "2025-02-01", "ticket" => 5005, "symbol" => "AMZN", "price" => 3400.50, "profit" => 75.25, "volume" => 12, "action" => "Buy"],
     ["login_id" => 1001, "date" => "2025-01-25", "ticket" => 5001, "symbol" => "AAPL", "price" => 150.25, "profit" => 50.00, "volume" => 10, "action" => "Buy"],
        ["login_id" => 1002, "date" => "2025-01-26", "ticket" => 5002, "symbol" => "GOOG", "price" => 2800.75, "profit" => -30.50, "volume" => 5, "action" => "Sell"],
        ["login_id" => 1003, "date" => "2025-01-27", "ticket" => 5003, "symbol" => "TSLA", "price" => 720.00, "profit" => 100.75, "volume" => 15, "action" => "Buy"],
        ["login_id" => 1004, "date" => "2025-01-30", "ticket" => 5004, "symbol" => "MSFT", "price" => 299.99, "profit" => 20.00, "volume" => 8, "action" => "Sell"],
        ["login_id" => 1005, "date" => "2025-02-01", "ticket" => 5005, "symbol" => "AMZN", "price" => 3400.50, "profit" => 75.25, "volume" => 12, "action" => "Buy"],
     ["login_id" => 1001, "date" => "2025-01-25", "ticket" => 5001, "symbol" => "AAPL", "price" => 150.25, "profit" => 50.00, "volume" => 10, "action" => "Buy"],
        ["login_id" => 1002, "date" => "2025-01-26", "ticket" => 5002, "symbol" => "GOOG", "price" => 2800.75, "profit" => -30.50, "volume" => 5, "action" => "Sell"],
        ["login_id" => 1003, "date" => "2025-01-27", "ticket" => 5003, "symbol" => "TSLA", "price" => 720.00, "profit" => 100.75, "volume" => 15, "action" => "Buy"],
        ["login_id" => 1004, "date" => "2025-01-30", "ticket" => 5004, "symbol" => "MSFT", "price" => 299.99, "profit" => 20.00, "volume" => 8, "action" => "Sell"],
        ["login_id" => 1005, "date" => "2025-02-01", "ticket" => 5005, "symbol" => "AMZN", "price" => 3400.50, "profit" => 75.25, "volume" => 12, "action" => "Buy"],
    ];

    // Filter data
    $filteredData = array_filter($dummyData, function ($lot) use ($fromDate, $toDate) {
        return ($lot["date"] >= $fromDate && $lot["date"] <= $toDate);
    });

    // Pagination
    $totalPages = ceil(count($filteredData) / $recordsPerPage);
    $offset = ($page - 1) * $recordsPerPage;
    $pagedData = array_slice($filteredData, $offset, $recordsPerPage);

    // Generate Table Data
    $tableData = "<table><tr><th>Login ID</th><th>Date</th><th>Ticket</th><th>Symbol</th><th>Price</th><th>Profit</th><th>Volume</th><th>Action</th></tr>";
    foreach ($pagedData as $lot) {
        $tableData .= "<tr>
                        <td>{$lot['login_id']}</td>
                        <td>{$lot['date']}</td>
                        <td>{$lot['ticket']}</td>
                        <td>{$lot['symbol']}</td>
                        <td>{$lot['price']}</td>
                        <td>{$lot['profit']}</td>
                        <td>{$lot['volume']}</td>
                        <td>{$lot['action']}</td>
                       </tr>";
    }
    $tableData .= "</table>";

    // Prepare Pie Chart Data
    $symbolCounts = [];
    foreach ($filteredData as $lot) {
        $symbol = $lot['symbol'];
        if (!isset($symbolCounts[$symbol])) {
            $symbolCounts[$symbol] = 0;
        }
        $symbolCounts[$symbol] += 1;
    }

    $chartData = [
        "labels" => array_keys($symbolCounts),
        "data" => array_values($symbolCounts)
    ];

    // Return JSON
    $response = [
        "status" => "success",
        "tableData" => $tableData,
        "chartData" => $chartData,
        "totalPages" => $totalPages
    ];
}

echo json_encode($response);
?>
