<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Marketing Users List</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-4 md:p-6">
            <div class="container mx-auto">
                <h1 class="text-2xl md:text-3xl font-bold text-center mb-6">Marketing Users List</h1>

                <!-- Responsive Table -->
                <div class="overflow-x-auto bg-white shadow-md rounded-lg">
                    <table class="min-w-full border border-gray-300">
                        <thead>
                            <tr class="bg-gray-800 text-white text-sm md:text-base">
                                <th class="px-3 md:px-4 py-2 text-left">Name</th>
                                <th class="px-3 md:px-4 py-2 text-left">Email</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden sm:table-cell">Wallet</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden lg:table-cell">Incentive</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden lg:table-cell">Net Deposit</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden xl:table-cell">Clients</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden xl:table-cell">Deposits</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden xl:table-cell">Withdrawal</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden lg:table-cell">Role</th>
                                <th class="px-3 md:px-4 py-2 text-left hidden xl:table-cell">Manager</th>
                                <th class="px-3 md:px-4 py-2 text-left">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($result->num_rows > 0) : ?>
                                <?php while ($row = $result->fetch_assoc()) : ?>
                                    <tr class="border-b border-gray-200 hover:bg-gray-50 text-sm md:text-base">
                                        <td class="px-3 md:px-4 py-2"><?php echo htmlspecialchars($row['name']); ?></td>
                                        <td class="px-3 md:px-4 py-2"><?php echo htmlspecialchars($row['email']); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden sm:table-cell">$<?php echo number_format($row['wallet_balance'], 2); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden lg:table-cell"><?php echo number_format($row['incentive'], 2); ?>%</td>
                                        <td class="px-3 md:px-4 py-2 hidden lg:table-cell">$<?php echo number_format($row['net_deposit'], 2); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden xl:table-cell"><?php echo number_format($row['total_clients']); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden xl:table-cell">$<?php echo number_format($row['total_deposits'], 2); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden xl:table-cell">$<?php echo number_format($row['total_withdrawal'], 2); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden lg:table-cell"><?php echo htmlspecialchars($row['role']); ?></td>
                                        <td class="px-3 md:px-4 py-2 hidden xl:table-cell"><?php echo htmlspecialchars($row['manager_name']); ?></td>
                                        <td class="px-3 md:px-4 py-2">
                                            <a href="edit_marketing.php?id=<?php echo $row['id']; ?>" class="text-blue-500 hover:text-blue-700">Edit</a>
                                            <span class="mx-2">|</span>
                                            <a href="delete_marketing.php?id=<?php echo $row['id']; ?>" class="text-red-500 hover:text-red-700">Delete</a>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            <?php else : ?>
                                <tr>
                                    <td colspan="11" class="text-center py-4">No marketing users found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Option to add a new marketing user -->
                <div class="mt-6 text-center">
                    <a href="add_marketing.php" class="py-2 px-4 bg-blue-600 text-white rounded-md shadow-md hover:bg-blue-700 transition duration-300">Add New Marketing User</a>
                </div>
            </div>
        </main>
    </div>

<?php include "footer.php";?>
</body>
</html>

<?php
// Close the connection
$conn->close();
?>
