<?php
// Sample data for pending IB withdrawals (replace with actual database queries)
$pending_ib_withdrawals = [
    ['client_id' => 1, 'client_name' => 'Client 1', 'amount' => 400, 'comment' => 'IB withdrawal request'],
    ['client_id' => 2, 'client_name' => 'Client 2', 'amount' => 600, 'comment' => 'Requested by IB'],
    ['client_id' => 3, 'client_name' => 'Client 3', 'amount' => 1200, 'comment' => 'IB funds withdrawal'],
];

// Handle approve/reject actions
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    $ib_withdrawal_id = $_POST['ib_withdrawal_id'];

    // Implement the logic to approve/reject the IB withdrawal based on the action
    if ($action === 'approve') {
        echo "IB Withdrawal #$ib_withdrawal_id approved!";
    } else {
        echo "IB Withdrawal #$ib_withdrawal_id rejected!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending IB Withdrawals</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
            <div class="container">
              <h1 class="text-4xl font-bold text-center mb-6 text-blue-600">Pending IB Withdrawals</h1>

        <!-- Pending IB Withdrawals Table -->
        <table class="min-w-full bg-white border border-gray-300 shadow-md rounded-lg">
            <thead>
                <tr class="bg-gray-200">
                    <th class="py-2 px-2 text-left text-gray-600">Client Name</th>
                    <th class="py-2 px-2 text-left text-gray-600">Amount</th>
                    <th class="py-2 px-2 text-left text-gray-600">Comment</th>
                    <th class="py-2 px-2 text-left text-gray-600">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pending_ib_withdrawals as $ib_withdrawal): ?>
                    <tr>
                        <td class="py-2 px-2 text-gray-700"><?php echo $ib_withdrawal['client_name']; ?></td>
                        <td class="py-2 px-2 text-gray-700"><?php echo $ib_withdrawal['amount']; ?></td>
                        <td class="py-2 px-2 text-gray-700"><?php echo $ib_withdrawal['comment']; ?></td>
                        <td class="py-2 px-2 text-gray-700">
                            <form action="pending_ib_withdrawal.php" method="POST" class="inline">
                                <input type="hidden" name="ib_withdrawal_id" value="<?php echo $ib_withdrawal['client_id']; ?>">
                                <button type="submit" name="action" value="approve" class="bg-green-600 text-white py-2 px-2 rounded-md hover:bg-green-700 transition duration-300">Approve</button>
                            </form>
                            <form action="pending_ib_withdrawal.php" method="POST" class="inline ml-2">
                                <input type="hidden" name="ib_withdrawal_id" value="<?php echo $ib_withdrawal['client_id']; ?>">
                                <button type="submit" name="action" value="reject" class="bg-red-600 text-white py-2 px-2 rounded-md hover:bg-red-700 transition duration-300">Reject</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

  <?php include "footer.php";?></main></div>

</body>
</html>
