<?php
include "config.php";

// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $bonus_amount = $_POST['bonus_amount'];
    $comment = $_POST['comment'];

    try {
        $sql = "INSERT INTO bonus (user_id, bonus_amount, comment) VALUES (:user_id, :bonus_amount, :comment)";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':bonus_amount', $bonus_amount);
        $stmt->bindParam(':comment', $comment, PDO::PARAM_STR);

        if ($stmt->execute()) {
            echo "<script>alert('Bonus added successfully!'); window.location.href='bonus_list.php';</script>";
        } else {
            echo "Error while inserting data.";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>
