<?php
// session_boot.php
// Secure session defaults (set before session_start)
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_samesite', 'Lax'); // 'Strict' if no cross-site
// If you're on HTTPS, uncomment:
// ini_set('session.cookie_secure', 1);

if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// Optional: inactivity timeout (e.g., 60 minutes)
$MAX_IDLE = 60 * 60;
if (!empty($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $MAX_IDLE)) {
  // expire
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
  }
  session_destroy();
  header('Location: login.php?expired=1');
  exit;
}
$_SESSION['last_activity'] = time();
