<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Slave Copier Request List</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <?php include "header.php"; ?>

    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php"; ?>

        <main class="flex-1 p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-3xl font-semibold text-center text-[#CD7F32] mb-6">Slave Copier Request List</h1>

                <!-- Download Buttons -->
                <div class="flex flex-col md:flex-row justify-center gap-4 mb-6">
                    <a href="download_excel_slave_copier.php" class="bg-green-600 text-white px-6 py-3 rounded-md shadow-md hover:bg-green-700 transition duration-300 text-center">
                        Download Excel
                    </a>
                    <a href="download_pdf_slave_copier.php" class="bg-red-600 text-white px-6 py-3 rounded-md shadow-md hover:bg-red-700 transition duration-300 text-center">
                        Download PDF
                    </a>
                </div>

                <!-- Responsive Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white border border-gray-300 rounded-lg shadow-md">
                        <thead class="bg-[#CD7F32] text-white">
                            <tr>
                                <th class="py-2 px-4 text-left">Request ID</th>
                                <th class="py-2 px-4 text-left">Name</th>
                                <th class="py-2 px-4 text-left">Email</th>
                                <th class="py-2 px-4 text-left">User Type</th>
                                <th class="py-2 px-4 text-left">Registration Date</th>
                                <th class="py-2 px-4 text-left">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Dummy Data Rows (Replace with dynamic data from DB) -->
                            <tr class="border-b hover:bg-[#F8E6D1] transition">
                                <td class="py-2 px-4">1</td>
                                <td class="py-2 px-4">John Doe</td>
                                <td class="py-2 px-4">johndoe@email.com</td>
                                <td class="py-2 px-4">Slave Copier</td>
                                <td class="py-2 px-4">2025-02-01</td>
                                <td class="py-2 px-4 flex flex-col md:flex-row gap-2">
                                    <a href="approve_slave_copier.php?id=1" class="text-green-500 hover:underline">Approve</a>
                                    <a href="reject_slave_copier.php?id=1" class="text-red-500 hover:underline">Reject</a>
                                </td>
                            </tr>
                            <!-- More rows can be added similarly -->
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
    
    <?php include "footer.php"; ?>
</body>
</html>
