<?php
session_start();
// error_reporting(E_ALL); ini_set('display_errors', 1);
error_reporting(0);

include('config.php');

// Helper: safe output
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// If you want to enforce login, uncomment:
// if (strlen($_SESSION['alogin']) == 0) { header('location:login.php'); exit(); }

// --- Toggle Inactive (email_confirmed = 0) ---
if (isset($_GET['inid'])) {
    $id = $_GET['inid'];
    $email_confirmed = 0;
    $sql = "UPDATE aspnetusers SET email_confirmed = :email_confirmed WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':email_confirmed', $email_confirmed, PDO::PARAM_INT);
    $stmt->bindParam(':id', $id, PDO::PARAM_STR);
    $stmt->execute();
    header('Location: clients.php'); exit;
}

// --- Toggle Active (email_confirmed = 1) ---
if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $email_confirmed = 1;
    $sql = "UPDATE aspnetusers SET email_confirmed = :email_confirmed WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':email_confirmed', $email_confirmed, PDO::PARAM_INT);
    $stmt->bindParam(':id', $id, PDO::PARAM_STR);
    $stmt->execute();
    header('Location: clients.php'); exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Clients List</title>

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>

  <!-- Bootstrap 4.6 (for modals & tabs) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"/>

  <!-- DataTables core + Responsive extension -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/jquery.dataTables.min.css"/>
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css"/>

  <style>
    .badge { display:inline-block; padding:0.35em 0.65em; font-size:.75em; font-weight:700; line-height:1; border-radius:.25rem; }
    .badge-success { color:#fff; background:#28a745; }
    .badge-danger  { color:#fff; background:#dc3545; }
    .badge-primary { color:#fff; background:#007bff; }
    .card { box-shadow:0 4px 6px -1px rgba(0,0,0,.1), 0 2px 4px -1px rgba(0,0,0,.06); border-radius:.5rem; }
    .btn { transition:all .3s ease; }
    .btn:hover { transform:translateY(-1px); box-shadow:0 4px 6px rgba(0,0,0,.1); }
    @media (max-width:768px){
      .table-responsive { overflow-x:auto; -webkit-overflow-scrolling:touch; }
    }
    /* Make DT header match Tailwind bg */
    table.dataTable thead th { background:#f9fafb; }
  </style>
</head>
<body class="bg-gray-100">
<?php include('header.php');?>

<div class="flex flex-col md:flex-row h-screen">
  <!-- Sidebar -->
  <?php include "side_bar.php";?>

  <main class="flex-1 p-4 md:p-6 md:ml-64">
    <div class="container mx-auto">
      <!-- Header -->
      <div class="flex flex-col md:flex-row justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800 mb-4 md:mb-0">Clients List</h1>
        <a href="dashboard.php" class="bg-[#FF6B00] hover:bg-[#E55F00] text-white font-medium py-2 px-6 rounded-full transition duration-300 shadow-md">
          <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
      </div>

      <!-- Table -->
      <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="p-4">
          <div class="table-responsive">
            <table id="depositTable" class="display nowrap w-full">
              <thead class="bg-gray-50">
                <tr>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Country</th>
                  <th>Number</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody class="bg-white divide-y divide-gray-200">
              <?php
              $sql = "SELECT * FROM aspnetusers";
              $query = $conn->prepare($sql);
              $query->execute();
              $results = $query->fetchAll(PDO::FETCH_OBJ);

              if ($query->rowCount() > 0) {
                foreach ($results as $row) {
                  // Unique suffix for modal & tab IDs (avoid collisions)
                  $uidSource = $row->id ?? $row->email ?? uniqid('u_');
                  $uid = preg_replace('/[^a-zA-Z0-9_]/', '_', (string)$uidSource);

                  $status = (string)$row->email_confirmed === '1' ? 'Active' : 'Inactive';
                  $badgeClass = (string)$row->email_confirmed === '1' ? 'badge-success' : 'badge-danger';

                  // Pre-calc some fields with safety
                  $fullname = h($row->fullname ?? '');
                  $email    = h($row->email ?? '');
                  $country  = h($row->country ?? '');
                  $number   = h($row->number ?? '');
                  $dial     = h($row->dial_code ?? '');
                  $state    = h($row->state ?? '');
                  $city     = h($row->city ?? '');
                  $zip      = h($row->zipcode ?? '');
                  $address  = h($row->address ?? '');
                  $gender   = h($row->gender ?? '');
                  $aboutme  = h($row->aboutme ?? '');
                  $reg_date = h($row->reg_date ?? '');
                  $wallet   = h($row->wallet_address ?? '');

                  $education = h($row->education ?? '');
                  $employee_status = h($row->employee_status ?? '');
                  $industry  = h($row->industry ?? '');

                  $forex_exp = h($row->forex_exp ?? '');
                  $other     = h($row->other ?? '');

                  $investment_plan    = h($row->investment_plan ?? '');
                  $investment_purpose = h($row->investment_purpose ?? '');

                  $password = h($row->password ?? ''); // Note: showing passwords in plain text is unsafe; keep only if absolutely required
                  ?>
                  <tr>
                    <td><div><?= $fullname ?></div></td>
                    <td><div class="amount"><?= $email ?></div></td>
                    <td><div><?= $country ?></div></td>
                    <td><div><?= $number ?></div></td>
                    <td><span class="badge <?= $badgeClass ?>"><?= $status ?></span></td>
                    <td class="whitespace-nowrap">
                      <?php if ((string)$row->email_confirmed === '1') { ?>
                        <a href="clients.php?inid=<?= urlencode((string)($row->id ?? '')) ?>"
                           onclick="return confirm('Do you want to Deactivate this client?');"
                           class="btn btn-danger btn-sm m-1" title="Inactive this client">
                          <i class="fa fa-unlock"></i>
                        </a>
                      <?php } else { ?>
                        <a href="clients.php?id=<?= urlencode((string)($row->id ?? '')) ?>"
                           onclick="return confirm('Do you want to Activate this client?');"
                           class="btn btn-primary btn-sm m-1" title="Active this client">
                          <i class="fa fa-lock"></i>
                        </a>
                      <?php } ?>

                      <a href="delete_client.php?email=<?= urlencode((string)$row->email) ?>"
                         class="btn btn-danger btn-sm m-1"
                         title="Delete Client"
                         onclick="return confirm('Are you sure you want to delete this client?');">
                        Delete
                      </a>

                      <!-- View Details trigger -->
                      <button type="button"
                              class="btn btn-success btn-sm m-1"
                              data-toggle="modal"
                              data-target="#profile_<?= $uid ?>">
                        View Details
                      </button>

                      <!-- Profile Modal -->
                      <div class="modal fade" id="profile_<?= $uid ?>" tabindex="-1" role="dialog" aria-labelledby="profileLabel_<?= $uid ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                          <div class="modal-content">
                            <div class="modal-header" style="box-shadow:0 4px 8px rgba(0,0,0,.08);padding:15px;">
                              <h4 class="modal-title" id="profileLabel_<?= $uid ?>" style="padding-left:20px;color:#f12126">Client Details</h4>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                              </button>
                            </div>
                            <div class="modal-body">
                              <!-- Tabs -->
                              <ul class="nav nav-pills nav-pills-custom" id="pills-tab-custom-<?= $uid ?>" role="tablist" style="background-color:#f8f9fa;box-shadow:0 4px 8px rgba(0,0,0,.08);">
                                <li class="nav-item">
                                  <a class="nav-link active" id="pills-health-tab-<?= $uid ?>" data-toggle="pill" href="#pills-health-<?= $uid ?>" role="tab" aria-controls="pills-health-<?= $uid ?>" aria-selected="true">
                                    Personal Data
                                  </a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link" id="pills-career-tab-<?= $uid ?>" data-toggle="pill" href="#pills-career-<?= $uid ?>" role="tab" aria-controls="pills-career-<?= $uid ?>" aria-selected="false">
                                    Employment
                                  </a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link" id="pills-trade-tab-<?= $uid ?>" data-toggle="pill" href="#pills-trade-<?= $uid ?>" role="tab" aria-controls="pills-trade-<?= $uid ?>" aria-selected="false">
                                    Trading Experience
                                  </a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link" id="pills-invest-tab-<?= $uid ?>" data-toggle="pill" href="#pills-invest-<?= $uid ?>" role="tab" aria-controls="pills-invest-<?= $uid ?>" aria-selected="false">
                                    Investment
                                  </a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link" id="pills-login-tab-<?= $uid ?>" data-toggle="pill" href="#pills-login-<?= $uid ?>" role="tab" aria-controls="pills-login-<?= $uid ?>" aria-selected="false">
                                    Login
                                  </a>
                                </li>
                              </ul>

                              <br>

                              <div class="tab-content" id="pills-tabContent-<?= $uid ?>">
                                <!-- Personal Data -->
                                <div class="tab-pane fade show active" id="pills-health-<?= $uid ?>" role="tabpanel" aria-labelledby="pills-health-tab-<?= $uid ?>">
                                  <div class="row">
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card">
                                        <div class="card-body">
                                          <div class="form-group">
                                            <label>Wallet ID</label>
                                            <input type="text" class="form-control" value="<?= $wallet ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Full Name</label>
                                            <input type="text" class="form-control" value="<?= $fullname ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Email</label>
                                            <input type="email" class="form-control" value="<?= $email ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Country</label>
                                            <input type="text" class="form-control" value="<?= $country ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Mobile No</label>
                                            <input type="text" class="form-control" value="<?= $dial ?> <?= $number ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>State</label>
                                            <input type="text" class="form-control" value="<?= $state ?>" readonly>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card">
                                        <div class="card-body">
                                          <div class="form-group">
                                            <label>City</label>
                                            <input type="text" class="form-control" value="<?= $city ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Zipcode</label>
                                            <input type="text" class="form-control" value="<?= $zip ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Address</label>
                                            <input type="text" class="form-control" value="<?= $address ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>Gender</label>
                                            <input type="text" class="form-control" value="<?= $gender ?>" readonly>
                                          </div>
                                          <div class="form-group">
                                            <label>About me</label>
                                            <textarea class="form-control" rows="4" readonly><?= $aboutme ?></textarea>
                                          </div>
                                          <div class="form-group">
                                            <label>Reg Date</label>
                                            <input type="text" class="form-control" value="<?= $reg_date ?>" readonly>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <!-- Employment -->
                                <div class="tab-pane fade" id="pills-career-<?= $uid ?>" role="tabpanel" aria-labelledby="pills-career-tab-<?= $uid ?>">
                                  <div class="row">
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Education</label>
                                          <input type="text" class="form-control" value="<?= $education ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Employment Status</label>
                                          <input type="text" class="form-control" value="<?= $employee_status ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Industry</label>
                                          <input type="text" class="form-control" value="<?= $industry ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                  </div>
                                </div>

                                <!-- Trading Experience -->
                                <div class="tab-pane fade" id="pills-trade-<?= $uid ?>" role="tabpanel" aria-labelledby="pills-trade-tab-<?= $uid ?>">
                                  <div class="row">
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Forex</label>
                                          <input type="text" class="form-control" value="<?= $forex_exp ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>CFDs on Futures</label>
                                          <input type="text" class="form-control" value="<?= $forex_exp ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-4 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Other Derivatives</label>
                                          <input type="text" class="form-control" value="<?= $other ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                  </div>
                                </div>

                                <!-- Investment -->
                                <div class="tab-pane fade" id="pills-invest-<?= $uid ?>" role="tabpanel" aria-labelledby="pills-invest-tab-<?= $uid ?>">
                                  <div class="row">
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Planned Investment</label>
                                          <input type="text" class="form-control" value="<?= $investment_plan ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Purpose of Investing</label>
                                          <input type="text" class="form-control" value="<?= $investment_purpose ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                  </div>
                                </div>

                                <!-- Login -->
                                <div class="tab-pane fade" id="pills-login-<?= $uid ?>" role="tabpanel" aria-labelledby="pills-login-tab-<?= $uid ?>">
                                  <div class="row">
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Username</label>
                                          <input type="text" class="form-control" value="<?= $email ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                    <div class="col-md-6 grid-margin stretch-card">
                                      <div class="card"><div class="card-body">
                                        <div class="form-group">
                                          <label>Password</label>
                                          <input type="text" class="form-control" value="<?= $password ?>" readonly>
                                        </div>
                                      </div></div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <!-- /tab content -->
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- /Profile Modal -->
                    </td>
                  </tr>
                  <?php
                }
              }
              ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

    </div>
  </main>
</div>

<?php include('footer.php');?>

<!-- jQuery first, then Bootstrap (for modals), then DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

<script>
  $(function () {
    const dt = $('#depositTable').DataTable({
      responsive: true,
      autoWidth: false,
      pageLength: 25,
      order: [[0, 'asc']], // sort by name
      columnDefs: [
        { orderable: false, targets: [5] } // disable sort on Action
      ],
      language: {
        search: "_INPUT_",
        searchPlaceholder: "Search clients...",
        lengthMenu: "Show _MENU_ entries",
        info: "Showing _START_ to _END_ of _TOTAL_ entries",
        infoEmpty: "Showing 0 to 0 of 0 entries",
        infoFiltered: "(filtered from _MAX_ total entries)",
        paginate: { first: "First", last: "Last", next: "Next", previous: "Previous" }
      }
    });

    // Tailwind-esque styling for DataTables controls
    $('.dataTables_filter input')
      .addClass('border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring w-56');
    $('.dataTables_length select')
      .addClass('border border-gray-300 rounded-md px-2 py-1');
  });
</script>
</body>
</html>
