<?php
// account_details.php
declare(strict_types=1);
session_start();
error_reporting(E_ALL);
ini_set('display_errors', '1');

include 'config.php';                 // -> provides $conn (PDO)
include 'manager_initialize.php';     // -> provides $api, MTRetCode constants, etc.

if (empty($_SESSION['clogin'])) {
  header('Location: login.php');
  exit();
}

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// ---------------- Input: trade id (GET or POST) ----------------
$trade_id = $_POST['tradeid'] ?? $_GET['tradeid'] ?? null;
if (!$trade_id) {
  exit('Missing tradeid (pass via POST or as ?tradeid=)');
}
$login = (int)$trade_id;

// ---------------- MT5: time window & offsets -------------------
$from    = 0;             // all history; or use time()-365*24*3600 for last 1y
$to      = time();
$offset  = 0;
$offsets = 0;

// Pre-init containers
$resulttrade1         = []; // open positions page
$resulttradehistory1  = []; // deals page
$open_order_history   = 0;
$close_order_history  = 0;

// ---------------- MT5 calls (with sane error handling) ---------
$ret = $api->PositionGetTotal($login, $total);
if ($ret != MTRetCode::MT_RET_OK) {
  exit("PositionGetTotal failed, code=$ret");
}
$open_order_history = (int)$total;

$ret = $api->DealGetTotal($login, $from, $to, $totals);
if ($ret != MTRetCode::MT_RET_OK) {
  exit("DealGetTotal failed, code=$ret");
}
$close_order_history = (int)$totals;

$ret = $api->PositionGetPage($login, $offset, $open_order_history, $positions);
if ($ret != MTRetCode::MT_RET_OK) {
  exit("PositionGetPage failed, code=$ret");
}
$resulttrade1 = $positions ?? [];

$ret = $api->DealGetPage($login, $from, $to, $offsets, $close_order_history, $deals);
if ($ret != MTRetCode::MT_RET_OK) {
  exit("DealGetPage failed, code=$ret");
}
$resulttradehistory1 = $deals ?? [];

// One-time account snapshot (avoid repeated calls in markup)
$ret = $api->UserAccountGet($login, $account);
if ($ret != MTRetCode::MT_RET_OK) {
  exit("UserAccountGet failed, code=$ret");
}
$balance     = $account->Balance    ?? 0;
$credit      = $account->Credit     ?? 0;
$equity      = $account->Equity     ?? 0;
$margin      = $account->Margin     ?? 0;
$marginFree  = $account->MarginFree ?? 0;
$profitFloat = $account->Floating   ?? 0;

// ---------------- Live account row (created date, passwords) ---
$eid1 = $_SESSION['clogin'];
$stmtLive = $conn->prepare("SELECT * FROM liveaccount WHERE email = :eid AND trade_id = :tid");
$stmtLive->bindParam(':eid', $eid1, PDO::PARAM_STR);
$stmtLive->bindParam(':tid', $trade_id, PDO::PARAM_STR);
$stmtLive->execute();
$liveRows = $stmtLive->fetchAll(PDO::FETCH_OBJ);

$createdText = '-';
$liveRow     = null;
if (!empty($liveRows)) {
  $liveRow = end($liveRows);
  if (!empty($liveRow->Registered_Date)) {
    try {
      $createdText = (new DateTime($liveRow->Registered_Date))->format('d F Y H:i');
    } catch (Throwable $e) { /* ignore */ }
  }
}

// ---------------- Aggregations for “Overview / Statistics” -----
$totalVolumeLots = 0.0;
$totalTrades     = 0;
$wins            = 0;
$losses          = 0;
$longCount       = 0;   // Action == 1  (your code labels it Sell/Long; keep consistent with your UI)
$shortCount      = 0;   // Action != 1
foreach ($resulttradehistory1 as $d) {
  $lots = (float)$d->VolumeClosed * 0.0001; // contract units → lots
  if (($d->Order ?? 0) != 0 && $lots != 0.0) {
    $totalTrades++;
    $totalVolumeLots += $lots;

    $p = (float)$d->Profit;
    if ($p >= 0) $wins++; else $losses++;

    if (($d->Action ?? 0) == 1) $longCount++; else $shortCount++;
  }
}
$longPerc  = $totalTrades ? ($longCount  / $totalTrades) * 100 : 0;
$shortPerc = $totalTrades ? ($shortCount / $totalTrades) * 100 : 0;
$winrate   = $totalTrades ? ($wins / $totalTrades) * 100 : 0;

// ---------------- Totals: Deposit / Withdraw (Status=1) -------
$sumDeposit = 0.0;
$stmtD = $conn->prepare("SELECT COALESCE(SUM(deposit_amount),0) AS amount
                         FROM wallet_deposit
                         WHERE email = :eid AND trade_id = :tid AND status = 1");
$stmtD->execute([':eid'=>$eid1, ':tid'=>$trade_id]);
if ($row = $stmtD->fetch(PDO::FETCH_OBJ)) $sumDeposit = (float)$row->amount;

$sumWithdraw = 0.0;
$stmtW = $conn->prepare("SELECT COALESCE(SUM(withdraw_amount),0) AS amount
                         FROM wallet_withdraw
                         WHERE email = :eid AND trade_id = :tid AND status = 1");
$stmtW->execute([':eid'=>$eid1, ':tid'=>$trade_id]);
if ($row = $stmtW->fetch(PDO::FETCH_OBJ)) $sumWithdraw = (float)$row->amount;

// ---------------- Data for password forms ----------------------
$trader_pwd   = $liveRow->trader_pwd   ?? '';
$investor_pwd = $liveRow->invester_pwd ?? '';
?>
<!doctype html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8" />
    <title>Account Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <!-- your CSS/JS includes (kept same as your file) --><!-- Bootstrap 5 bundle (includes Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-Q9w2Y8hWkIu1pO0GZL6C1sQ8a5jY5R9fQbQy8o3e5bJpCwz6yq7f8tWJ6CzQm5B4" crossorigin="anonymous"></script>

  </head>
<body class="bg-gray-100">
<?php include "header.php"; ?>
<div class="flex flex-col md:flex-row min-h-screen">
  <?php include "side_bar.php"; ?>
<style>/* If a banner/header overlay is blocking clicks, lift the tabs above it */
.nav.nav-tabs { position: relative; z-index: 20; }
.iq-banner { z-index: 1; }            /* your theme’s header */
</style>
  <main class="flex-1 p-6 md:ml-64">

    <div class="position-relative iq-banner"></div>

    <div class="conatiner-fluid content-inner mt-n5 py-0">
      <div class="row">
        <div class="col-lg-12">
          <div class="card"><div class="card-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between">
              <div class="d-flex flex-wrap align-items-center">
                <div class="profile-img position-relative me-3 mb-3 mb-lg-0 profile-logo profile-logo1">
                  <img src="assets/images/avatars/01.png" class="theme-color-default-img img-fluid rounded-pill avatar-100" alt="">
                </div>
              </div>
<ul class="nav nav-tabs" id="acctTabs" role="tablist">
  <li class="nav-item" role="presentation">
    <a class="nav-link active" data-bs-toggle="tab" href="#home" role="tab" aria-selected="true">Overview</a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" data-bs-toggle="tab" href="#deposit" role="tab" aria-selected="false">Deposit History</a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" data-bs-toggle="tab" href="#withdraw" role="tab" aria-selected="false">Withdraw History</a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" data-bs-toggle="tab" href="#openposition" role="tab" aria-selected="false">Open Position</a>
  </li>
  <li class="nav-item" role="presentation">
    <a class="nav-link" data-bs-toggle="tab" href="#closeposition" role="tab" aria-selected="false">Close Position</a>
  </li>
  <!--<li class="nav-item" role="presentation">-->
  <!--  <a class="nav-link" data-bs-toggle="tab" href="#copied" role="tab" aria-selected="false">Our Assets</a>-->
  <!--</li>-->
  <!--<li class="nav-item" role="presentation">-->
  <!--  <a class="nav-link" data-bs-toggle="tab" href="#password" role="tab" aria-selected="false">Change Password</a>-->
  <!--</li>-->
</ul>
            </div>
          </div></div>
        </div>

        <div class="tab-content" id="myTabContent">
          <!-- ================= Overview ================= -->
          <div class="tab-pane fade show active" id="home" role="tabpanel">
            <center><h4 class="counter">Trading Account - <?= h($trade_id) ?></h4></center><br>

            <div class="container mt-4">
              <!-- Account Details Panel -->
              <div class="panel panel-flat" style="padding:0;border-radius:10px">
                <div class="panel-heading border-bottom" style="padding:20px;background-color:#3a57e8">
                  <h5 class="panel-title text-bold pl-10" style="color:white">Account Details</h5>
                </div>
                <div class="panel-body">
                  <div class="row">
                    <!-- Left -->
                    <div class="col-lg-4">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Balance</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format((float)$balance, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                          <tr>
                            <td class="no-border-top">
                              <span style="font-weight:bold">Credit</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format((float)$credit, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Equity</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format((float)$equity, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Margin</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format((float)$margin, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                    <!-- Middle -->
                    <div class="col-lg-4">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Created</span>
                              <span class="text-right pull-right text-secondry" id="account-details-opened"><?= h($createdText) ?></span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Free Margin</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format((float)$marginFree, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Volume</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right"><?= number_format($totalVolumeLots, 2) ?> Lots</span>
                              </span>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                    <!-- Right -->
                    <div class="col-lg-4">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Total Deposits</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format($sumDeposit, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Total Withdrawals</span>
                              <span class="text-right pull-right text-secondry">
                                <span class="pull-right account-details-currency"><?= '$' . number_format($sumWithdraw, 2) ?></span>
                              </span>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                  </div>
                </div>
              </div>

              <!-- Statistics Panel -->
              <div class="panel panel-flat" style="padding:0;border-radius:10px;margin-top:24px">
                <div class="panel-heading border-bottom" style="padding:20px;background-color:#3a57e8">
                  <h5 class="panel-title text-bold pl-10" style="color:white">Statistics</h5>
                </div>
                <div class="panel-body">
                  <div class="row">
                    <!-- Left -->
                    <div class="col-md-4 no-padding-left">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Total Trades</span></td>
                            <td class="text-right pull-right text-secondry"><span id="account-total-trades"><?= (int)$totalTrades ?></span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Profitability</span></td>
                            <td class="text-right pull-right text-secondry"><span id="account-profitability"><?= number_format($winrate, 2) ?></span>%</td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Points</span></td>
                            <td class="text-right pull-right text-secondry"><span id="account-points">0</span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Average Win</span></td>
                            <td class="text-right pull-right text-secondry">
                              <span id="account-avg-win-points"><?= (int)$wins ?></span> <span>points</span> /
                              <span id="account-avg-win-curr"><?= (int)$wins ?></span>
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Average Loss</span></td>
                            <td class="text-right pull-right text-secondry">
                              <span id="account-avg-loss-points"><?= (int)$losses ?></span> <span>points</span> /
                              <span id="account-avg-loss-curr"><?= (int)$losses ?></span>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                    <!-- Middle -->
                    <div class="col-md-4">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Profitable Long Trades</span></td>
                            <td class="text-right pull-right text-secondry">
                              (<span id="account-long-trades-num"><?= (int)$longCount ?></span>/<span id="account-long-trades-out-of"><?= (int)$totalTrades ?></span>)
                              <span id="account-long-trades-perc"><?= number_format($longPerc, 2) ?></span>%
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Profitable Short Trades</span></td>
                            <td class="text-right pull-right text-secondry">
                              (<span id="account-short-trades-num"><?= (int)$shortCount ?></span>/<span><?= (int)$totalTrades ?></span>)
                              <span><?= number_format($shortPerc, 2) ?></span>%
                            </td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Best Trade</span> (<span class="account-details-currency"></span>)</td>
                            <td class="text-right pull-right text-secondry">(<span>-</span>) <span>0</span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Worst Trade</span> (<span class="account-details-currency"></span>)</td>
                            <td class="text-right pull-right text-secondry">(<span>-</span>) <span>0</span></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                    <!-- Right -->
                    <div class="col-md-4">
                      <table class="table table-borderless table-xs content-group-sm table-analytics no-margin">
                        <tbody>
                          <tr>
                            <td><span style="font-weight:bold">Best Trade</span> (<span>Points</span>)</td>
                            <td class="text-right pull-right text-secondry">(<span>-</span>) <span>0</span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Worst Trade</span> (<span>Points</span>)</td>
                            <td class="text-right pull-right text-secondry">(<span>-</span>) <span>0</span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Profit Factor</span></td>
                            <td class="text-right pull-right text-secondry"><span>1.00</span></td>
                          </tr>
                          <tr>
                            <td><span style="font-weight:bold">Recovery Factor</span></td>
                            <td class="text-right pull-right text-secondry"><span>1.0</span></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>

                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Deposit History ================= -->
           <div class="tab-pane fade" id="deposit" role="tabpanel">
            <div class="card">
              <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Deposit History</h4></div></div>
              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                    <thead>
                      <tr>
                        <th>Trading Account</th><th>Currency</th><th>Deposit Type</th><th>Amount</th><th>Status</th><th>Remarks</th><th>Date</th>
                      </tr>
                    </thead>
                    <tbody>
                    <?php
                      $stmt = $conn->prepare("SELECT * FROM wallet_deposit WHERE trade_id = :tid");
                      $stmt->execute([':tid'=>$trade_id]);
                      foreach ($stmt->fetchAll(PDO::FETCH_OBJ) as $row): ?>
                        <tr>
                          <td><div class="d-flex align-items-center"><h6><?= h($row->trade_id) ?></h6></div></td>
                          <td>USD</td>
                          <td><div class="d-flex align-items-center"><h6><?= h($row->deposit_type) ?></h6></div></td>
                          <td><?= h($row->deposit_amount) ?>$</td>
                          <td>
                            <?php
                              $status = (int)$row->Status;
                              if ($status === 0)   echo '<label class="badge" style="background-color:orange;color:white;padding:4px 8px">Pending</label>';
                              elseif ($status===1) echo '<label class="badge" style="background-color:green;color:white;padding:4px 8px">Success</label>';
                              else                 echo '<label class="badge" style="background-color:red;color:white;padding:4px 8px">Failed</label>';
                            ?>
                          </td>
                          <td><?= h($row->AdminRemark) ?></td>
                          <td><?= h($row->deposted_date) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Withdraw History ================= -->
          <div class="tab-pane fade" id="withdraw" role="tabpanel">
            <div class="card">
              <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Withdraw History</h4></div></div>
              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                    <thead>
                      <tr>
                        <th>Trading Account</th><th>Currency</th><th>Withdraw Type</th><th>Amount</th><th>Status</th><th>Remarks</th><th>Date</th>
                      </tr>
                    </thead>
                    <tbody>
                    <?php
                      $stmt = $conn->prepare("SELECT * FROM wallet_withdraw WHERE trade_id = :tid");
                      $stmt->execute([':tid'=>$trade_id]);
                      foreach ($stmt->fetchAll(PDO::FETCH_OBJ) as $row): ?>
                        <tr>
                          <td><div class="d-flex align-items-center"><h6><?= h($row->trade_id) ?></h6></div></td>
                          <td>USD</td>
                          <td><div class="d-flex align-items-center"><h6><?= h($row->withdraw_type) ?></h6></div></td>
                          <td><?= h($row->withdraw_amount) ?>$</td>
                          <td>
                            <?php
                              $status = (int)$row->Status;
                              if ($status === 0)   echo '<label class="badge" style="background-color:orange;color:white;padding:4px 8px">Pending</label>';
                              elseif ($status===1) echo '<label class="badge" style="background-color:green;color:white;padding:4px 8px">Success</label>';
                              else                 echo '<label class="badge" style="background-color:red;color:white;padding:4px 8px">Failed</label>';
                            ?>
                          </td>
                          <td><?= h($row->AdminRemark) ?></td>
                          <td><?= h($row->withdraw_date) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Open Positions ================= -->
           <div class="tab-pane fade" id="openposition" role="tabpanel">
            <div class="card">
              <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Trade Open Position</h4></div></div>
              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                    <thead>
                      <tr>
                        <th>Symbol</th><th>Open</th><th>Current</th><th>SL</th><th>TP</th><th>Volume</th><th>Action</th><th>P/L</th><th>Swap</th><th>Placed Time</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($resulttrade1 as $p): ?>
                        <tr>
                          <td><?= h($p->Symbol) ?></td>
                          <td><?= h($p->PriceOpen) ?></td>
                          <td><?= h($p->PriceCurrent) ?></td>
                          <td><?= h($p->PriceSL) ?></td>
                          <td><?= h($p->PriceTP) ?></td>
                          <td><?= number_format((float)$p->Volume * 0.0001, 2) ?></td>
                          <td><?= (($p->Action ?? 0) == 1) ? 'Sell' : 'Buy' ?></td>
                          <td><?= h($p->Profit) ?></td>
                          <td><?= h($p->Storage) ?></td>
                          <td><?php
                              $ts = (int)($p->TimeCreate ?? 0);
                              echo $ts ? gmdate("F j, Y, h:i:s a", $ts) : '-';
                          ?></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Close Positions (History) ================= -->
          <div class="tab-pane fade" id="closeposition" role="tabpanel">
            <div class="card">
              <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Trade Close Position</h4></div></div>
              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                    <thead>
                      <tr>
                        <th>Open Time</th><th>Ticket</th><th>Action</th><th>Volume</th><th>Symbol</th><th>Open Price</th><th>Close Price</th><th>Close Time</th><th>Commission</th><th>Swap</th><th>Profit</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($resulttradehistory1 as $t):
                        $lots = (float)$t->VolumeClosed * 0.0001;
                        if (($t->Order ?? 0) == 0 || $lots == 0.0) continue;

                        // Open/Close timestamps
                        $openTime  = !empty($t->Time)    ? (new DateTime("@".$t->Time))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i A') : '-';
                        $closeBase = !empty($t->TimeMsc) ? (int)floor($t->TimeMsc/1000) : 0;
                        $closeMs   = !empty($t->TimeMsc) ? ((int)$t->TimeMsc % 1000) : 0;
                        $closeDT   = $closeBase ? (new DateTime('@'.$closeBase))->setTimezone(new DateTimeZone('Asia/Kolkata'))->format('l, F j, Y g:i A') . '.' . $closeMs : '-';
                      ?>
                        <tr>
                          <td><?= h($openTime) ?></td>
                          <td><?= h($t->Order) ?></td>
                          <td><?= (($t->Action ?? 0) == 1) ? 'Sell' : 'Buy' ?></td>
                          <td><?= number_format($lots, 2) ?></td>
                          <td><?= h($t->Symbol) ?></td>
                          <td><?= h($t->PricePosition) ?></td>
                          <td><?= h($t->Price) ?></td>
                          <td><?= h($closeDT) ?></td>
                          <td><?= h($t->Commission) ?></td>
                          <td><?= h($t->Storage) ?></td>
                          <td><?= h($t->Profit) ?></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Our Assets (copied) ================= -->
           <div class="tab-pane fade" id="copied" role="tabpanel">
            <div class="card">
              <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Copied Accounts</h4></div></div>
              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="basic-table" class="table table-striped mb-0" role="grid">
                    <tr>
                      <th></th><th>Commission</th><th>Volume Setting</th><th>Volume Defined</th><th>Copier</th><th>Action</th>
                    </tr>
                    <tbody>
                    <?php
                      $stmt = $conn->prepare("SELECT * FROM copyaccounts WHERE slavetrade = :tid");
                      $stmt->execute([':tid'=>$trade_id]);
                      $copyRows = $stmt->fetchAll(PDO::FETCH_OBJ);

                      foreach ($copyRows as $row):
                        $strategyname = h($row->strategyname);
                        $strategyimage= h($row->strategyimage);
                        $commission   = h($row->commission);
                        $mastertrade  = (int)$row->mastertrade;
                        $slavetrade   = (int)$row->slavetrade;
                        $volsel       = (int)$row->volumeselect;
                        $voldef       = h($row->volume);

                        // total copiers for master
                        $stmtCt = $conn->prepare("SELECT COUNT(*) FROM copyaccounts WHERE mastertrade = :m");
                        $stmtCt->execute([':m'=>$mastertrade]);
                        $copiers = (int)$stmtCt->fetchColumn();

                        // master account equity/balance (optional)
                        $api->UserAccountGet($mastertrade, $account2);
                        $balance2 = $account2->Balance ?? 0;
                    ?>
                      <tr>
                        <td>
                          <div class="d-flex align-items-center">
                            <img class="rounded img-fluid avatar-70 me-4 bg-soft-secondry" src="masterdoc/<?= $strategyimage ?>" alt="profile">
                            <p><b><?= $strategyname ?></b><br>Risk 1</p>
                          </div>
                        </td>
                        <td><?= $commission ?>%</td>
                        <td>
                          <?php
                            if     ($volsel===1) echo "Normal mode according to balance";
                            elseif ($volsel===2) echo "Same as master lot";
                            elseif ($volsel===3) echo "Double to master lot";
                            elseif ($volsel===4) echo "I will define my lot";
                            else                 echo "-";
                          ?>
                        </td>
                        <td><?= $voldef ?></td>
                        <td><div class="text-info"><?= $copiers ?></div></td>
                        <td>
                          <form action="unsubscribe_copy_trade" method="POST">
                            <input type="hidden" name="tradeid2" value="<?= h((string)$slavetrade) ?>">
                            <button class="btn btn-secondry" style="background-color:#3a57e8;color:white" type="submit">Unsubscribe</button>
                          </form>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- ================= Change Password ================= -->
          <div class="tab-pane fade" id="password" role="tabpanel">
            <div class="row">
              <!-- Master -->
              <div class="col-sm-6">
                <div class="card">
                  <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Change Master Password</h4></div></div>
                  <div class="card-body">
                    <form action="update_trader_pwd" method="post">
                      <div class="form-group">
                        <label class="form-label">Old Master Password</label>
                        <input type="text" class="form-control" id="mainpassword" name="current_pwd" style="background-color:#e6e6e6" value="<?= h($trader_pwd) ?>" readonly>
                      </div>
                      <div class="form-group">
                        <label class="form-label" for="newPassword">New Password</label>
                        <div class="input-group">
                          <input type="password" class="form-control" name="new_pwd" id="newPassword" required
                            pattern="^(?=.*[A-Z])(?=.*[0-9])(?=.*[\W_])[A-Za-z0-9\W_]{8,}$"
                            title="Password must be at least 8 characters long, include 1 uppercase letter, 1 number, and 1 special character.">
                          <div class="input-group-append">
                            <span class="input-group-text" onclick="togglePasswordVisibility('newPassword')"><i class="fa fa-eye" id="eyeIconNew"></i></span>
                          </div>
                        </div>
                        <small id="passwordHelp" class="form-text text-danger"></small>
                      </div>
                      <div class="form-group">
                        <label class="form-label" for="confirmPassword">Confirm New Password</label>
                        <div class="input-group">
                          <input type="hidden" name="tradeid" value="<?= h($trade_id) ?>">
                          <input type="password" class="form-control" name="confirm_pwd" id="confirmPassword" required
                            pattern="^(?=.*[A-Z])(?=.*[0-9])(?=.*[\W_])[A-Za-z0-9\W_]{8,}$"
                            title="Password must be at least 8 characters long, include 1 uppercase letter, 1 number, and 1 special character.">
                          <div class="input-group-append">
                            <span class="input-group-text" onclick="togglePasswordVisibility('confirmPassword')"><i class="fa fa-eye" id="eyeIconConfirm"></i></span>
                          </div>
                        </div>
                        <small id="passwordHelp" class="form-text text-danger"></small>
                      </div>
                      <button type="submit" class="btn btn-primary">Change Master Password</button>
                    </form>
                  </div>
                </div>
              </div>

              <!-- Investor -->
              <div class="col-sm-6">
                <div class="card">
                  <div class="card-header d-flex justify-content-between"><div class="header-title"><h4 class="card-title">Change Investor Password</h4></div></div>
                  <div class="card-body">
                    <form action="update_investor_pwd" method="post">
                      <div class="form-group">
                        <label class="form-label">Old Investor Password</label>
                        <input type="text" class="form-control" name="current_pwd" style="background-color:#e6e6e6" value="<?= h($investor_pwd) ?>" readonly>
                        <input type="hidden" name="tradeid" value="<?= h($trade_id) ?>" readonly>
                      </div>
                      <div class="form-group">
                        <label class="form-label" for="newPassword2">New Password</label>
                        <div class="input-group">
                          <input type="password" class="form-control" name="new_pwd" id="newPassword2" required
                            pattern="^(?=.*[A-Z])(?=.*[0-9])(?=.*[\W_])[A-Za-z0-9\W_]{8,}$"
                            title="Password must be at least 8 characters long, include 1 uppercase letter, 1 number, and 1 special character.">
                          <div class="input-group-append">
                            <span class="input-group-text" onclick="togglePasswordVisibility2('newPassword2')"><i class="fa fa-eye" id="eyeIconNew2"></i></span>
                          </div>
                        </div>
                        <small id="passwordHelp2" class="form-text text-danger"></small>
                      </div>
                      <div class="form-group">
                        <label class="form-label" for="confirmPassword2">Confirm New Password</label>
                        <div class="input-group">
                          <input type="password" class="form-control" name="confirm_pwd" id="confirmPassword2" required
                            pattern="^(?=.*[A-Z])(?=.*[0-9])(?=.*[\W_])[A-Za-z0-9\W_]{8,}$"
                            title="Password must be at least 8 characters long, include 1 uppercase letter, 1 number, and 1 special character.">
                          <div class="input-group-append">
                            <span class="input-group-text" onclick="togglePasswordVisibility2('confirmPassword2')"><i class="fa fa-eye" id="eyeIconConfirm2"></i></span>
                          </div>
                        </div>
                        <small id="passwordHelp2" class="form-text text-danger"></small>
                      </div>
                      <button type="submit" class="btn btn-primary" onclick="return validatePasswords2()">Change Investor Password</button>
                    </form>
                  </div>
                </div>
              </div>

            </div>
          </div>
          <!-- /password -->
        </div>
      </div>
    </div>
  </main>

  <?php include 'footer1.php'; ?>
</div>

<script>
  function togglePasswordVisibility(id){
    var f=document.getElementById(id), i=document.getElementById('eyeIcon'+(id==='newPassword'?'New':'Confirm'));
    if (f.type==='password'){ f.type='text'; i.classList.remove('fa-eye'); i.classList.add('fa-eye-slash'); }
    else { f.type='password'; i.classList.remove('fa-eye-slash'); i.classList.add('fa-eye'); }
  }
  function togglePasswordVisibility2(id){
    var f=document.getElementById(id), i=document.getElementById('eyeIcon'+(id==='newPassword2'?'New2':'Confirm2'));
    if (f.type==='password'){ f.type='text'; if(i){i.classList.remove('fa-eye'); i.classList.add('fa-eye-slash');} }
    else { f.type='password'; if(i){i.classList.remove('fa-eye-slash'); i.classList.add('fa-eye');} }
  }
  function validatePasswords2(){
    var a=document.getElementById('newPassword2').value, b=document.getElementById('confirmPassword2').value, h=document.getElementById('passwordHelp2');
    if (a!==b){ h.textContent='Passwords do not match!'; h.style.color='red'; return false; } else { h.textContent=''; return true; }
  }

  // Activate tab by URL hash
  document.addEventListener("DOMContentLoaded", function(){
    function activateTabByHash(){
      const hash = window.location.hash;
      if (!hash) return;
      const btn = document.querySelector(`button[data-bs-target="${hash}"]`);
      if (btn){ new bootstrap.Tab(btn).show(); }
    }
    activateTabByHash();
    window.addEventListener("hashchange", activateTabByHash);
  });
</script>

<!-- Your original JS bundle includes -->
<script src="assets/js/core/libs.min.js"></script>
<script src="assets/js/core/external.min.js"></script>
<script src="assets/js/charts/widgetcharts.js"></script>
<script src="assets/js/charts/vectore-chart.js"></script>
<script src="assets/js/charts/dashboard.js"></script>
<script src="assets/js/plugins/fslightbox.js"></script>
<script src="assets/js/plugins/setting.js"></script>
<script src="assets/js/plugins/slider-tabs.js"></script>
<script src="assets/js/plugins/form-wizard.js"></script>
<script src="assets/vendor/aos/dist/aos.js"></script>
<script src="assets/js/hope-ui.js" defer></script><script>
  // Activate tab from URL hash (e.g., ...account_details.php#closeposition)
  document.addEventListener("DOMContentLoaded", function () {
    function activateFromHash() {
      const hash = window.location.hash;
      if (!hash) return;
      const trigger = document.querySelector(`a[data-bs-toggle="tab"][href="${hash}"]`);
      if (trigger && window.bootstrap?.Tab) new bootstrap.Tab(trigger).show();
    }

    // When a tab is shown, update the URL hash
    document.querySelectorAll('a[data-bs-toggle="tab"]').forEach(a => {
      a.addEventListener('shown.bs.tab', e => {
        const href = e.target.getAttribute('href');
        if (href) history.replaceState(null, '', href);
      });
    });

    activateFromHash();
    window.addEventListener('hashchange', activateFromHash);
  });

  // Fallback if Bootstrap failed to load for any reason
  if (!window.bootstrap) {
    console.warn('Bootstrap not detected; using manual tab switcher.');
    const links = document.querySelectorAll('a[data-bs-toggle="tab"]');
    const panes = document.querySelectorAll('.tab-pane');
    links.forEach(a => a.addEventListener('click', ev => {
      ev.preventDefault();
      links.forEach(x => x.classList.remove('active'));
      panes.forEach(p => p.classList.remove('show','active'));
      a.classList.add('active');
      const pane = document.querySelector(a.getAttribute('href'));
      if (pane) pane.classList.add('show','active');
      history.replaceState(null, '', a.getAttribute('href'));
    }));
  }
</script><!-- keep exactly ONE of these; prefer the CDN bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script>
(function () {
  const tablistSelector = '#acctTabs a[data-bs-toggle="tab"]';
  const links = Array.from(document.querySelectorAll(tablistSelector));
  const panes = Array.from(document.querySelectorAll('#myTabContent .tab-pane'));

  function setActive(link) {
    // remove active from all
    links.forEach(a => a.classList.remove('active'));
    panes.forEach(p => p.classList.remove('active','show'));

    // add active to clicked link + target pane
    link.classList.add('active');
    const target = document.querySelector(link.getAttribute('href'));
    if (target) target.classList.add('active','show');
  }

  // click handler (manual + Bootstrap if available)
  links.forEach(link => {
    link.addEventListener('click', function (e) {
      e.preventDefault();
      // manual toggle (always works)
      setActive(this);

      // try Bootstrap API (if present, it will sync ARIA attrs too)
      try { if (window.bootstrap?.Tab) new bootstrap.Tab(this).show(); } catch (_) {}

      // update hash without scrolling
      const href = this.getAttribute('href');
      if (href) history.replaceState(null, '', href);
    });
  });

  // initial: open tab from URL hash (or keep default)
  const initialHash = window.location.hash;
  if (initialHash) {
    const init = document.querySelector(`#acctTabs a[href="${initialHash}"]`);
    if (init) setActive(init);
  }

  // react to back/forward on the hash
  window.addEventListener('hashchange', () => {
    const link = document.querySelector(`#acctTabs a[href="${location.hash}"]`);
    if (link) setActive(link);
  });
})();
</script>


</body>
</html>
