<?php
session_start();
include 'config.php';

if (strlen($_SESSION['clogin']) == 0) {
    echo "<script>window.location.href='login.php';</script>";
}
?><?php include 'manager_initialize.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account List</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            padding: 10px;
        }
        .modal-content {
            background-color: white;
            padding: 15px;
            border-radius: 8px;
            width: 90%;
            max-width: 600px;
            font-size: 14px;
        }
        .modal-body {
            display: grid;
            grid-template-columns: 1fr;
            gap: 10px;
        }
        .modal-footer {
            text-align: right;
            margin-top: 10px;
        }
        .close-btn {
            background-color: #CD7F32;
            color: white;
            padding: 6px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body class="bg-gray-100 text-sm md:text-base">
    <?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <?php include "side_bar.php";?>
        <main class="flex-1 p-4 md:p-6 md:ml-64">
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-300 rounded-md text-xs md:text-sm">
                    <thead class="bg-gray-200">
                        <tr class="text-gray-700">
                            <th class="p-2 md:p-3 border-b text-left">Serial No.</th>
                            <th class="p-2 md:p-3 border-b text-left">MT5 ID</th>
                            <th class="p-2 md:p-3 border-b text-left">Account Type</th>
                            <th class="p-2 md:p-3 border-b text-left">Name</th>
                            <th class="p-2 md:p-3 border-b text-left">Date</th>
                            <th class="p-2 md:p-3 border-b text-left">Action</th>
                        </tr>
                    </thead>
<tbody class="text-gray-600">
<?php
        include 'config.php';
        $email = $_SESSION['clogin'];
        $sql = "SELECT  * FROM liveaccount WHERE email = '$email'";
        $query = $conn->prepare($sql);
        $query->execute();
        $results = $query->fetchAll(PDO::FETCH_OBJ);
        $cnt = 1;
        if ($query->rowCount() > 0) {
            // Change the foreach loop to:
foreach ($results as $row) {
    echo "<tr class='border-b hover:bg-gray-100'>";
    echo "<td class='p-2 md:p-3'>" . $cnt++ . "</td>";
    echo "<td class='p-2 md:p-3'>" . htmlspecialchars($row->trade_id) . "</td>";
    echo "<td class='p-2 md:p-3'>Live</td>";
    echo "<td class='p-2 md:p-3'>" . htmlspecialchars($row->account_name) . "</td>";
    echo "<td class='p-2 md:p-3'>" . date('Y-m-d', strtotime($row->Registered_Date)) . "</td>";
   echo "<td>
                                <a href='account_details.php?tradeid=$row->trade_id' style='padding: 5px 20px;font-size: 12px;' class='btn btn-dark btn-sm'>View</a>

</td>";
echo "</tr>";
}
} else {
    echo "<tr><td colspan='10' class='p-3 text-center'>No accounts found</td></tr>";
}
?>
</tbody>
                </table>
            </div>
        </main>
    </div>
    <?php include "footer.php";?>
    <div id="viewModal" class="modal">
        <div class="modal-content">
            <div class="font-bold mb-3">Account Details</div>
            <div id="modalBody" class="modal-body"></div>
            <div class="modal-footer">
                <button class="close-btn" onclick="closeModal()">Close</button>
            </div>
        </div>
    </div>
    <script>
      function openModal(accountId) {
    console.log("Opening modal for Account ID:", accountId); // Check if the ID is passed

    let modalBody = document.getElementById('modalBody');
    fetch(`get_account.php?id=${accountId}`)
        .then(response => response.json())
        .then(data => {
            console.log("Fetched data:", data); // Check if data is fetched

            modalBody.innerHTML = `
                <p><strong>Login ID:</strong> ${data.mt5_id}</p>
                <p><strong>Balance:</strong> ${data.balance}</p>
                <p><strong>Profit:</strong> ${data.profit}</p>
                <p><strong>Equity:</strong> ${data.equity}</p>
            `;
            document.getElementById('viewModal').style.display = 'flex';
        })
        .catch(error => {
            console.error('Error fetching data:', error);
        });
}

    </script>
    <script>function closeModal() {
    document.getElementById('viewModal').style.display = 'none';
}</script>
</body>
</html>


