<?php
session_start();
error_reporting(0);
include('config.php');

if(strlen($_SESSION['clogin']) == 0) {
    header('location:login.php');
    exit;
}

include 'manager_initialize.php'; // defines $api, MTRetCode, etc.
?>
<!doctype html>
<html lang="en" dir="ltr">
  <head>
    <?php include 'title.php'; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>

  </head>
   
  <style>
    :root{
      --orange-600:#F1671B; --orange-500:#ff7a00; --orange-50:#FFF5ED;
      --ink-900:#0f172a; --ink-700:#334155; --ink-500:#64748b;
      --border:#e5e7eb; --bg:#ffffff; --card:#ffffff; --muted:#f8fafc;
      --ring: rgba(241,103,27,.25);
      --shadow:0 10px 25px rgba(15,23,42,.06), 0 2px 8px rgba(15,23,42,.05);
    }
    html,body{font-family:'Inter',system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:var(--orange-50);color:var(--ink-900)}
    .brand-navbar{background:var(--bg);border-bottom:1px solid var(--border);position:sticky;top:0;z-index:40}
    .brand-navbar .nav-link{font-weight:600;color:var(--ink-700);border-radius:10px;padding:.6rem .9rem!important}
    .brand-navbar .nav-link.active,.brand-navbar .nav-link:hover{color:var(--orange-600);background:#fff;box-shadow:inset 0 0 0 2px var(--orange-50)}
    .brand-badge{background:var(--orange-600);color:#fff;padding:.45rem .75rem;border-radius:10px;font-weight:700;letter-spacing:.3px}

    .top{position:sticky;top:0;z-index:50;backdrop-filter:saturate(180%) blur(8px);background:rgba(255,255,255,.85);border-bottom:1px solid var(--border)}
    .top-inner{max-width:1200px;margin:0 auto;padding:12px 18px;display:flex;gap:12px;align-items:center}
    .logo{display:flex;align-items:center;gap:10px;font-weight:800}
    .logo-b{width:36px;height:36px;border-radius:12px;display:grid;place-items:center;color:#fff;background:linear-gradient(135deg,var(--orange-600),#ff9952);box-shadow:var(--shadow)}
    .grow{flex:1}
    .search{display:flex;align-items:center;gap:8px;background:#fff;border:1px solid var(--border);border-radius:999px;padding:8px 12px}
    .search input{border:0;outline:0;width:100%;font:inherit}
    .btn{appearance:none;border:0;border-radius:999px;padding:10px 16px;font-weight:700;cursor:pointer}
    .btn-primary{background:var(--orange-600)!important;border-color:var(--orange-600)!important;color:#fff}
    .btn-ghost{background:transparent;color:var(--orange-600)}

    .wrap{max-width:1200px;margin:24px auto;padding:0 18px}
    .head{display:flex;flex-wrap:wrap;align-items:flex-end;justify-content:space-between;gap:12px}
    .title{font-size:28px;font-weight:800;margin:0}
    .crumbs{font-size:12px;color:var(--ink-500)}

    .grid{display:grid;gap:14px}
    .g-4{grid-template-columns:repeat(4,minmax(0,1fr))}
    @media(max-width:1100px){ .g-4{grid-template-columns:repeat(2,minmax(0,1fr))} }
    @media(max-width:640px){ .g-4{grid-template-columns:1fr} }

    .card{border:1px solid var(--border);border-radius:14px;background:#fff;box-shadow:var(--shadow)}
    .card-h{display:flex;align-items:center;justify-content:space-between;padding:16px 16px 0 16px}
    .card-t{font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;font-weight:700}
    .badge{display:inline-flex;align-items:center;gap:6px;background:#fff7f0;color:#c2410c;padding:6px 10px;border-radius:999px;font-size:12px;font-weight:700}
    .card-b{padding:16px}
    .kpi{font-size:26px;font-weight:800}
    .kpi-sub{font-size:12px;color:var(--ink-500);margin-top:6px}
    .up{color:#16a34a}.down{color:#dc2626}

    .filters{margin-top:16px;background:#fff;border:1px solid var(--border);border-radius:18px;box-shadow:var(--shadow)}
    .filters .row{display:grid;grid-template-columns:1fr auto;gap:10px;padding:16px}
    @media(max-width:640px){.filters .row{grid-template-columns:1fr}}
    .lab{font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;font-weight:700}
    .in{padding:10px 12px;border:1px solid var(--border);border-radius:12px;background:#fff;width:100%}

    .panel{margin-top:16px;background:#fff;border:1px solid var(--border);border-radius:18px;box-shadow:var(--shadow)}
    .panel-h{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
    .panel-t{font-weight:800}
    .table-wrap{overflow:auto}
    table{width:100%;border-collapse:separate;border-spacing:0}
    thead th{position:sticky;top:0;background:#fff;border-bottom:1px solid var(--border);text-align:left;font-size:12px;color:var(--ink-500);text-transform:uppercase;letter-spacing:.08em;padding:14px}
    tbody td{padding:14px;border-bottom:1px solid #faf3ec;vertical-align:middle}
    tbody tr:hover{background:#fffaf5}
    .pill{padding:6px 10px;border-radius:999px;font-size:12px;font-weight:700;display:inline-flex;align-items:center;gap:6px}
    .ok{background:#ecfdf5;color:#16a34a}
    .warn{background:#fffbeb;color:#f59e0b}
    .bad{background:#fef2f2;color:#dc2626}
    .pl-pos{color:#16a34a;font-weight:800}
    .pl-neg{color:#dc2626;font-weight:800}
  </style>
  <body class="  ">
    <span class="screen-darken"></span>
    <!-- loader Start -->
    <div id="loading">
      <div class="loader simple-loader">
          <div class="loader-body"></div>
      </div>
    </div>
    <!-- loader END -->
    <main class="main-content">
      <!--Nav Start-->
      <?php include 'header.php'; ?>

 <nav class="navbar navbar-expand-lg brand-navbar">
    <div class="container-fluid">
      <!--<span class="brand-badge">Demo Markets IB</span>-->
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
              aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation"
              style="border-color: var(--orange-600);">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto gap-2">
          <li class="nav-item"><a class="nav-link" href="dashboard"><i class="fa fa-home me-1"></i>Dashboard</a></li>
          <li class="nav-item"><a class="nav-link active" href="<?= htmlspecialchars($current_script) ?>"><i class="fa fa-users me-1"></i>Clients</a></li>
          <li class="nav-item"><a class="nav-link " href="trades"><i class="fa fa-bar-chart me-1"></i>Trade List</a></li>
          <li class="nav-item"><a class="nav-link" href="withdraw"><i class="fa fa-institution me-1"></i>Payout</a></li>
        </ul>
      </div>
    </div>
  </nav>
<?php
/* ----------------------------- DATA PREP ----------------------------- */
$eid = $_SESSION["clogin"];
$levelFilter = isset($_GET['level']) ? intval($_GET['level']) : 1;

/* Fetch clients for the selected level (same as your code) */
$sqlClientsByLevel = "SELECT *, 
        CASE
            WHEN ib1=:eid THEN 1
            WHEN ib2=:eid THEN 2
            WHEN ib3=:eid THEN 3
            WHEN ib4=:eid THEN 4
            WHEN ib5=:eid THEN 5
            WHEN ib6=:eid THEN 6
            WHEN ib7=:eid THEN 7
            WHEN ib8=:eid THEN 8
            WHEN ib9=:eid THEN 9
            WHEN ib10=:eid THEN 10
            ELSE NULL
        END AS level 
        FROM liveaccount
        WHERE (ib1=:eid OR ib2=:eid OR ib3=:eid OR ib4=:eid OR ib5=:eid OR ib6=:eid OR ib7=:eid OR ib8=:eid OR ib9=:eid OR ib10=:eid)
        HAVING level = :levelFilter";

$query = $dbh->prepare($sqlClientsByLevel);
$query->bindParam(':eid', $eid, PDO::PARAM_STR);
$query->bindParam(':levelFilter', $levelFilter, PDO::PARAM_INT);
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);

/* Build trade id list for JS */
$trade_ids = [];
if ($query->rowCount() > 0) {
  foreach ($results as $result) {
    $trade_ids[] = htmlentities($result->trade_id);
  }
}
$trade_ids_string = implode(',', $trade_ids);

/* ----------------- TIER-1 ONLY BALANCE GATE FOR ALL LEVELS -----------------
   Rule:
   - Level 1 -> always eligible
   - Level L (>=2) -> eligible iff SUM(balance of Tier-1 accounts) >= L * 500
----------------------------------------------------------------------------- */

/* 1) Get Tier-1 clients (ib1 = $eid) */
$sqlTier1 = "SELECT trade_id FROM liveaccount WHERE ib1 = :eid";
$qTier1   = $dbh->prepare($sqlTier1);
$qTier1->bindParam(':eid', $eid, PDO::PARAM_STR);
$qTier1->execute();
$tier1Rows = $qTier1->fetchAll(PDO::FETCH_OBJ);

/* 2) Sum their MT5 balances */
$tier1SumBalance = 0.0;
if ($tier1Rows) {
  foreach ($tier1Rows as $row) {
    $login = $row->trade_id;
    if (($error_code = $api->UserAccountGet($login, $account)) == MTRetCode::MT_RET_OK) {
      $tier1SumBalance += (float)$account->Balance;
    }
  }
}

/* 3) Gate by L×500 */
function level_threshold(int $level): float {
  if ($level <= 1) return 0.0;        // L1 always eligible
  return $level * 500.0;              // L=2→1000, L=3→1500, L=4→2000, ...
}
$requiredThreshold = level_threshold($levelFilter);
$tierEligible = ($levelFilter === 1) ? true : ($tier1SumBalance >= $requiredThreshold);
?>

      <div class="conatiner-fluid content-inner pb-0">
        <div class="row">
          <div class="col-md-12 col-lg-12">

            <center><h5><b>Total Business Generated for Tier <?php echo (int)$_GET['level']; ?></b></h5></center>

            <!-- Optional helper line so admins see gating status -->
            <div class="text-center" style="margin-top:10px;color:#666;">
              Tier-1 Sum: <b><?php echo number_format($tier1SumBalance,2); ?></b> |
              Level <?php echo (int)$levelFilter; ?> Threshold:
              <b><?php echo number_format($requiredThreshold,2); ?></b> |
              Eligible: <b><?php echo $tierEligible ? 'Yes' : 'No'; ?></b>
            </div>

            <div class="row" style="margin-top: 20px;">
              <style>
                .custom-col { flex: 0 0 calc(20% - 10px); max-width: calc(20% - 10px); margin-right: 5px; margin-left: 5px; }
                .btn{ padding-top: 2px; padding-bottom: 2px; background-color:#f16a1b; }
              </style>

              <!-- KPI cards -->
              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card position-relative" style="border-top: 2px solid #079aa2; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-info text-white rounded p-2">
                        <!-- icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-currency-exchange" viewBox="0 0 16 16">
                          <path d="M0 5a5 5 0 0 0 4.027 4.905 6.5 6.5 0 0 1 .544-2.073C3.695 7.536 3.132 6.864 3 5.91h-.5v-.426h.466V5.05q-.001-.07.004-.135H2.5v-.427h.511C3.236 3.24 4.213 2.5 5.681 2.5c.316 0 .59.031.819.085v.733a3.5 3.5 0 0 0-.815-.082c-.919 0-1.538.466-1.734 1.252h1.917v.427h-1.98q-.004.07-.003.147v.422h1.983v.427H3.93c.118.602.468 1.03 1.005 1.229a6.5 6.5 0 0 1 4.97-3.113A5.002 5.002 0 0 0 0 5m16 5.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0m-7.75 1.322c.069.835.746 1.485 1.964 1.562V14h.54v-.62c1.259-.086 1.996-.74 1.996-1.69 0-.865-.563-1.31-1.57-1.54l-.426-.1V8.374c.54.06.884.347.966.745h.948c-.07-.804-.779-1.433-1.914-1.502V7h-.54v.629c-1.076.103-1.808.732-1.808 1.622 0 .787.544 1.288 1.45 1.493l.358.085v1.78c-.554-.08-.92-.376-1.003-.787zm1.96-1.895c-.532-.12-.82-.364-.82-.732 0-.41.311-.719.824-.809v1.54h-.005zm.622 1.044c.645.145.943.38.943.796 0 .474-.37.8-1.02.86v-1.674z"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total MT5 Balance
                        <h4 class="counter" id="total-mt5"></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card" style="border-top: 2px solid #F1671B; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-warning text-white rounded p-2">
                        <!-- icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-bank2" viewBox="0 0 16 16">
                          <path d="M8.277.084a.5.5 0 0 0-.554 0l-7.5 5A.5.5 0 0 0 .5 6h1.875v7H1.5a.5.5 0 0 0 0 1h13a.5.5 0 1 0 0-1h-.875V6H15.5a.5.5 0 0 0 .277-.916zM12.375 6v7h-1.25V6zm-2.5 0v7h-1.25V6zm-2.5 0v7h-1.25V6zm-2.5 0v7h-1.25V6zM8 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2M.5 15a.5.5 0 0 0 0 1h15a.5.5 0 1 0 0-1z"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total Deposit
                        <h4 class="counter" id="total-deposit"></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card" style="border-top: 2px solid #1AA049; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-success text-white rounded p-2">
                        <!-- icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-credit-card-2-back-fill" viewBox="0 0 16 16">
                          <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5H0zm11.5 1a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h2a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5zM0 11v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-1z"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total Withdraw
                        <h4 class="counter" id="total-withdraw"></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card" style="border-top: 2px solid #C03221; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-danger text-white rounded p-2">
                        <!-- icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-bar-chart-fill" viewBox="0 0 16 16">
                          <path d="M1 11a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1zm5-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1zm5-5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1z"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total Volume Traded
                        <h4 class="counter" id="total-volume"></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card" style="border-top: 2px solid #079aa2; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-info text-white rounded p-2">
                        <!-- icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-cash-stack" viewBox="0 0 16 16">
                          <path d="M1 3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1zm7 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4"/>
                          <path d="M0 5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V7a2 2 0 0 1-2-2z"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total Rebates
                        <h4 class="counter" id="total-rebates"></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-3">
                <div class="card" style="border-top: 2px solid #F1671B; border-radius: 8px;">
                  <div class="card-body" style="padding: 0.5rem;">
                    <div class="d-flex justify-content-between align-items-center">
                      <div class="bg-warning text-white rounded p-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" fill="currentColor" class="bi bi-person-fill" viewBox="0 0 16 16">
                          <path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
                        </svg>
                      </div>
                      <div class="text-end">
                        Total Clients
                        <h4 class="counter"><?php echo $query->rowCount();?></h4>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div> <!-- /row KPI -->
          </div> <!-- /col -->

          </br>

          <div class="col-sm-12">
            <div class="card">
              <div class="card-header d-flex justify-content-between">
                <div class="header-title d-flex flex-column align-items-center w-100">
                  <h4 class="card-title m-0 text-center"><b>Client List</b></h4>
                  <div class="d-flex flex-wrap gap-2 justify-content-center" style="margin-top:5px">
                    <?php for ($i = 1; $i <= 7; $i++): ?>
                      <a href="?level=<?= $i ?>" style="background-color:#f16a1b;color:white" class="btn <?= (isset($_GET['level']) && $_GET['level'] == $i) ? 'active' : '' ?>">
                        Tier <?= $i ?>
                      </a>
                    <?php endfor; ?>
                  </div>
                </div>
              </div>

              <div class="card-body p-0">
                <div class="table-responsive mt-4">
                  <table id="client-table" class="table table-striped mb-0" role="grid">
                    <thead>
                      <tr>
                        <th>Trading Account</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Balance</th>
                        <th>Acc type</th>
                        <th>Deposit</th>
                        <th>Withdraw</th>
                        <th>Vol Trade</th>
                        <th>Rebate</th>
                        <th>Reg Date</th>
                        <th>Status</th>
                        <th>Load Trade</th>
                      </tr>
                    </thead>
                    <tbody>
<?php
if ($query->rowCount() > 0) {
  foreach ($results as $result) {
    $eidib2 = $result->email;

    $sqlib2 = "SELECT trade_id, account_type FROM liveaccount WHERE email=:eidib2";
    $queryib2 = $dbh->prepare($sqlib2);
    $queryib2->bindParam(':eidib2', $eidib2, PDO::PARAM_STR);
    $queryib2->execute();
    $resultib2 = $queryib2->fetch(PDO::FETCH_OBJ);

    $trade_id = $resultib2 ? htmlentities($resultib2->trade_id) : 'N/A';

    // user name & status
    $emailUser = htmlentities($result->email);
    $sqlUser = "SELECT * FROM aspnetusers WHERE email = :eid";
    $qUser = $dbh->prepare($sqlUser);
    $qUser->bindParam(':eid', $emailUser, PDO::PARAM_STR);
    $qUser->execute();
    $userRow = $qUser->fetch(PDO::FETCH_OBJ);
    $fullname = $userRow ? $userRow->fullname : '';
    $regdate  = $userRow ? $userRow->reg_date : '';
    $status   = $userRow ? $userRow->status : '0';

    // current account MT5 balance
    $login = $result->trade_id;
    if (($error_code = $api->UserAccountGet($login, $account)) != MTRetCode::MT_RET_OK) {
      $balance = 0;
    } else {
      $balance = $account->Balance;
    }

    // account type
    $acctype = $result->account_type ?? '';
    $account_type = trim((string)$acctype);
    switch ($account_type) {
      case 'sunshine\\grp1': $accname='Zero Commission'; break;
      case 'sunshine\\grp2': $accname='AI SmartBot'; break;
      case 'sunshine\\grp3': $accname='Premium'; break;
      case 'sunshine\\grp4': $accname='Classic'; break;
      case 'sunshine\\grp5': $accname='Infinity Zero'; break;
      case 'sunshine\\grp6': $accname='Zero Spread'; break;
      case 'sunshine\\grp7': $accname='Standard'; break;
      case 'sunshine\\grp8': $accname='PRO'; break;
      case 'sunshine\\grp9': $accname='PRO ECN'; break;
      default: $accname = ($account_type !== '' ? $account_type : 'N/A');
    }

    // deposit / withdraw totals
    $one = 1;
    $trade = htmlentities($result->trade_id);

    $sqlDep = "SELECT SUM(deposit_amount) AS total_trading_deposited FROM wallet_deposit WHERE trade_id = :tradeid AND Status = :one";
    $qDep = $dbh->prepare($sqlDep);
    $qDep->bindParam(':tradeid', $trade, PDO::PARAM_STR);
    $qDep->bindParam(':one', $one, PDO::PARAM_STR);
    $qDep->execute();
    $rowDep = $qDep->fetch(PDO::FETCH_OBJ);
    $totalDep = $rowDep && $rowDep->total_trading_deposited !== null ? $rowDep->total_trading_deposited : 0;

    $sqlW = "SELECT SUM(withdraw_amount) AS total_withdrawn FROM wallet_withdraw WHERE trade_id = :tradeid AND Status = :one";
    $qW = $dbh->prepare($sqlW);
    $qW->bindParam(':tradeid', $trade, PDO::PARAM_STR);
    $qW->bindParam(':one', $one, PDO::PARAM_STR);
    $qW->execute();
    $rowW = $qW->fetch(PDO::FETCH_OBJ);
    $totalW = $rowW && $rowW->total_withdrawn !== null ? $rowW->total_withdrawn : 0;

    $volumedata = (float)$result->volume;

    // commission calc (GATED by Tier-1 only)
    $rebate = 0.0;
    if ($tierEligible) {
      // pick level-specific commission column
      $commissionCol = null;
      if     ($levelFilter == 1) $commissionCol = 'ib_commission1';
      elseif ($levelFilter == 2) $commissionCol = 'ib_commission2';
      elseif ($levelFilter == 3) $commissionCol = 'ib_commission3';
      elseif ($levelFilter == 4) $commissionCol = 'ib_commission4';
      elseif ($levelFilter == 5) $commissionCol = 'ib_commission5';
      elseif ($levelFilter == 6) $commissionCol = 'ib_commission6';
      elseif ($levelFilter == 7) $commissionCol = 'ib_commission7';
      elseif ($levelFilter == 8) $commissionCol = 'ib_commission8';
      elseif ($levelFilter == 9) $commissionCol = 'ib_commission9';
      elseif ($levelFilter == 10) $commissionCol = 'ib_commission10';

      if ($commissionCol) {
        $sqlCommission = "SELECT $commissionCol AS rate FROM account_types WHERE ac_group = :ac_group";
        $qC = $dbh->prepare($sqlCommission);
        $qC->bindParam(':ac_group', $acctype, PDO::PARAM_STR);
        $qC->execute();
        $rC = $qC->fetch(PDO::FETCH_OBJ);
        $rate = (float)($rC->rate ?? 0);
        $rebate = $rate * $volumedata;
      }
    }
?>
                      <tr>
                        <td><?php echo $result->trade_id; ?></td>
                        <td><?php echo htmlspecialchars($fullname, ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?php echo htmlentities($result->email); ?></td>
                        <td><?php echo $balance; ?></td>
                        <td><?php echo htmlspecialchars($accname, ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?php echo $totalDep; ?></td>
                        <td><?php echo $totalW; ?></td>
                        <td><?php echo $volumedata; ?></td>
                        <td><?php echo $rebate; ?></td>
                        <td><?php echo $regdate; ?></td>
                        <td>
                          <?php
                            if ($status == '1')      echo '<span style="color: green">Active</span>';
                            elseif ($status == '0')  echo '<span style="color: red">Inactive</span>';
                          ?>
                        </td>
                        <td><a href="view_trade.php?tradeid=<?php echo $result->trade_id; ?>" target="about_blank">View</a></td>
                      </tr>
<?php
  }
} else {
  echo "<tr><td colspan='12'>No clients found for Level " . htmlentities($levelFilter) . ".</td></tr>";
}
?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

        </div> <!-- /row -->
      </div> <!-- /content-inner -->

      <script>
        function sumAmounts() {
          let totalAmount = 0;
          const rows = document.querySelectorAll("#client-table tr");
          for (let i = 1; i < rows.length; i++) {
            const amount = rows[i].cells[5]?.innerText || "0";
            totalAmount += parseFloat(amount) || 0;
          }
          document.getElementById("total-deposit").innerText = totalAmount.toFixed(2);
        }

        function sumAmountswithdraw() {
          let totalAmountwithdraw = 0;
          const rows = document.querySelectorAll("#client-table tr");
          for (let i = 1; i < rows.length; i++) {
            const amountwithdraw = rows[i].cells[6]?.innerText || "0";
            totalAmountwithdraw += parseFloat(amountwithdraw) || 0;
          }
          document.getElementById("total-withdraw").innerText = totalAmountwithdraw.toFixed(2);
        }

        function sumAmountsMt5() {
          let totalAmountmt5 = 0;
          const rows = document.querySelectorAll("#client-table tr");
          for (let i = 1; i < rows.length; i++) {
            const amountmt5 = rows[i].cells[3]?.innerText || "0";
            totalAmountmt5 += parseFloat(amountmt5) || 0;
          }
          document.getElementById("total-mt5").innerText = totalAmountmt5.toFixed(2);
        }

        function sumVolume() {
          let totalAmountvolume = 0;
          const rows = document.querySelectorAll("#client-table tr");
          for (let i = 1; i < rows.length; i++) {
            const amountvolume = rows[i].cells[7]?.innerText || "0";
            totalAmountvolume += parseFloat(amountvolume) || 0;
          }
          document.getElementById("total-volume").innerText = totalAmountvolume.toFixed(2);
        }

        function sumRebates() {
          let totalrebates = 0;
          const rows = document.querySelectorAll("#client-table tr");
          for (let i = 1; i < rows.length; i++) {
            const amountrebates = rows[i].cells[8]?.innerText || "0";
            totalrebates += parseFloat(amountrebates) || 0;
          }
          document.getElementById("total-rebates").innerText = totalrebates.toFixed(2);
        }

        // Run totals
        sumAmounts();
        sumAmountswithdraw();
        sumAmountsMt5();
        sumVolume();
        sumRebates();
      </script>

      <!-- Real-Time Search (kept) -->
      <script>
        document.getElementById('search-input')?.addEventListener('keyup', function() {
          var input = this.value.toLowerCase();
          var rows = document.querySelectorAll('#client-table tbody tr');
          rows.forEach(function(row) {
            var rowText = row.textContent.toLowerCase();
            row.style.display = rowText.includes(input) ? '' : 'none';
          });
        });
      </script>

      <script>
        function redirectWithTradeIds() {
          const tradeIds = "<?php echo $trade_ids_string; ?>";
          window.open(`testtrade.php?trade_ids=${tradeIds}`, '_blank');
        }
      </script>

      <!-- Footer Section Start -->
      <?php include 'footer.php';?>
      <!-- Footer Section End -->
    </main>

    <!-- JS bundles -->
    <script src="assets/js/core/libs.min.js"></script>
    <script src="assets/js/core/external.min.js"></script>
    <script src="assets/js/charts/widgetcharts.js"></script>
    <script src="assets/js/charts/vectore-chart.js"></script>
    <script src="assets/js/charts/dashboard.js" ></script>
    <script src="assets/js/plugins/fslightbox.js"></script>
    <script src="assets/js/plugins/setting.js"></script>
    <script src="assets/js/plugins/slider-tabs.js"></script>
    <script src="assets/js/plugins/form-wizard.js"></script>
    <script src="assets/js/hope-ui.js" defer></script>
  </body>
</html>
