<?php
session_start();
error_reporting(E_ALL);
include('config.php');

if (empty($_SESSION['clogin'])) {
    header('location:login.php');
    exit();
}

$eid = $_SESSION['clogin'];

/* -----------------------------------------------------------
   MT5 API bootstrap (needed to fetch balances)
----------------------------------------------------------- */
include 'manager_initialize.php'; // defines $api, MTRetCode, etc.

/* -----------------------------------------------------------
   1) Compute Tier-1 total MT5 balance (ib1 = current IB)
----------------------------------------------------------- */
$sqlTier1 = "SELECT trade_id FROM liveaccount WHERE ib1 = :eid";
$qTier1 = $dbh->prepare($sqlTier1);
$qTier1->bindParam(':eid', $eid, PDO::PARAM_STR);
$qTier1->execute();
$tier1Rows = $qTier1->fetchAll(PDO::FETCH_OBJ);

$tier1SumBalance = 0.0;
if ($tier1Rows) {
    foreach ($tier1Rows as $row) {
        $login = $row->trade_id;
        if (($error_code = $api->UserAccountGet($login, $account)) == MTRetCode::MT_RET_OK) {
            $tier1SumBalance += (float)$account->Balance;
        }
    }
}

/* Helper: level threshold (L×500), L=1 always eligible */
function level_threshold(int $level): float {
    if ($level <= 1) return 0.0;  // L1 always eligible
    return $level * 500.0;        // L=2→1000, L=3→1500, L=4→2000, ...
}

/* -----------------------------------------------------------
   2) Totals with Tier-1 gate
----------------------------------------------------------- */
$totalCommissionmain = 0;  // rebates across all levels
$totalVolume = 0;          // volume across all levels

for ($level = 1; $level <= 10; $level++) {
    // Get accounts for THIS level linked to this IB
    $sql = "SELECT *, 
                CASE
                    WHEN ib1 = :eid THEN 1
                    WHEN ib2 = :eid THEN 2
                    WHEN ib3 = :eid THEN 3
                    WHEN ib4 = :eid THEN 4
                    WHEN ib5 = :eid THEN 5
                    WHEN ib6 = :eid THEN 6
                    WHEN ib7 = :eid THEN 7
                    WHEN ib8 = :eid THEN 8
                    WHEN ib9 = :eid THEN 9
                    WHEN ib10 = :eid THEN 10
                    ELSE NULL
                END AS level 
            FROM liveaccount
            WHERE (ib1 = :eid OR ib2 = :eid OR ib3 = :eid OR ib4 = :eid OR ib5 = :eid OR 
                   ib6 = :eid OR ib7 = :eid OR ib8 = :eid OR ib9 = :eid OR ib10 = :eid)
            HAVING level = :levelFilter";

    $query = $dbh->prepare($sql);
    $query->bindParam(':eid', $eid, PDO::PARAM_STR);
    $query->bindParam(':levelFilter', $level, PDO::PARAM_INT);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);

    // Decide eligibility for THIS level using Tier-1 gate
    $required = level_threshold($level);
    $eligible = ($level === 1) ? true : ($tier1SumBalance >= $required);

    if ($query->rowCount() > 0) {
        foreach ($results as $result) {
            $accountgroup = $result->account_type;
            $volume = (float)$result->volume;
            $totalVolume += $volume; // volume totals (independent of gate)

            // Commission only if eligible for this level
            if ($eligible) {
                $commissionColumn = "ib_commission" . $level;
                $sqlCommission = "SELECT $commissionColumn AS commission 
                                  FROM account_types 
                                  WHERE ac_group = :accountgroup";
                $queryCommission = $dbh->prepare($sqlCommission);
                $queryCommission->bindParam(':accountgroup', $accountgroup, PDO::PARAM_STR);
                $queryCommission->execute();
                $resultCommission = $queryCommission->fetch(PDO::FETCH_OBJ);
                $ibCommission = (float)($resultCommission->commission ?? 0);

                $rebate = $ibCommission * $volume;
                $totalCommissionmain += $rebate;
            }
            // If NOT eligible, rebate for this level is treated as 0
        }
    }
}

/* -----------------------------------------------------------
   3) Other existing aggregations (unchanged)
----------------------------------------------------------- */

// Get user account details
$email = $_SESSION['clogin'];
$sqlmyac = "SELECT * FROM aspnetusers WHERE email = :email LIMIT 1";
$querymyac = $dbh->prepare($sqlmyac);
$querymyac->bindParam(':email', $email, PDO::PARAM_STR);
$querymyac->execute();
$resultmyac = $querymyac->fetch(PDO::FETCH_OBJ);

// Calculate total withdrawals (paid + pending)
$sqlre = "SELECT SUM(trading_withdrawal) AS total_withdraw_trading_withdrawaled 
          FROM total_balance 
          WHERE email = :eid";
$queryre = $dbh->prepare($sqlre);
$queryre->bindParam(':eid', $eid, PDO::PARAM_STR);
$queryre->execute();
$resultre = $queryre->fetch(PDO::FETCH_OBJ);
$totalrevalue = (float)($resultre->total_withdraw_trading_withdrawaled ?? 0);

$sqlre = "SELECT SUM(withdraw_amount) AS total_withdrawal 
          FROM ib_withdraw 
          WHERE email = :eid AND status = 0";
$queryre = $dbh->prepare($sqlre);
$queryre->bindParam(':eid', $eid, PDO::PARAM_STR);
$queryre->execute();
$resultree = $queryre->fetch(PDO::FETCH_OBJ);
$totalrevalues = (float)($resultree->total_withdrawal ?? 0);

$totalrevaluess = $totalrevalue + $totalrevalues;
$avlresult = round($totalCommissionmain - $totalrevaluess, 2);
if (abs($avlresult) < 0.00001) $avlresult = 0;

// Calculate total clients
$sql_client = "SELECT COUNT(id) AS total_client FROM aspnetusers  
               WHERE ib1 = :email OR ib2 = :email OR ib3 = :email OR ib4 = :email 
               OR ib5 = :email OR ib6 = :email OR ib7 = :email OR ib8 = :email 
               OR ib9 = :email OR ib10 = :email";
$query_client = $dbh->prepare($sql_client);
$query_client->bindParam(':email', $eid, PDO::PARAM_STR);
$query_client->execute();
$client_result = $query_client->fetch(PDO::FETCH_ASSOC);
$total_client = (int)($client_result['total_client'] ?? 0);

// Calculate total volume (DB-side)
$sql2 = "SELECT SUM(volume) AS total_volume FROM liveaccount 
         WHERE ib1 = :email OR ib2 = :email OR ib3 = :email OR ib4 = :email 
         OR ib5 = :email OR ib6 = :email OR ib7 = :email OR ib8 = :email 
         OR ib9 = :email OR ib10 = :email";
$query2 = $dbh->prepare($sql2);
$query2->bindParam(':email', $eid, PDO::PARAM_STR);
$query2->execute();
$result2 = $query2->fetch(PDO::FETCH_OBJ);
$total_volume = (float)($result2->total_volume ?? 0);

// Calculate total deposits
$sql1 = "SELECT SUM(deposit_amount) AS total_trading_deposited FROM total_balance WHERE email = :eid";
$query1 = $dbh->prepare($sql1);
$query1->bindParam(':eid', $eid, PDO::PARAM_STR);
$query1->execute();
$result1 = $query1->fetch(PDO::FETCH_OBJ);
$total_deposits = (float)($result1->total_trading_deposited ?? 0);

// Calculate total withdrawals (trading side)
$sql2 = "SELECT SUM(withdraw_amount) AS total_trading_deposited FROM total_balance WHERE email = :eid";
$query2 = $dbh->prepare($sql2);
$query2->bindParam(':eid', $eid, PDO::PARAM_STR);
$query2->execute();
$result2 = $query2->fetch(PDO::FETCH_OBJ);
$total_withdrawals = (float)($result2->total_trading_deposited ?? 0);

// Get IB link
$sql = "SELECT email FROM ib1 WHERE email = :eid LIMIT 1";
$query = $dbh->prepare($sql);
$query->bindParam(':eid', $eid, PDO::PARAM_STR);
$query->execute();
$encodedEmail = ($query->rowCount() > 0) ? $eid : "";
?>
<!doctype html>
<html lang="en" dir="ltr">
<head>
    <?php include 'title.php'; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <!-- Google Font (subtle, professional) -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Icons (optional if not already in your bundle) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>

    <style>
      :root{
        --orange-600:#F1671B;      /* Primary brand orange */
        --orange-500:#ff7a00;
        --orange-50:#FFF5ED;       /* Light bg */
        --ink-900:#0f172a;
        --ink-700:#334155;
        --ink-500:#64748b;
        --border:#e5e7eb;
        --bg:#ffffff;
        --card:#ffffff;
        --muted:#f8fafc;
        --ring: rgba(241,103,27,.25);
        --shadow:0 10px 25px rgba(15,23,42,.06), 0 2px 8px rgba(15,23,42,.05);
      }

      html,body{
        font-family:'Inter', system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
        background: var(--orange-50);
        color: var(--ink-900);
      }

      /* Loader (kept) */
      #loading .loader.simple-loader .loader-body{
        border-color: var(--orange-600) !important;
      }

      /* NAVBAR */
      .brand-navbar{
        background: var(--bg);
        border-bottom: 1px solid var(--border);
        position: sticky;
        top:0; z-index: 40;
      }
      .brand-navbar .nav-link{
        font-weight: 600;
        color: var(--ink-700);
        border-radius: 10px;
        padding: .6rem .9rem !important;
      }
      .brand-navbar .nav-link.active,
      .brand-navbar .nav-link:hover{
        color: var(--orange-600);
        background: #ffffff;
        box-shadow: inset 0 0 0 2px var(--orange-50);
      }
      .brand-badge{
        background: var(--orange-600);
        color:#fff;
        padding:.45rem .75rem;
        border-radius: 10px;
        font-weight:700;
        letter-spacing:.3px;
      }

      /* LAYOUT */
      .content-inner{
        padding: 1.25rem 1rem 2rem;
      }

      /* CARDS */
      .card{
        border:1px solid var(--border);
        border-radius:14px !important;
        background: var(--card);
        box-shadow: var(--shadow);
      }
      .card-header{
        border-bottom:1px solid var(--border) !important;
        background: #fff;
        border-top-left-radius:14px !important;
        border-top-right-radius:14px !important;
      }
      .card-title{
        font-weight:700;
        color: var(--ink-900);
      }

      /* KPI tiles */
      .kpi{
        position: relative;
        overflow: hidden;
        border-top: 4px solid transparent !important;
      }
      .kpi.orange{ border-top-color: var(--orange-600) !important; }
      .kpi.green{ border-top-color: #16a34a !important; }
      .kpi.blue{ border-top-color: #0ea5e9 !important; }
      .kpi.red{ border-top-color: #ef4444 !important; }

      .kpi .icon{
        display:flex; align-items:center; justify-content:center;
        width: 40px; height: 40px; border-radius:10px;
        background: var(--orange-600);
      }
      .kpi h4{
        margin: .25rem 0 0 0;
        font-weight: 800;
        letter-spacing:.2px;
      }
      .kpi .label{
        font-size:.86rem; color:var(--ink-500); font-weight:600;
      }

      /* PARTNER LINK / REFERRAL */
      .link-ref-container{
        display:flex; align-items:center; gap:20px; flex-wrap:wrap;
      }
      .link-section,.ref-section{ flex:1; min-width:280px; }
      .separator{ width:1px; height:46px; background:var(--border); }
      .aff-link,.referral-code{
        display:inline-flex; align-items:center; justify-content:center;
        border:1px dashed var(--orange-600);
        padding:10px 14px; border-radius:10px; background:#fff;
      }
      .aff-link a{ color:var(--orange-600); font-weight:600; text-decoration:none; word-break:break-all;}
      .referral-code{ font-weight:800; color:var(--ink-900); min-width:120px; }

      .copy-btn{
        background: var(--orange-600); color:#fff; border:none;
        padding:.55rem .85rem; border-radius:10px; font-weight:700;
        transition:.15s transform ease;
      }
      .copy-btn:hover{ transform: translateY(-1px); }

      /* CTA Buttons */
      .btn-primary{
        background: var(--orange-600) !important; border-color: var(--orange-600) !important;
        font-weight:700; letter-spacing:.2px; border-radius:10px;
      }
      .btn-primary:focus{ box-shadow: 0 0 0 4px var(--ring) !important; }

      /* Credit card widget header */
      .primary-gradient-card{
        background: linear-gradient(90deg, var(--orange-600), #ff9952);
      }
      .credit-card-widget .card-number span{
        font-weight:800; color:#fff;
      }
      .credit-card-widget h5, .credit-card-widget p{ color:#fff; }

      /* Tiny helper text */
      .muted{
        color: var(--ink-500);
        font-size:.9rem;
      }

      /* Charts responsive */
      #d-activity{ max-height: 320px; }

      /* Toast */
      .toastify{
        position: fixed; right: 20px; bottom: 20px;
        background: var(--orange-600); color:#fff; padding:12px 16px;
        border-radius:10px; box-shadow: var(--shadow); z-index: 1000;
        opacity:0; transform: translateY(6px); transition:.2s ease;
      }
      .toastify.show{ opacity:1; transform: translateY(0); }

      /* Utilities */
      .divider{
        height:1px; background: var(--border); margin: .75rem 0;
      }

      /* Counter typography align */
      .counter{ font-weight:800; font-size: 1.4rem; margin: .1rem 0 0; }

      /* Mobile tweaks */
      @media (max-width: 576px){
        .separator{ display:none; }
        .copy-btn, .aff-link, .referral-code{ width:100%; }
        .content-inner{ padding: .75rem .75rem 1.5rem; }
      }
    </style>
</head>
<body>
    <span class="screen-darken"></span>

    <!-- loader Start -->
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body"></div>
        </div>
    </div>
    <!-- loader END -->

    <main class="main-content">
        <!--Top Header (kept)-->
        <?php include 'header.php'; ?>

        <!-- Branded Navbar -->
        <nav class="navbar navbar-expand-lg brand-navbar">
          <div class="container-fluid">
            <!--<span class="brand-badge">Demo IB</span>-->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                    aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation"
                    style="border-color: var(--orange-600);">
              <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
              <ul class="navbar-nav ms-auto gap-2">
                <li class="nav-item">
                  <a class="nav-link active" href="dashboard"><i class="fa fa-home me-1"></i>Dashboard</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="clients?level=1"><i class="fa fa-users me-1"></i>Clients</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="trades"><i class="fa fa-bar-chart me-1"></i>Trade List</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="withdraw"><i class="fa fa-institution me-1"></i>Payout</a>
                </li>
              </ul>
            </div>
          </div>
        </nav>

        <div class="conatiner-fluid content-inner pb-0">
            <div class="row g-3">

                <!-- KPIs -->
                <div class="col-12">
                  <div class="row g-3">
                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi blue">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa fa-user-group"></i></div>
                            <div class="text-end">
                              <div class="label">No Of Clients</div>
                              <h4 class="counter"><?php echo number_format($total_client, 2); ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi orange">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-solid fa-sack-dollar"></i></div>
                            <div class="text-end">
                              <div class="label">Rebates Paid</div>
                              <h4 class="counter"><?php echo $totalrevaluess; ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi green">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-solid fa-wallet"></i></div>
                            <div class="text-end">
                              <div class="label">Rebates Unpaid</div>
                              <h4 class="counter"><?php echo $avlresult; ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi red">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-solid fa-chart-column"></i></div>
                            <div class="text-end">
                              <div class="label">Traded Volume</div>
                              <h4 class="counter"><?php echo number_format($total_volume, 2); ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi blue">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-solid fa-building-columns"></i></div>
                            <div class="text-end">
                              <div class="label">Deposits</div>
                              <h4 class="counter"><?php echo $total_deposits; ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi orange">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-regular fa-credit-card"></i></div>
                            <div class="text-end">
                              <div class="label">Withdrawals</div>
                              <h4 class="counter"><?php echo $total_withdrawals; ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-lg-3 col-md-6">
                      <div class="card kpi green">
                        <div class="card-body py-3 px-3">
                          <div class="d-flex justify-content-between align-items-center">
                            <div class="icon"><i class="fa-solid fa-box"></i></div>
                            <div class="text-end">
                              <div class="label">Total Rebates</div>
                              <h4 class="counter"><?php echo $totalCommissionmain; ?></h4>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>

              <!-- ===================== REVAMPED SECTION (looks totally different) ===================== -->
<style>
  /* Scoped to avoid clashes */
  .revamp-2025 *{box-sizing:border-box}
  .revamp-2025 .tile{border:1px solid #f1f1f1;border-radius:18px;background:#fff;box-shadow:0 12px 28px rgba(17,24,39,.06)}
  .revamp-2025 .tile-h{padding:14px 16px;border-bottom:1px dashed #ffe1cc;display:flex;align-items:center;gap:10px}
  .revamp-2025 .tile-h .dot{width:10px;height:10px;border-radius:999px;background:#F1671B}
  .revamp-2025 .tile-b{padding:16px}

  /* Partner card */
  .revamp-2025 .aff-pill{display:flex;align-items:center;gap:10px;border:1px dashed #F1671B;background:#FFF5ED;padding:10px 12px;border-radius:999px;font-weight:800}
  .revamp-2025 .aff-pill a{color:#b14c00;word-break:break-all;text-decoration:none}
  .revamp-2025 .ghost{color:#64748b}
  .revamp-2025 .copbtn{border:0;background:#F1671B;color:#fff;border-radius:10px;padding:8px 12px;font-weight:800}
  .revamp-2025 .code-badge{display:inline-flex;align-items:center;gap:8px;padding:8px 12px;background:#111827;color:#fff;border-radius:10px;font-weight:900;letter-spacing:.08em}

  /* Performance tiles */
  .revamp-2025 .kline{display:grid;grid-template-columns:1fr 1fr;gap:14px}
  .revamp-2025 .chip{display:flex;align-items:center;gap:8px;background:#fff7f1;border:1px dashed #F1671B;color:#b45309;padding:10px 12px;border-radius:12px;font-weight:800}
  .revamp-2025 .stat-num{font-size:22px;font-weight:900}

  /* Donut chart wrap */
  .revamp-2025 .donut-wrap{display:flex;align-items:center;gap:18px}
  .revamp-2025 .legend{display:grid;gap:8px}
  .revamp-2025 .lg{display:flex;align-items:center;gap:8px;font-weight:700;color:#475569}
  .revamp-2025 .lg .dot{width:12px;height:12px;border-radius:999px}

  /* Wallet new look */
  .revamp-2025 .wallet{overflow:hidden}
  .revamp-2025 .wallet .stripe{height:8px;background:linear-gradient(90deg,#F1671B,#ffb07e)}
  .revamp-2025 .wallet .wb{padding:16px}
  .revamp-2025 .wallet .idrow{display:flex;justify-content:space-between;align-items:center}
  .revamp-2025 .wallet .badge{background:#FFF5ED;color:#b14c00;border:1px dashed #F1671B;padding:6px 10px;border-radius:10px;font-weight:800}
  .revamp-2025 .wallet .avatar{width:48px;height:48px;border-radius:14px;display:grid;place-items:center;background:#111827;color:#fff;font-weight:900}
  .revamp-2025 .wallet .bal{font-size:30px;font-weight:900;letter-spacing:.3px}
  .revamp-2025 .wallet .mini{display:grid;grid-template-columns:1fr 1fr;gap:12px}
  .revamp-2025 .wallet .mini .box{border:1px dashed #e5e7eb;border-radius:12px;padding:10px 12px;font-weight:800;background:#fff}
  .revamp-2025 .wallet .cta{margin-top:10px}
  .revamp-2025 .wallet .cta .btn{width:100%;border:0;background:#F1671B;color:#fff;border-radius:12px;padding:12px 14px;font-weight:900}

  /* Circular progress using conic-gradient */
  .revamp-2025 .ring{--p:0; width:100px;height:100px;border-radius:50%;
    background: conic-gradient(#F1671B calc(var(--p)*1%), #f1f5f9 0);
    display:grid;place-items:center;margin-right:12px}
  .revamp-2025 .ring span{background:#fff;border:1px solid #f1f1f1;border-radius:50%;width:76px;height:76px;display:grid;place-items:center;font-weight:900}
</style>

<div class="revamp-2025 row">
  <!-- ================= LEFT ================= -->
  <div class="col-md-12 col-lg-8">
    <div class="row g-3">

      <!-- Partner: compact, pill-first layout -->
      <div class="col-12">
        <div class="tile">
          <div class="tile-h"><div class="dot"></div><strong>Partner & Referral</strong></div>
          <div class="tile-b">
            <?php
              $eid = $_SESSION['clogin'] ?? '';
              $sql = "SELECT * FROM ib1 WHERE email = :eid LIMIT 1";
              $query = $dbh->prepare($sql);
              $query->bindParam(':eid', $eid, PDO::PARAM_STR);
              $query->execute();
              $result = $query->fetch(PDO::FETCH_OBJ);

              if ($result) {
                function encryptEmailToCode($email) {
                  $hash = crc32($email);
                  return abs($hash % 90000 + 10000);
                }
                $encodedEmail = $result->email;
                $referralCode = encryptEmailToCode($encodedEmail);
                $partnerUrl = "https://test.traderssolution.com/crmvideonew/ibportal/ib_ref.php?id=" . htmlspecialchars($encodedEmail, ENT_QUOTES);
            ?>
              <div class="aff-pill mb-3">
                <i class="fa fa-link"></i>
                <a href="<?= $partnerUrl ?>" target="_blank" rel="noopener"><?= $partnerUrl ?></a>
                <button class="copbtn" type="button" onclick="copyAffLink('<?= $partnerUrl ?>')">
                  <i class="fa fa-copy me-1"></i> Copy
                </button>
              </div>

              <div class="d-flex align-items-center gap-3 flex-wrap">
                <div class="code-badge">
                  <i class="fa fa-hashtag"></i> <span id="referral-code"><?= htmlspecialchars($referralCode) ?></span>
                </div>
                <button class="copbtn" type="button" onclick="copyRefCode()">
                  <i class="fa fa-copy me-1"></i> Copy Code
                </button>
                <span class="ghost"><i class="fa fa-info-circle me-1"></i>Share link or code to track referrals</span>
              </div>
            <?php } else { ?>
              <div class="ghost text-center">No partner data found.</div>
            <?php } ?>
          </div>
        </div>
      </div>

    <!-- ===== Compact Performance (drop-in replacement) ===== -->
<style>
  /* scoped + minimal */
  .revamp-2025 .perf-mini .mini-stat{margin-bottom:10px}
  .revamp-2025 .perf-mini .rowline{display:flex;align-items:center;justify-content:space-between}
  .revamp-2025 .perf-mini .label{color:#64748b;font-weight:700;display:flex;align-items:center;gap:6px}
  .revamp-2025 .perf-mini .value{font-weight:900}
  .revamp-2025 .perf-mini .bar{height:8px;background:#f1f5f9;border-radius:999px;overflow:hidden;margin-top:6px}
  .revamp-2025 .perf-mini .bar span{display:block;height:100%;background:linear-gradient(90deg,#F1671B,#ffb07e)}
</style>

<div class="col-12">
  <div class="tile perf-mini">
    <div class="tile-h"><div class="dot"></div><strong>Performance</strong><span class="ghost ms-2">compact</span></div>
    <div class="tile-b">
      <?php
        $rebates = (float)($totalCommissionmain ?? 0);
        $volume  = (float)($total_volume ?? 0);
        $mx = max($rebates, $volume, 1);
        $rPct = min(100, round(($rebates/$mx)*100));
        $vPct = min(100, round(($volume/$mx)*100));
      ?>

      <div class="mini-stat">
        <div class="rowline">
          <div class="label"><i class="fa fa-sack-dollar"></i> Rebates</div>
          <div class="value">₹ <?= number_format($rebates, 2) ?></div>
        </div>
        <div class="bar" aria-label="Rebates relative bar" title="<?= $rPct ?>%">
          <span style="width: <?= $rPct ?>%"></span>
        </div>
      </div>

      <div class="mini-stat">
        <div class="rowline">
          <div class="label"><i class="fa fa-arrow-trend-up"></i> Volume</div>
          <div class="value"><?= number_format($volume, 2) ?></div>
        </div>
        <div class="bar" aria-label="Volume relative bar" title="<?= $vPct ?>%">
          <span style="width: <?= $vPct ?>%"></span>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- ===== /Compact Performance ===== -->


    </div>
  </div>

  <!-- ================= RIGHT ================= -->
  <div class="col-md-12 col-lg-4">
    <div class="tile wallet">
      <div class="stripe"></div>
      <div class="wb">
        <div class="idrow mb-2">
          <div>
            <strong>Account Wallet</strong>
            <div class="badge mt-1"><i class="fa fa-shield-alt me-1"></i> VERIFIED</div>
          </div>
          <div class="avatar">
            <?php
              $initials = '';
              if (!empty($resultmyac->fullname)) {
                $parts = preg_split('/\s+/', trim($resultmyac->fullname));
                $initials = strtoupper(substr($parts[0] ?? 'K', 0, 1) . substr($parts[1] ?? 'F', 0, 1));
              } else { $initials = 'KF'; }
              echo htmlspecialchars($initials, ENT_QUOTES, 'UTF-8');
            ?>
          </div>
        </div>

        <!-- Masked number band -->
        <div class="ghost mb-2" style="font-weight:800;letter-spacing:.2em">**** <?php echo $total_deposits; ?> ****</div>

        <!-- Balance -->
        <div class="d-flex align-items-center mb-3">
          <?php
            $currentTier1 = (float)($tier1SumBalance ?? 0);
            $nextThreshold = level_threshold(2); // same helper as your page
            $pct = 0;
            if ($nextThreshold > 0) $pct = min(100, round(($currentTier1 / $nextThreshold) * 100, 1));
          ?>
          <div class="ring me-3" style="--p: <?php echo $pct; ?>">
            <span><?php echo $pct; ?>%</span>
          </div>
          <div>
            <div class="ghost" style="font-weight:700">Balance</div>
            <div class="bal">₹ <?php echo $avlresult; ?></div>
            <div class="ghost">Tier-1: ₹ <?php echo number_format($currentTier1,2); ?> / Target: ₹ <?php echo number_format($nextThreshold,2); ?></div>
          </div>
        </div>

        <!-- Mini stats -->
        <div class="mini mb-2">
          <div class="box"><i class="fa fa-arrow-down me-1"></i> Deposits: ₹ <?php echo $total_deposits; ?></div>
          <div class="box"><i class="fa fa-credit-card me-1"></i> Withdrawals: ₹ <?php echo $total_withdrawals; ?></div>
        </div>

        <!-- CTA -->
        <div class="cta">
          <a class="btn text-decoration-none" href="withdraw">
            <i class="fa fa-indian-rupee-sign me-1"></i> Withdraw
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  // copy helpers re-used
  function copyAffLink(text){ navigator.clipboard?.writeText(text).then(()=>alert('Partner link copied')).catch(()=>fallbackCopy(text)); }
  function copyRefCode(){
    var t = document.getElementById('referral-code')?.innerText || '';
    navigator.clipboard?.writeText(t).then(()=>alert('Referral code copied')).catch(()=>fallbackCopy(t));
  }
  function fallbackCopy(t){
    const ta=document.createElement('textarea'); ta.value=t; document.body.appendChild(ta); ta.select();
    try{ document.execCommand('copy'); alert('Copied'); }catch(e){ alert('Copy failed'); }
    document.body.removeChild(ta);
  }

  // Donut chart: Rebates vs Volume (same data, new viz)
  (function ensureChartJs(cb){
    if (window.Chart) return cb();
    var s=document.createElement('script'); s.src='https://cdn.jsdelivr.net/npm/chart.js'; s.onload=cb; document.head.appendChild(s);
  })(function(){
    const ctx=document.getElementById('revamp-donut').getContext('2d');
    const rebates = Number('<?php echo (float)($totalCommissionmain ?? 0); ?>') || 0;
    const volume  = Number('<?php echo (float)($total_volume ?? 0); ?>') || 0;
    new Chart(ctx, {
      type:'doughnut',
      data:{
        labels:['Rebates','Volume'],
        datasets:[{
          data:[rebates, Math.max(volume - rebates, 0)],
          backgroundColor:['#F1671B','#ffb07e'],
          borderWidth:0,
          hoverOffset:4
        }]
      },
      options:{
        cutout:'68%',
        plugins:{legend:{display:false}, tooltip:{caretSize:6}},
      }
    });
  });
</script>
<!-- ===================== /REVAMPED SECTION ===================== -->


            </div>
        </div>

        <!-- Footer Section Start -->
        <?php include 'footer.php';?>
        <!-- Footer Section End -->
    </main>

    <!-- Toast (for copy feedback) -->
    <div id="toast" class="toastify"></div>

    <script>
      function toast(msg){
        const el = document.getElementById('toast');
        el.textContent = msg;
        el.classList.add('show');
        setTimeout(()=> el.classList.remove('show'), 2300);
      }
      function copyAffLink(url){
        navigator.clipboard.writeText(url).then(()=> toast('Partner link copied!'));
      }
      function copyRefCode(){
        const refCode = document.getElementById('referral-code')?.textContent?.trim() || '';
        if(!refCode){ toast('Referral code not found'); return; }
        navigator.clipboard.writeText(refCode).then(()=> toast('Referral code copied!'));
      }
    </script>

    <!-- Existing bundles -->
    <script src="assets/js/core/libs.min.js" defer></script>
    <script src="assets/js/core/external.min.js" defer></script>
    <script src="assets/js/charts/widgetcharts.js" defer></script>
    <script src="assets/js/charts/vectore-chart.js" defer></script>
    <script src="assets/js/charts/dashboard.js" defer></script>
    <script src="assets/js/plugins/fslightbox.js" defer></script>
    <script src="assets/js/plugins/setting.js" defer></script>
    <script src="assets/js/plugins/slider-tabs.js" defer></script>
    <script src="assets/js/plugins/form-wizard.js" defer></script>
    <script src="assets/js/hope-ui.js" defer></script>
</body>
</html>
