$(document).ready(function() {
    $.fn.serializeObject = function()
        {
            var o = {};
            var a = this.serializeArray();
            $.each(a, function() {
                if (o[this.name] !== undefined) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };
      // Initialize i18next
      var rn =Math.floor(Math.random()*1E16);
      $.i18n.init({
        resGetPath: "/static/lang/__lng__.json?v="+rn,
        debug: false,
        load: 'unspecific',
        fallbackLng: false
      }, function (t) {
        var lang = i18n.detectLanguage();
        $(".current-lang").attr("src","/static/assets/images/flags/"+lang+".svg");
        checkUrl(lang);
        $('body').i18n(); // translate nav
        //translate tooltips
        $('[data-toggle=tooltip]').tooltip({
          template: '<div class="tooltip"><div class="bg-teal"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div></div>'
        });
        $.each($('[data-toggle=tooltip]'), function () {
            //$(this).attr("title",i18n.t($(this).attr("data-tooli18n")));
            $(this).attr("data-original-title",i18n.t($(this).attr("data-tooli18n")));
        });

      });

        // Change language on button click
        $('.lang-selector a').on('click', function () {
            var lang = $(this).attr("data-lang");
            i18n.setLng(lang, function() {

                var url = window.location.href.split("/");
                if (url.length == 4){
                    url[3]=lang+"/";
                }else{
                    url[3]=lang
                }
                var reurl = url.join("/");
                window.location.href = reurl
            });
        });


	});

	function checkUrl(lang){
		var url_lang = window.location.href.split("/")[3]
		var split_langs = comm_langs.split('"')
		var two_letter_langs = [];

        for (var i = 1; i < split_langs.length; i = i + 2) {
          two_letter_langs.push(split_langs[i]);
        }

		if (url_lang != lang && url_lang != undefined && url_lang!="" && (two_letter_langs.includes(url_lang))){
			i18n.setLng(url_lang, function() {
				$('body').i18n();
			    $(".current-lang").attr("src","/static/assets/images/flags/"+url_lang+".svg");
			});
		}
	}