<?php
session_start();
include('config.php');

// Check if credentials are passed in the URL (GET method)
if (isset($_GET['email']) && isset($_GET['password'])) {
    // Get credentials from URL
    $uname = $_GET['email'];
    $password = $_GET['password'];
} elseif (isset($_POST['signin'])) {
    // Fallback to POST data if URL parameters are not available
    $uname = $_POST['username'];
    $password = $_POST['password'];
} else {
    $msg = "Please provide login credentials.";
}

// Check if the credentials are provided
if (isset($uname) && isset($password)) {
    // Check credentials in the database
    $sql = "SELECT email, password FROM aspnetusers WHERE email=:uname and password=:password and email_confirmed=1";
    $query = $conn->prepare($sql);
    $query->bindParam(':uname', $uname, PDO::PARAM_STR);
    $query->bindParam(':password', $password, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);

    if ($query->rowCount() > 0) {
        $_SESSION['clogin'] = $uname;  // Set session for the user
        echo "<script type='text/javascript'>document.location ='dashboard.php';</script>";

        // Fetch country and IP
        $json = @file_get_contents("http://ip-api.com/json/");
        if ($json === FALSE) {
            $country = 'Unknown';
            $ip = $_SERVER['REMOTE_ADDR']; // Fallback to server-side IP
        } else {
            $data = json_decode($json);
            $country = isset($data->country) ? $data->country : 'Unknown';
            $ip = isset($data->IPv4) ? $data->IPv4 : $_SERVER['REMOTE_ADDR'];
        }

        // Debugging: Check the country value
        echo "Country: " . $country . "<br>";

        // Date when the login was made
        $created_date_js = $_POST['reg_date_js'] ?? date('Y-m-d H:i:s'); // Default to current date-time if not provided

        $action = 'login';
        $status = 1;
        $email = $_SESSION['clogin'];

        // Insert into login history
        $sql = "INSERT INTO login_history(email, ip, country, action, created_date_js, status)
                VALUES(:email, :ip, :country, :action, :created_date_js, :status)";
        $query = $conn->prepare($sql);
        $query->bindParam(':email', $email, PDO::PARAM_STR);
        $query->bindParam(':ip', $ip, PDO::PARAM_STR);
        $query->bindParam(':country', $country, PDO::PARAM_STR);
        $query->bindParam(':action', $action, PDO::PARAM_STR);
        $query->bindParam(':created_date_js', $created_date_js, PDO::PARAM_STR);
        $query->bindParam(':status', $status, PDO::PARAM_STR);
        $query->execute();
    } else {
        $msg = "Your login details are invalid or email is not verified.";
        
    }
}
?><!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="theme-color" content="#0f9b75" />
  <title>Demo | Login</title>

  <!-- Keep your existing bundles if you want -->
  <link href="additioncss/template.css" rel="stylesheet"/>
  <link href="additioncss/login.css" rel="stylesheet"/>

  <style>
    :root{
      --brand:#0f9b75;
      --brand-dark:#0a4d3e;
      --ink:#1f2d3d;
      --muted:#6b7b8a;
      --line:#e9edf2;
      --bg:#ffffff;
      --chip:#f6faf8;
      --danger:#e03131;
    }
    html,body{margin:0;background:var(--bg);color:var(--ink);-webkit-font-smoothing:antialiased}
    /* Shell */
    .auth-shell{
      min-height:100vh; display:grid; grid-template-columns: 1fr;
      background:
        radial-gradient(700px 240px at 100% -10%, #e8fff5 0, transparent 60%) no-repeat,
        radial-gradient(600px 220px at -20% 110%, #f0fffa 0, transparent 60%) no-repeat,
        #fff;
    }
    .brand-panel {
  position: relative;
  display: none; /* hidden on mobile */
}
@media (min-width: 992px) {
  .brand-panel {
    display: block;
    flex: 1;
    min-height: 100vh;
    overflow: hidden;
    position: relative;
  }
}

/* Full cover image */
.cover-bg {
  position: absolute;
  inset: 0;
  background: url("images/pexels-goumbik-669610.jpg") center/cover no-repeat;
  z-index: 0;
}

/* Footer overlay */
.cover-footer {
  position: absolute;
  bottom: 0; left: 0; right: 0;
  padding: 32px 24px;
  background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(3,24,19,0.6) 100%);
  color: #fff;
  z-index: 1;
  text-align: left;
}

.cover-footer .chip {
  display:inline-block;
  background: rgba(255,255,255,.15);
  border:1px solid rgba(255,255,255,.3);
  padding:6px 12px;
  border-radius:999px;
  font-weight:600;
  font-size:.85rem;
  margin-bottom:10px;
}

.cover-footer .cover-title {
  margin:0 0 6px 0;
  font-size:1.5rem;
  font-weight:800;
}

.cover-footer .cover-sub {
  margin:0;
  font-size:.95rem;
  line-height:1.5;
  color:#eaeaea;
}

    @media (min-width: 992px){ .auth-shell{ grid-template-columns: 560px 1fr; } }

    /* Left: Card */
    .auth-card-wrap{display:grid; place-items:center; padding:24px}
    .auth-card{
      width:100%; max-width: 520px; background:#fff; border:1px solid var(--line);
      border-radius:20px; overflow:hidden; box-shadow:0 22px 70px rgba(0,0,0,.07);
    }
    .auth-accent{height:6px; background:linear-gradient(90deg,var(--brand),var(--brand-dark));}

    .auth-body{ padding:28px; }
    .brand-mini{ display:flex; align-items:center; gap:10px; margin-bottom:8px; }
    .brand-mini img{ width:160px; height:auto; }

    .heading-xl{ margin:6px 0 0 0; font-size:1.9rem; font-weight:800; }
    .subtle{ color:var(--muted); }

    /* Form */
    .form-grid{ display:grid; gap:16px; margin-top:18px; }
    .field{ display:grid; gap:8px; }
    .label{ font-size:.95rem; font-weight:600; color:var(--ink); }

    .control{
      position:relative;
    }
    .input{
      width:100%; background:#fff; border:1px solid var(--line); border-radius:12px;
      padding:12px 14px; font-size:1rem; color:var(--ink); outline:none;
      transition:border-color .2s, box-shadow .2s;
    }
    .input:focus{ border-color: var(--brand); box-shadow:0 0 0 4px #0f9b751a; }
    .input.has-error{ border-color:var(--danger); box-shadow:0 0 0 4px #e031311a; }

    .toggle-pass{
      position:absolute; right:10px; top:50%; transform:translateY(-50%);
      background:#f6f9f8; border:1px solid var(--line); color:#324; font-size:.85rem;
      border-radius:10px; padding:6px 10px; cursor:pointer;
    }

    /* Row utils */
    .row{ display:flex; align-items:center; justify-content:space-between; gap:10px; }
    .muted{ color:var(--muted); font-size:.95rem; }

    /* Switch */
    .switch{
      position:relative; width:38px; height:22px;
    }
    .switch input{ opacity:0; width:0; height:0; }
    .slider{
      position:absolute; inset:0; background:#e9eff3; border-radius:999px; cursor:pointer;
      transition: .2s;
    }
    .slider:before{
      content:""; position:absolute; width:18px; height:18px; left:2px; top:2px;
      background:#fff; border-radius:50%; box-shadow:0 2px 6px rgba(0,0,0,.15);
      transition:.2s;
    }
    .switch input:checked + .slider{
      background:linear-gradient(90deg,var(--brand),var(--brand-dark));
    }
    .switch input:checked + .slider:before{ transform:translateX(16px); }

    /* Buttons */
    .btn{
      display:inline-block; width:100%; padding:12px 16px; border-radius:12px;
      text-align:center; font-weight:700; text-transform:uppercase; cursor:pointer;
      border:1px solid transparent; transition:filter .15s;
    }
    .btn-primary{
      background:linear-gradient(135deg,var(--brand),var(--brand-dark)); color:#fff;
      border-color:transparent;
    }
    .btn-primary:hover{ filter:brightness(.98); }

    /* Error msg */
    .error-msg{
      margin-top:6px; color:var(--danger); font-weight:600; text-align:center;
      background:#fff5f5; border:1px solid #ffd9d9; border-radius:12px; padding:10px 12px;
    }

    /* Fine print */
    .foot-note{ text-align:center; margin-top:12px; color:var(--muted); }
    .foot-note a{ color:var(--brand); font-weight:700; text-decoration:none; }

    /* Right: Visual panel */
    .brand-panel{
      position:relative; padding:28px;
      background:
        radial-gradient(900px 360px at 90% -20%, #e6fff4 0, transparent 60%) no-repeat,
        radial-gradient(900px 360px at 0% 120%, #e6fff4 0, transparent 60%) no-repeat,
        #ffffff;
      border-left:1px solid var(--line);
      display:flex; flex-direction:column; gap:18px;
    }
    .panel-top{
      display:flex; align-items:center; justify-content:space-between; gap:12px;
    }
    .panel-logo img{ width:200px; height:auto; }
    .panel-card{
      margin-top:auto; border:1px solid var(--line); border-radius:18px; background:#fff;
      padding:18px; box-shadow:0 12px 40px rgba(0,0,0,.06);
    }
    .chip{
      display:inline-block; background:var(--chip); border:1px solid #e5efe9; color:var(--brand);
      padding:6px 12px; border-radius:999px; font-weight:700; font-size:.85rem;
    }

    /* Hide old classes you marked */
    .text-size-display-1{ font-size:2rem; margin:0; }
    .heading-6{ visibility:hidden; }
    @media (max-width: 991px){
      .brand-panel{ display:none; }
      .auth-shell{ grid-template-columns: 1fr; }
    }
   

  </style>
</head>

<body>
  <form method="post">
    <div class="auth-shell">
      <!-- LEFT: Card -->
      <div class="auth-card-wrap">
        <div class="auth-card">
          <div class="auth-accent"></div>
          <div class="auth-body">
            <div class="brand-mini">
              <img src="/images/democ.png" alt="Demo" />
            </div>
            <h1 class="heading-xl">Welcome back!</h1>
            <div class="subtle">Please enter your details to sign in.</div>

            <!-- Server message -->
            <?php if (isset($msg) && $msg): ?>
              <div class="error-msg"><?php echo htmlspecialchars($msg); ?></div>
            <?php endif; ?>

            <div class="form-grid">
              <div class="field">
                <label for="login-email-input" class="label">Email</label>
                <div class="control">
                  <input type="email" name="username" id="login-email-input" class="input" placeholder="you@example.com" required />
                </div>
              </div>

              <div class="field">
                <label for="login-password-input" class="label">Password</label>
                <div class="control">
                  <input type="password" name="password" id="login-password-input" class="input" placeholder="••••••••" required />
                  <button type="button" class="toggle-pass" aria-label="Show password" id="togglePassBtn">Show</button>
                </div>
              </div>
            </div>

            <div class="row" style="margin-top:12px;">
              <label class="row" for="remember-me" style="gap:10px; cursor:pointer;">
                <div class="switch">
                  <input type="checkbox" id="remember-me" />
                  <span class="slider"></span>
                </div>
                <span class="muted">Remember me</span>
              </label>
              <a href="forgotpassword.php" class="muted" style="text-decoration:none;font-weight:700;color:var(--brand)">Forgot password?</a>
            </div>

            <div style="margin-top:16px;">
              <button type="submit" name="signin" id="login-button" class="btn btn-primary">Sign in</button>
            </div>

            <div class="foot-note">
              Don’t have an account?
              <a href="register.php">Sign up now</a>
            </div>
          </div>
        </div>
      </div>

      <!-- RIGHT: Brand panel (decorative / marketing) -->
     <aside class="brand-panel">
  <!-- Full background image -->
  <div class="cover-bg"></div>

  <!-- Footer content -->
  <footer class="cover-footer">
    <div class="chip">Secure • Reliable • Fast</div>
    <h3 class="cover-title">Trade smarter with confidence</h3>
    <p class="cover-sub">
      Seamless, secure sign-in. We protect your account with best-in-class security and privacy practices.
    </p>
  </footer>
</aside>

    </div>
  </form>

  <script>
    // Password show/hide
    (function(){
      var btn = document.getElementById('togglePassBtn');
      var input = document.getElementById('login-password-input');
      if(!btn || !input) return;
      btn.addEventListener('click', function(){
        var showing = input.getAttribute('type') === 'text';
        input.setAttribute('type', showing ? 'password' : 'text');
        btn.textContent = showing ? 'Show' : 'Hide';
        btn.setAttribute('aria-label', showing ? 'Show password' : 'Hide password');
      });
    })();
  </script>
</body>
</html>
