<?php
// dashboard.php — one-page example with sticky header + designed sidebar

// ---------- Boot & Auth ----------
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once 'config.php'; // defines $conn (PDO)

if (empty($_SESSION['clogin'])) {
  echo "<script>location.href='login.php';</script>";
  exit;
}

$userEmail = $_SESSION['clogin'] ?? '';
// Fetch user (username/fullname/email/password for IB redirect)
try {
  $stUser = $conn->prepare("SELECT username, fullname, email, password FROM aspnetusers WHERE email = :e LIMIT 1");
  $stUser->execute([':e'=>$userEmail]);
  $user = $stUser->fetch(PDO::FETCH_OBJ);
} catch(Throwable $e) { $user = null; }

if (!$user) {
  session_destroy();
  echo "<script>location.href='login.php';</script>";
  exit;
}

$username = $user->username ?: $user->email;
$fullname = $user->fullname ?: 'User';
$mail     = $user->email;
$pwd      = (string)($user->password ?? '');

// ---------- Notifications (unread news) ----------
$unread_count = 0; $unread_items = [];
try {
  $sqlCount = "SELECT COUNT(*) FROM news n
               LEFT JOIN news_reads r ON r.news_id=n.id AND r.user_email=:e
               WHERE r.news_id IS NULL";
  $st = $conn->prepare($sqlCount); $st->execute([':e'=>$mail]); $unread_count = (int)$st->fetchColumn();

  $sqlList = "SELECT n.id,n.title,n.created_at FROM news n
              LEFT JOIN news_reads r ON r.news_id=n.id AND r.user_email=:e
              WHERE r.news_id IS NULL
              ORDER BY n.created_at DESC, n.id DESC LIMIT 10";
  $st2 = $conn->prepare($sqlList); $st2->execute([':e'=>$mail]); $unread_items = $st2->fetchAll(PDO::FETCH_ASSOC);
} catch(Throwable $e) { /* ignore */ }

// ---------- Helpers ----------
function is_active($needle){
  $u = $_SERVER['REQUEST_URI'] ?? '';
  return strpos($u, $needle) !== false ? 'is-active' : '';
}
$ib_href = 'https://test.traderssolution.com/crmvideonew/ibportal/redirect-login.php?' . http_build_query([
  'email'    => $mail,
  'password' => $pwd,
]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

  <!-- Tailwind (for utilities) -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Bootstrap CSS (for dropdown/modal behavior you already use) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/>

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>

  <!-- Optional: your existing theme CSS (kept for compatibility) -->
  <link rel="shortcut icon" href="https://test.traderssolution.com/crmvideonew/logo.png" />
  <link rel="stylesheet" href="https://test.tradersolution.com/crmvideonew/assets/css/core/libs.min.css" />
  <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/vendor/aos/dist/aos.css" />
  <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/hope-ui.min.css?v=2.0.0" />
  <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/custom.min.css?v=2.0.0" />
  <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/dark.min.css"/>
  <link rel="stylesheet" href="https://test.traderssolution.com/crmvideonew/assets/css/rtl.min.css"/>

  <style>
    :root{
      --bronze:#CD7F32;
      --ink:#0f172a;
      --muted:#64748b;
      --line:#e2e8f0;
      --sidebar-w: 270px;
    }

    /* Sticky header (fixed) */
    #tree{
      position: fixed; top:0; left:0; right:0; z-index: 9999;
      background: rgba(255,255,255,.95);
      backdrop-filter: saturate(180%) blur(6px);
      border-bottom: 1px solid #f1f5f9;
      width:100%;
      transition: box-shadow .2s ease, backdrop-filter .2s ease, height .2s ease;
    }
    #tree.scrolled{ box-shadow: 0 6px 20px rgba(0,0,0,.08); }

    /* Body offset so content doesn't hide under header */
    body.has-fixed-header{ padding-top: 72px; } /* will be corrected by JS to exact height */

    /* Sidebar base */
    #sidebar{
      width: var(--sidebar-w);
      background:#fff;
      border-right:1px solid var(--line);
      box-shadow:0 8px 24px rgba(0,0,0,.06);
      transition: transform .28s ease, box-shadow .2s ease;
    }
    @media (max-width: 767.98px){
      #sidebar{ transform: translateX(-100%); }
      #sidebar.open{ transform: translateX(0); }
      #sidebar .close-btn{ display:inline-flex; }
    }
    @media (min-width: 768px){
      #sidebar{ transform:none; }
      #sidebar .close-btn{ display:none; }
    }

    /* Scrollbar */
    .custom-scrollbar::-webkit-scrollbar { width: 8px; }
    .custom-scrollbar::-webkit-scrollbar-thumb{ background:#cbd5e1; border-radius:8px; }
    .custom-scrollbar{ scrollbar-width: thin; scrollbar-color:#cbd5e1 transparent; }

    /* Menu */
    .menu-group-title{
      font-size:.72rem; text-transform:uppercase; letter-spacing:.06em;
      color:var(--muted); margin:1rem 1rem .25rem 1rem; padding:.25rem .5rem;
    }
    .menu-item{
      position:relative; display:flex; align-items:center; gap:.75rem;
      padding:.625rem .875rem; margin:.125rem .5rem; border-radius:.6rem;
      color:#111827; text-decoration:none; transition: background .2s, color .2s, transform .1s;
    }
    .menu-item .icon{ width:1.15rem; display:inline-flex; justify-content:center; align-items:center; }
    .menu-item:hover{ background:var(--bronze); color:#fff; }
    .menu-item:hover .icon, .menu-item:hover span{ color:#fff !important; }
    .menu-item.is-active{
      background:rgba(205,127,50,.10); outline:1px solid rgba(205,127,50,.25); color:var(--ink);
    }
    .menu-item.is-active .icon{ color:var(--bronze); }

    .accordion .chev{ margin-left:auto; transition: transform .2s ease; }
    .accordion.open .chev{ transform: rotate(180deg); }
    .submenu{
      max-height:0; overflow:hidden; transition:max-height .24s ease;
      margin:0 .5rem; border-left:2px solid rgba(205,127,50,.25); border-radius:.25rem;
    }
    .submenu a{
      display:flex; align-items:center; gap:.5rem;
      padding:.5rem .875rem .5rem 1.75rem; margin:.125rem 0; border-radius:.5rem;
      color:#374151; text-decoration:none; transition: background .2s, color .2s;
    }
    .submenu a:hover{ background:var(--bronze); color:#fff; }
    .submenu h4{
      font-size:.75rem; font-weight:700; color:#fff; background:var(--bronze);
      padding:.5rem .875rem; margin:.35rem 0 .25rem 0; border-radius:.5rem;
    }

    .close-btn{
      position:absolute; top:.75rem; right:.75rem; color:#334155; background:#f1f5f9; border:1px solid var(--line);
      width:34px; height:34px; border-radius:.5rem; align-items:center; justify-content:center;
    }

    /* Content area */
    #main-content{ margin-left: var(--sidebar-w); transition: margin-left .28s ease; }
    @media (max-width: 767.98px){
      #main-content{ margin-left: 0; }
    }
  </style><style>/* Sidebar: hide scrollbar (Chrome/Safari/Edge) */
#sidebar.custom-scrollbar::-webkit-scrollbar { width: 0; height: 0; }
/* Sidebar: hide scrollbar (Firefox) */
#sidebar.custom-scrollbar { scrollbar-width: none; }
/* Sidebar: hide scrollbar (old IE/Edge) */
#sidebar.custom-scrollbar { -ms-overflow-style: none; }
</style>
</head>
<body class="bg-gray-100 m-0 p-0">

<!-- ===================== HEADER ===================== -->
<!--<header id="tree" class="bg-white shadow-md p-4 flex justify-between items-center">-->
  <!-- Left: Sidebar Toggle -->
<!--  <div class="flex items-center gap-2">-->
<!--    <button id="sidebarToggle" class="btn btn-outline-primary me-2 !border-orange-500 !text-orange-600">-->
<!--      <i class="fa fa-bars"></i>-->
<!--    </button>-->
<!--    <span class="font-semibold text-slate-700">Client Portal</span>-->
<!--  </div>-->

  <!-- Right: Notifications + Profile -->
<!--  <div class="relative flex items-center space-x-4">-->
    <!-- Bell dropdown (Bootstrap) -->
<!--    <div class="nav-item dropdown list-none">-->
<!--      <a class="nav-link cursor-pointer" href="#" data-bs-toggle="dropdown" aria-expanded="false" style="position:relative;">-->
<!--        <i class="fa fa-bell text-slate-700"></i>-->
<!--        <?php if (!empty($unread_count)): ?>-->
<!--          <span style="position:absolute; top:-4px; right:-6px; background:#e11d48; color:#fff; border-radius:999px; font-size:11px; padding:2px 6px; line-height:1;">-->
<!--            <?= htmlspecialchars($unread_count) ?>-->
<!--          </span>-->
<!--        <?php endif; ?>-->
<!--      </a>-->
<!--      <div class="dropdown-menu dropdown-menu-end p-0" style="min-width:300px;">-->
<!--        <div class="p-2" style="border-bottom:1px solid #eee; font-weight:700;">News</div>-->
<!--        <div style="max-height:320px; overflow:auto;">-->
<!--          <?php if ($unread_items): ?>-->
<!--            <?php foreach ($unread_items as $n): ?>-->
<!--              <a class="dropdown-item d-flex align-items-start" href="news.php?id=<?= (int)$n['id'] ?>&src=notif">-->
<!--                <div>-->
<!--                  <div style="font-weight:600;"><?= htmlspecialchars($n['title']) ?></div>-->
<!--                  <div style="font-size:12px; color:#64748b;"><?= htmlspecialchars($n['created_at']) ?></div>-->
<!--                </div>-->
<!--              </a>-->
<!--            <?php endforeach; ?>-->
<!--          <?php else: ?>-->
<!--            <div class="px-3 py-2 text-muted">No new news</div>-->
<!--          <?php endif; ?>-->
<!--        </div>-->
<!--      </div>-->
<!--    </div>-->

    <!-- Profile -->
<!--    <img src="https://randomuser.me/api/portraits/men/50.jpg" alt="Admin" class="w-10 h-8 rounded-full border-2 border-orange-600">-->
<!--    <button class="bg-orange-600 text-white py-2 px-4 rounded-full flex items-center space-x-2" id="dropdownButton">-->
<!--      <span class="text-sm"><?= htmlspecialchars($username) ?></span>-->
<!--      <i class="fas fa-caret-down"></i>-->
<!--    </button>-->

    <!-- Profile dropdown (custom) -->
<!--    <div class="absolute right-0 mt-12 w-52 bg-white rounded-md shadow-lg hidden z-50" id="dropdownMenu">-->
<!--      <div class="p-4">-->
<!--        <p class="font-semibold text-gray-700"><?= htmlspecialchars($fullname) ?></p>-->
<!--        <p class="text-sm text-gray-500"><?= htmlspecialchars($mail) ?></p>-->
<!--      </div>-->
<!--      <div class="border-t border-gray-200">-->
<!--        <a href="profile.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-100"><i class="fa fa-user mr-2"></i> Profile</a>-->
<!--        <button type="button" id="openPasswordModal" class="w-full text-left px-4 py-2 text-gray-700 hover:bg-gray-100"><i class="fa fa-key mr-2"></i> Change Password</button>-->
<!--        <a href="logout.php" class="block px-4 py-2 text-gray-700 hover:bg-gray-100"><i class="fa fa-sign-out mr-2"></i> Logout</a>-->
<!--      </div>-->
<!--    </div>-->
<!--  </div>-->
<!--</header>-->
<!-- =================== /HEADER =================== -->

<!-- ===================== SIDEBAR ===================== -->
<aside id="sidebar" class="fixed top-0 left-0 h-full z-[60] md:block bg-white custom-scrollbar overflow-y-auto">
  <!-- Close (mobile) -->
  <button id="closeSidebar" class="close-btn hidden">
    <i class="fas fa-times text-[15px]"></i>
  </button>

  <!-- Brand -->
  <div class="px-4 pt-4 pb-2 flex items-center gap-2">
    <img src="https://test.traderssolution.com/crmvideonew/logo.png" class="h-8 w-8 rounded" alt="Logo">
    <div>
      <div class="font-semibold text-slate-800 leading-5">Client Portal</div>
      <div class="text-xs text-slate-500"><?= htmlspecialchars($mail ?: 'User') ?></div>
    </div>
  </div>

  <nav class="mt-2 pb-6"><br>
<div class="menu-group-title flex justify-center items-center py-2">

</div>

    <a href="dashboard.php" class="menu-item <?= is_active('dashboard.php') ?>">
      <i class="fas fa-tachometer-alt icon text-orange-600"></i><span>Dashboard</span>
    </a>

    <div class="menu-item accordion" data-acc="compliance">
      <i class="fas fa-shield-alt icon text-orange-600"></i><span>Compliance</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-compliance">
      <h4>Compliance</h4>
      <a href="profile.php" class="<?= is_active('profile.php') ?>"><i class="fas fa-id-badge icon"></i><span>User Document</span></a>
      <!-- <a href="add_bank_details.php"><i class="fas fa-university icon"></i><span>Bank Details</span></a> -->
    </div>

    <div class="menu-item accordion" data-acc="myaccount">
      <i class="fas fa-user-cog icon text-orange-600"></i><span>My Account</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-myaccount">
      <h4>My Account</h4>
      <a href="live_accounts.php" class="<?= is_active('live_accounts.php') ?>"><i class="fas fa-plus-square icon"></i><span>Create MT5 Live Account</span></a>
      <a href="account_list.php" class="<?= is_active('account_list.php') ?>"><i class="fas fa-list icon"></i><span>Account List</span></a>
      <a href="change_mt5_password.php" class="<?= is_active('change_mt5_password.php') ?>"><i class="fas fa-key icon"></i><span>Change MT5 Password</span></a>
    </div>

    <div class="menu-item accordion" data-acc="myfund">
      <i class="fas fa-wallet icon text-orange-600"></i><span>My Fund</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-myfund">
      <h4>My Fund</h4>
      <a href="deposit_handler.php" class="<?= is_active('deposit_handler.php') ?>"><i class="fas fa-arrow-down icon"></i><span>Wallet Deposit</span></a>
      <a href="withdraw.php" class="<?= is_active('withdraw.php') ?>"><i class="fas fa-arrow-up icon"></i><span>Wallet Withdraw</span></a>
      <a href="#" data-bs-toggle="modal" data-bs-target="#openAccountModaltransfer"><i class="fas fa-exchange-alt icon"></i><span>Transfer Account</span></a>
    </div>

    <div class="menu-item accordion" data-acc="ib">
      <i class="fas fa-handshake icon text-orange-600"></i><span>IB Programme</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-ib">
      <h4>IB Programme</h4>
      <a href="<?= htmlspecialchars($ib_href, ENT_QUOTES) ?>" rel="noopener"><i class="fas fa-columns icon"></i><span>Dashboard</span></a>
    </div>

    <div class="menu-item accordion" data-acc="pamm">
      <i class="fas fa-chart-pie icon text-orange-600"></i><span>PAMM</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-pamm">
      <h4>PAMM</h4>
      <a href="leader-board.php" class="<?= is_active('leader-board.php') ?>"><i class="fas fa-trophy icon"></i><span>PAMM Leaderboard</span></a>
      <a href="become_pamm_investor.php" class="<?= is_active('become_pamm_investor.php') ?>"><i class="fas fa-user-plus icon"></i><span>Become an Investor</span></a>
      <a href="become_pamm__money_manager.php" class="<?= is_active('become_pamm__money_manager.php') ?>"><i class="fas fa-briefcase icon"></i><span>Become a Money Manager</span></a>
    </div>

    <div class="menu-item accordion" data-acc="copier">
      <i class="fas fa-copy icon text-orange-600"></i><span>Copier</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-copier">
      <h4>Copier</h4>
      <a href="copier_leader_board.php" class="<?= is_active('copier_leader_board.php') ?>"><i class="fas fa-trophy icon"></i><span>Copier Leaderboard</span></a>
      <a href="become_slave.php" class="<?= is_active('become_slave.php') ?>"><i class="fas fa-user-friends icon"></i><span>Become a Slave</span></a>
      <a href="become_copier_master.php" class="<?= is_active('become_copier_master.php') ?>"><i class="fas fa-user-tie icon"></i><span>Become a Master</span></a>
    </div>

    <a href="performance.php" class="menu-item <?= is_active('performance.php') ?>">
      <i class="fas fa-chart-line icon text-orange-600"></i><span>Performance Summary</span>
    </a>

    <div class="menu-item accordion" data-acc="reports">
      <i class="fas fa-clipboard-list icon text-orange-600"></i><span>My Reports</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-reports">
      <h4>My Reports</h4>
      <a href="deposit_reports.php" class="<?= is_active('deposit_reports.php') ?>"><i class="fas fa-file-invoice-dollar icon"></i><span>Deposit Reports</span></a>
      <a href="withdraw_reports.php" class="<?= is_active('withdraw_reports.php') ?>"><i class="fas fa-file-invoice icon"></i><span>Withdraw Reports</span></a>
      <a href="ib_withdraw_report.php" class="<?= is_active('ib_withdraw_report.php') ?>"><i class="fas fa-hand-holding-usd icon"></i><span>IB Withdraw Reports</span></a>
      <a href="internal_transfer_report.php" class="<?= is_active('internal_transfer_report.php') ?>"><i class="fas fa-random icon"></i><span>Internal Transfer Reports</span></a>
    </div>

    <a href="news.php" class="menu-item <?= is_active('news.php') ?>">
      <i class="fas fa-newspaper icon text-orange-600"></i><span>News</span>
    </a>

    <div class="menu-item accordion" data-acc="helpdesk">
      <i class="fas fa-life-ring icon text-orange-600"></i><span>Help Desk</span>
      <i class="fas fa-chevron-down chev text-slate-500"></i>
    </div>
    <div class="submenu" id="submenu-helpdesk">
      <h4>Help Desk</h4>
      <a href="my_ticket.php" class="<?= is_active('my_ticket.php') ?>"><i class="fas fa-ticket-alt icon"></i><span>My Ticket</span></a>
      <a href="create_ticket.php" class="<?= is_active('create_ticket.php') ?>"><i class="fas fa-plus-circle icon"></i><span>New Ticket</span></a>
    </div>
  </nav>
</aside>
<!-- =================== /SIDEBAR =================== -->


<!-- =================== /MAIN CONTENT =================== -->

<!-- ===================== Transfer Modal ===================== -->
<div class="modal fade" id="openAccountModaltransfer" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 rounded-3 overflow-hidden">
      <div class="modal-header" style="background:linear-gradient(135deg,#f59e0b 0%,#fbbf24 50%,#f59e0b 100%);">
        <h5 class="modal-title fw-bold text-white">Transfer Funds</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <form id="transferForm" class="modal-body bg-white" method="post" action="otpcode.php">
        <label class="form-label fw-semibold text-muted">Trading Account</label>
        <select class="form-select mb-3" id="trade_idtransfer" name="trade_id" onchange="fetchBalancetransfer()" required>
          <option value="">Select Account</option>
          <?php
            $stmt = $conn->prepare("SELECT trade_id, account_name FROM liveaccount WHERE email = :email");
            $stmt->execute([':email'=>$mail]);
            while ($row = $stmt->fetch(PDO::FETCH_OBJ)) {
              echo '<option value="'.htmlentities($row->trade_id).'">'.htmlentities($row->trade_id).' ('.htmlentities($row->account_name).')</option>';
            }
          ?>
        </select>

        <label class="form-label fw-semibold text-muted">Available Balance (USD)</label>
        <input id="balanceField" type="text" class="form-control mb-3" placeholder="$0.00" readonly>

        <label class="form-label fw-semibold text-muted">Transfer To (Trade ID)</label>
        <select class="form-select mb-3" id="trade" name="accountfor" required>
          <option value="">Select Account</option>
          <?php
            $stmt2 = $conn->query("SELECT trade_id, email FROM liveaccount");
            while ($r = $stmt2->fetch(PDO::FETCH_OBJ)) {
              echo '<option value="'.htmlentities($r->trade_id).'">'.htmlentities($r->trade_id).' ('.htmlentities($r->email).')</option>';
            }
          ?>
        </select>

        <label class="form-label fw-semibold text-muted">Withdraw Amount USD</label>
        <input id="withdrawAmt" name="withdraw_amount" type="number" min="0" step="0.01" class="form-control mb-2" placeholder="0.00" required>
        <div id="amtHelp" class="form-text text-danger d-none">Amount exceeds available balance.</div>

        <input type="hidden" name="withdraw_type" value="internal_transfer">
        <input type="hidden" name="account_number" value="">
        <input type="hidden" name="ifsc" value="">
        <input type="hidden" name="client_bank" value="">
        <input type="hidden" name="account_holder_name" value="">
        <input type="hidden" name="email" value="<?=htmlspecialchars($mail, ENT_QUOTES)?>">
      </form>
      <div class="modal-footer bg-white">
        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" form="transferForm" class="btn" style="background:linear-gradient(90deg,#f59e0b,#fbbf24); color:#fff; font-weight:600;">Submit</button>
      </div>
    </div>
  </div>
</div>
<!-- =================== /Transfer Modal =================== -->

<!-- ===================== Password Modal ===================== -->
<div id="passwordModal" class="fixed inset-0 hidden items-center justify-center z-[10000]">
  <div class="absolute inset-0 bg-black/50" id="passwordModalBackdrop"></div>
  <div class="relative bg-white w-full max-w-md mx-4 rounded-2xl shadow-2xl p-6">
    <div class="flex items-center justify-between mb-4">
      <h3 class="text-lg font-semibold">Update Password</h3>
      <button type="button" id="closePasswordModal" class="text-gray-500 hover:text-gray-700">
        <i class="fa fa-times"></i>
      </button>
    </div>
    <form method="post" onsubmit="return validatePassForm();" action="">
      <input type="hidden" name="change_password" value="1" />
      <div class="mb-4">
        <label class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
        <input type="password" name="new_password" id="new_password" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-orange-500" required>
      </div>
      <div class="mb-6">
        <label class="block text-sm font-medium text-gray-700 mb-1">Confirm New Password</label>
        <input type="password" name="confirm_password" id="confirm_password" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-orange-500" required>
      </div>
      <div class="flex items-center justify-end gap-3">
        <button type="button" id="cancelPasswordModal" class="px-4 py-2 rounded-lg border border-gray-300 hover:bg-gray-50">Cancel</button>
        <button type="submit" class="px-4 py-2 rounded-lg bg-orange-600 text-white hover:bg-orange-700">Update</button>
      </div>
    </form>
  </div>
</div>
<!-- =================== /Password Modal =================== -->

<!-- Bootstrap JS (dropdowns & modal) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // ----- Header: body offset + shadow on scroll
  document.addEventListener('DOMContentLoaded', () => {
    const header = document.getElementById('tree');
    const setBodyOffset = () => { document.body.classList.add('has-fixed-header'); document.body.style.paddingTop = header.offsetHeight + 'px'; };
    setBodyOffset(); window.addEventListener('resize', setBodyOffset);

    const onScroll = () => { if (window.scrollY > 6) header.classList.add('scrolled'); else header.classList.remove('scrolled'); };
    document.addEventListener('scroll', onScroll); onScroll();
  });

  // ----- Header: profile dropdown (custom)
  (function(){
    const btn = document.getElementById('dropdownButton');
    const menu = document.getElementById('dropdownMenu');
    if (!btn || !menu) return;
    btn.addEventListener('click', (e)=>{ e.stopPropagation(); menu.classList.toggle('hidden'); });
    document.addEventListener('click', (e)=>{ if (!menu.contains(e.target) && e.target!==btn) menu.classList.add('hidden'); });
  })();

  // ----- Password modal (custom)
  (function(){
    const modal = document.getElementById('passwordModal');
    const openBtn = document.getElementById('openPasswordModal');
    const closeBtn = document.getElementById('closePasswordModal');
    const cancelBtn= document.getElementById('cancelPasswordModal');
    const backdrop= document.getElementById('passwordModalBackdrop');

    function open(){ modal.classList.remove('hidden'); modal.classList.add('flex'); document.body.classList.add('modal-open'); }
    function close(){ modal.classList.add('hidden'); modal.classList.remove('flex'); document.body.classList.remove('modal-open'); 
      const np=document.getElementById('new_password'); const cp=document.getElementById('confirm_password'); if(np)np.value=''; if(cp)cp.value='';
    }
    if (openBtn) openBtn.addEventListener('click', (e)=>{ e.preventDefault(); open(); });
    if (closeBtn) closeBtn.addEventListener('click', close);
    if (cancelBtn) cancelBtn.addEventListener('click', close);
    if (backdrop) backdrop.addEventListener('click', close);

    window.validatePassForm = function(){
      const np = (document.getElementById('new_password').value||'').trim();
      const cp = (document.getElementById('confirm_password').value||'').trim();
      if (!np || !cp){ alert('Please fill both password fields.'); return false; }
      if (np !== cp){ alert('Passwords do not match.'); return false; }
      return true;
    }
  })();

  // ----- Sidebar: open/close (mobile), accordions
  (function(){
    const sidebar   = document.getElementById('sidebar');
    const toggleBtn = document.getElementById('sidebarToggle');
    const closeBtn  = document.getElementById('closeSidebar');

    if (toggleBtn && sidebar){
      toggleBtn.addEventListener('click', ()=>{
        if (window.matchMedia('(max-width: 767.98px)').matches) sidebar.classList.toggle('open');
        // desktop stays fixed open by default
      });
    }
    if (closeBtn && sidebar){ closeBtn.addEventListener('click', ()=> sidebar.classList.remove('open')); }

    // Accordions
    document.querySelectorAll('#sidebar .accordion').forEach(tr => {
      tr.addEventListener('click', () => {
        const key = tr.getAttribute('data-acc');
        const panel = document.getElementById('submenu-'+key);
        if (!panel) return;

        const isOpen = tr.classList.contains('open');
        // close others
        document.querySelectorAll('#sidebar .accordion.open').forEach(o=>{
          o.classList.remove('open');
          const k = o.getAttribute('data-acc');
          const p = document.getElementById('submenu-'+k);
          if (p){ p.style.maxHeight='0px'; }
        });
        if (!isOpen){ tr.classList.add('open'); panel.style.maxHeight = panel.scrollHeight + 'px'; }
        else { tr.classList.remove('open'); panel.style.maxHeight='0px'; }
      });
    });

    // Auto-open active section
    const activeLink = document.querySelector('#sidebar .submenu a.is-active, #sidebar .menu-item.is-active');
    if (activeLink){
      const sub = activeLink.closest('.submenu'); const acc = sub ? sub.previousElementSibling : null;
      if (sub && acc && acc.classList.contains('accordion')){ acc.classList.add('open'); sub.style.maxHeight = sub.scrollHeight + 'px'; }
    }
  })();

  // ----- Transfer balance AJAX
  function fetchBalancetransfer(){
    var trade_idtransfer = document.getElementById("trade_idtransfer").value;
    var balEl = document.getElementById("balanceField");
    var amtEl = document.getElementById("withdrawAmt");
    var help  = document.getElementById("amtHelp");
    if (!trade_idtransfer){ balEl.value=""; amtEl.removeAttribute('max'); help.classList.add('d-none'); return; }
    var xhr = new XMLHttpRequest();
    xhr.open("POST", "fetch_balance_transfer.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function () {
      if (xhr.readyState === 4 && xhr.status === 200) {
        var val = parseFloat(xhr.responseText || "0");
        if (isNaN(val)) { val = 0; }
        balEl.value = "$" + val.toFixed(2);
        amtEl.max = val; help.classList.add('d-none');
      }
    };
    xhr.send("trade_idtransfer=" + encodeURIComponent(trade_idtransfer));
  }
  document.getElementById('trade_idtransfer')?.addEventListener('change', fetchBalancetransfer);
  document.getElementById('withdrawAmt')?.addEventListener('input', function(){
    var max = parseFloat(this.max || "0"); var cur = parseFloat(this.value || "0");
    var help = document.getElementById('amtHelp'); if (max && cur > max) help.classList.remove('d-none'); else help.classList.add('d-none');
  });
</script>

<?php
// ======== Handle password change POST (simple demo; consider hashing in production) ========
if (!empty($_POST['change_password'])) {
  $new_pass = $_POST['new_password'] ?? '';
  $confirm  = $_POST['confirm_password'] ?? '';
  if (!$new_pass || !$confirm) {
    echo "<script>alert('Please fill all password fields.');</script>";
  } elseif ($new_pass !== $confirm) {
    echo "<script>alert('Passwords do not match.');</script>";
  } else {
    try {
      $stmt = $conn->prepare("UPDATE aspnetusers SET password = :pwd WHERE email = :mail");
      $stmt->execute([':pwd'=>$new_pass, ':mail'=>$mail]);
      echo "<script>alert('Password updated successfully.');</script>";
    } catch(Throwable $e) {
      $m = addslashes($e->getMessage());
      echo "<script>alert('Error updating password: {$m}');</script>";
    }
  }
}
?>
</body>
</html>
