<?php
// Dummy Data (Simulated dataset)
$withdraws = [
    ['id' => 1, 'name' => 'John Doe', 'mt5_id' => 'MT5_1001', 'amount' => 500, 'payment_method' => 'Bank Transfer', 'note' => 'withdraw for trading', 'comment' => 'Verified', 'status' => 'Completed', 'date' => '2025-02-01'],
    ['id' => 2, 'name' => 'Jane Smith', 'mt5_id' => 'MT5_1002', 'amount' => 300, 'payment_method' => 'Crypto', 'note' => 'First withdraw', 'comment' => 'Pending review', 'status' => 'Pending', 'date' => '2025-02-02'],
    // Add more dummy records
];

// Get parameters for filtering and pagination
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $per_page;

$date_filter = isset($_GET['date_filter']) ? $_GET['date_filter'] : '';
$search = isset($_GET['search']) ? strtolower($_GET['search']) : '';

// Filter Data
$filtered_withdraws = array_filter($withdraws, function ($withdraw) use ($date_filter, $search) {
    if ($date_filter && $withdraw['date'] !== $date_filter) {
        return false;
    }
    if ($search && !stripos($withdraw['name'], $search) && !stripos($withdraw['mt5_id'], $search) && !stripos($withdraw['payment_method'], $search)) {
        return false;
    }
    return true;
});

// Paginate Results
$total_withdraws = count($filtered_withdraws);
$withdraws_to_display = array_slice($filtered_withdraws, $start, $per_page);
$total_pages = ceil($total_withdraws / $per_page);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Team withdraw Report</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex flex-col md:flex-row h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-4 md:p-6 md:ml-64">
        <div class="container mx-auto">
            <h1 class="text-3xl md:text-4xl font-bold text-center mb-6 text-[#CD7F32]">Team withdraw Report</h1>

            <!-- Filters & Search (Now responsive) -->
            <div class="mb-6 flex flex-col md:flex-row md:justify-between gap-4">
                <form action="team_withdraw_report.php" method="GET" class="flex flex-col md:flex-row gap-2 md:gap-4 w-full md:w-auto">
                    <label for="date_filter" class="text-[#CD7F32] font-semibold">Date:</label>
                    <input type="date" id="date_filter" name="date_filter" class="px-4 py-2 border border-gray-300 rounded-lg w-full md:w-auto" value="<?php echo $date_filter; ?>">
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Filter</button>
                </form>

                <form action="team_withdraw_report.php" method="GET" class="flex flex-col md:flex-row gap-2 md:gap-4 w-full md:w-auto">
                    <input type="text" name="search" placeholder="Search Name, MT5 ID, Payment Method" value="<?php echo $search; ?>" class="px-4 py-2 border border-gray-300 rounded-lg w-full md:w-auto" />
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Search</button>
                </form>
            </div>

            <!-- Records Per Page -->
            <div class="mb-6">
                <label for="per_page" class="text-[#CD7F32] font-semibold">Records per page:</label>
                <select id="per_page" name="per_page" class="px-4 py-2 border border-gray-300 rounded-lg" onchange="window.location.href = '?per_page=' + this.value;">
                    <option value="10" <?php echo $per_page == 10 ? 'selected' : ''; ?>>10</option>
                    <option value="25" <?php echo $per_page == 25 ? 'selected' : ''; ?>>25</option>
                    <option value="50" <?php echo $per_page == 50 ? 'selected' : ''; ?>>50</option>
                </select>
            </div>

            <!-- Responsive Table -->
            <div class="overflow-x-auto bg-white shadow-md rounded-lg">
                <table class="w-full min-w-[600px]">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">ID</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Name</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">MT5 ID</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Amount</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Payment Method</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Note</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Comment</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Status</th>
                            <th class="px-4 py-3 text-left text-[#CD7F32]">Date</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php foreach ($withdraws_to_display as $withdraw): ?>
                            <tr class="hover:bg-gray-100">
                                <td class="px-4 py-3"><?php echo $withdraw['id']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['name']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['mt5_id']; ?></td>
                                <td class="px-4 py-3"><?php echo '$' . number_format($withdraw['amount'], 2); ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['payment_method']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['note']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['comment']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['status']; ?></td>
                                <td class="px-4 py-3"><?php echo $withdraw['date']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-6 flex flex-col md:flex-row justify-between items-center gap-4">
                <div>
                    <span class="text-gray-700">Page <?php echo $page; ?> of <?php echo $total_pages; ?></span>
                </div>
                <div class="flex flex-col md:flex-row gap-2">
                    <?php if ($page > 1): ?>
                        <a href="?page=<?php echo $page - 1; ?>&per_page=<?php echo $per_page; ?>&search=<?php echo $search; ?>&date_filter=<?php echo $date_filter; ?>" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Previous</a>
                    <?php endif; ?>
                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?php echo $page + 1; ?>&per_page=<?php echo $per_page; ?>&search=<?php echo $search; ?>&date_filter=<?php echo $date_filter; ?>" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Next</a>
                    <?php endif; ?>
                </div>
            </div>

        </div><br><br><?php include "footer.php";?>
    </main>
</div>
</body>
</html>
