<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rewardName = $_POST['reward_name'];
    $rewardDesc = $_POST['reward_desc'];
    // Handle file upload
    if (isset($_FILES['reward_image'])) {
        $targetDir = "uploads/";
        $targetFile = $targetDir . basename($_FILES["reward_image"]["name"]);
        move_uploaded_file($_FILES["reward_image"]["tmp_name"], $targetFile);
    }
    echo "<script>alert('Reward added successfully!');</script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Rewards</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            margin: 20px auto;
        }
        .btn-submit {
            background-color: #e67e22;
            color: white;
            width: 100px;
        }
        .btn-submit:hover {
            background-color: #d35400;
        }
        .operator-box {
            text-align: center;
            font-weight: bold;
            border: 1px solid #ccc;
            padding: 5px 15px;
            border-radius: 5px;
            background-color: #f1f1f1;
            display: inline-block;
            min-width: 80px;
        }
        input, select {
            width: 100%;
            padding: 8px;
            margin: 5px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
<div class="flex flex-col md:flex-row h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
           <h2>Add Rewards</h2>
        <div class="form-container">
            <form>
                <div class="mb-3">
                    <label class="form-label">Reward Name</label>
                    <input type="text" class="form-control">
                </div>
                <div class="mb-3">
                    <label class="form-label">Reward Image</label>
                    <input type="file" class="form-control">
                </div>
                <div class="mb-3">
                    <label class="form-label">Reward Description</label>
                    <input type="text" class="form-control">
                </div>
                <h5>Rule 1 - Per Customer Basis</h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control" placeholder="Number of Total">
                    <div class="operator-box">AND</div>
                    <input type="text" class="form-control" placeholder="Min. Traded Lots Per Client">
                    <div class="operator-box">AND</div>
                    <input type="text" class="form-control" placeholder="Min. Deposits Per Client">
                </div>
                <div class="operator-box my-3">OR</div>
                <h5>Rule 2 - Total Customer Basis</h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control" placeholder="Total Deposit">
                    <div class="operator-box">AND</div>
                    <input type="text" class="form-control" placeholder="Total Traded Lots">
                </div>
                <button type="submit" class="btn btn-submit mt-3">Submit</button>
            </form>
        </div>
    </div>

<br><br><br>
</main>
<?php include "footer.php";?>
</div>
</body>
</html>
