<?php
/**
 * Admin Dashboard — PDO-only (uses config.php), responsive + professional UI
 * Focus: Security/Compliance, Operations, Finance, and Activity.
 */
@session_start();

/* Debug (disable in production) */
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/config.php'; // must define $conn = new PDO(...)

if (empty($_SESSION['clogin'])) {
  echo "<script>window.location.href='login.php';</script>"; exit;
}
/* Fetch essentials from ib1 (only status=0) */
$sql = "
  SELECT
    indexId,
    name,
    email,
    number,
    country,
    ib_ref_code,
    noClients,
    reg_date,
    status
  FROM ib1
  WHERE status = 0
  ORDER BY reg_date DESC, indexId DESC
  LIMIT 500
";
$stmt = $conn->query($sql);
$rows = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>IB User List</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.2.0/remixicon.min.css" rel="stylesheet"/>
  <style>
    /* compact buttons */
    .btn-sm{padding:.25rem .5rem;font-size:.75rem;line-height:1rem;border-radius:.375rem}
    /* keep table header sticky on overflow */
    .table-wrap{max-height:70vh;overflow:auto}
    .table-wrap thead th{position:sticky;top:0;z-index:1}
    /* mobile: make action buttons wrap nicely */
    .actions{display:flex;flex-wrap:wrap;gap:.25rem;justify-content:center}
  </style>
</head>
<body class="bg-gray-100">
<?php include "header.php"; ?>

<!-- Page shell leaves space for fixed sidebar on md+ -->
<div class="min-h-screen md:pl-64">
  <?php include "side_bar.php"; ?>

  <main class="px-4 sm:px-6 py-6">
    <!-- Topbar -->
    <div class="flex items-center justify-between bg-white border border-gray-200 shadow-sm rounded-xl px-3 sm:px-4 py-2 mb-4">
      <h1 class="text-lg sm:text-xl font-semibold text-gray-800">IB User List</h1>
      <!-- simple filter (optional): show only active -->
      <form method="get" class="hidden sm:flex items-center gap-2">
        <label class="text-sm text-gray-600">Status</label>
        <select name="st" class="border border-gray-300 rounded-md text-sm px-2 py-1">
          <?php
            $st = isset($_GET['st']) ? (int)$_GET['st'] : -1;
            $opts = [-1=>'All', 1=>'Active', 0=>'Inactive'];
            foreach ($opts as $k=>$v) {
              $sel = ($k===$st) ? 'selected' : '';
              echo "<option value=\"$k\" $sel>$v</option>";
            }
          ?>
        </select>
        <button class="btn-sm bg-[#CD7F32] text-white hover:brightness-95" formaction="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>">Apply</button>
      </form>
    </div>

   
    <div class="bg-white border border-gray-200 shadow-sm rounded-xl p-3 sm:p-4">
      <div class="flex items-center justify-between mb-3">
        <div>
          <h2 class="text-base sm:text-lg font-semibold text-gray-800">Introducing Brokers</h2>
          <p class="text-xs text-gray-500 mt-0.5">Showing <?= count($rows) ?> record(s)</p>
        </div>
      </div>

      <div class="table-wrap rounded-lg border border-gray-200">
        <table class="min-w-full bg-white">
          <thead class="bg-[#CD7F32] text-white text-xs sm:text-sm">
            <tr>
             
              <th class="p-2 sm:p-3 text-left">Email</th>
           
              <th class="p-2 sm:p-3 text-center">Clients</th>
              
              <th class="p-2 sm:p-3 text-left">Registered</th>
              <th class="p-2 sm:p-3 text-center">Status</th>
              <th class="p-2 sm:p-3 text-center">Action</th>
            </tr>
          </thead>
          <tbody class="text-xs sm:text-sm">
            <?php if (!count($rows)): ?>
              <tr>
                <td colspan="10" class="p-6 text-center text-gray-500">
                  No IB users found.
                </td>
              </tr>
            <?php else: ?>
              <?php
              $base = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on' ? 'https':'http') . '://' . $_SERVER['HTTP_HOST'];
              foreach ($rows as $r):
                $id   = (int)$r['indexId'];
               
                $email= $r['email'] ?? '';
                $code = $r['ib_ref_code'] ?? 'noCode';
                $clients = (int)($r['noClients'] ?? 0);
                $reg  = $r['reg_date'] ?? '';
                $status = (int)($r['status'] ?? 0);
                // compute referral link (adjust path if needed)
                $refLink = $base . '/signup.php?ref=' . urlencode($code);
              ?>
              <tr class="border-b border-gray-100 hover:bg-gray-50">
                
                
                <td class="p-2 sm:p-3 align-middle">
                  <a class="text-blue-600 hover:underline" href="mailto:<?= htmlspecialchars($email) ?>">
                    <?= htmlspecialchars($email) ?>
                  </a>
                </td>
              
                <td class="p-2 sm:p-3 align-middle text-center font-semibold text-gray-700"><?= number_format($clients) ?></td>
              
                <td class="p-2 sm:p-3 align-middle">
                  <span class="whitespace-nowrap"><?= htmlspecialchars($reg) ?></span>
                </td>
                <td class="p-2 sm:p-3 align-middle text-center">
                  <?php if ($status === 1): ?>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-emerald-700 bg-emerald-50 border border-emerald-200">Active</span>
                  <?php else: ?>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-amber-700 bg-amber-50 border border-amber-200">Inactive</span>
                  <?php endif; ?>
                </td>
                <td class="p-2 sm:p-3 align-middle">
                  <div class="actions">
                    <a href="ib_view.php?id=<?= $id ?>" class="btn-sm bg-gray-100 hover:bg-gray-200 border border-gray-300 text-gray-800" title="View">
                      <i class="ri-eye-line"></i>
                    </a>
                    <a href="ib_edit.php?id=<?= $id ?>" class="btn-sm bg-[#CD7F32] text-white hover:brightness-95" title="Edit">
                      <i class="ri-edit-2-line"></i>
                    </a>
                    <form method="post" action="ib_delete.php" onsubmit="return confirm('Delete this IB user?');" class="inline">
                      <input type="hidden" name="id" value="<?= $id ?>">
                      <button type="submit" class="btn-sm bg-red-600 text-white hover:bg-red-700" title="Delete">
                        <i class="ri-delete-bin-6-line"></i>
                      </button>
                    </form>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

  </main>
</div>

<?php include "footer.php"; ?>

<script>
function copyText(text, btn){
  navigator.clipboard.writeText(text).then(()=>{
    const old = btn.innerHTML;
    btn.innerHTML = '<i class="ri-check-line"></i>';
    setTimeout(()=> btn.innerHTML = old, 1200);
  });
}
</script>
</body>
</html>
