<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Table Actions</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>

<div class="flex flex-col md:flex-row min-h-screen">
    <!-- Sidebar -->
    <?php include "side_bar.php";?>

    <!-- Main Content -->
    <main class="flex-1 p-4 md:ml-64">
        <div class="container mx-auto bg-white p-6 shadow-lg rounded-lg">
            <h2 class="text-2xl font-bold mb-4 text-gray-700">Load List</h2>

            <!-- Responsive Table Wrapper -->
            <div class="overflow-x-auto">
                <table class="min-w-full border border-gray-300">
                    <thead class="bg-[#CD7F32] text-white">
                        <tr class="text-left">
                            <th class="p-3 border">#</th>
                            <th class="p-3 border">Name</th>
                            <th class="p-3 border">Phone</th>
                            <th class="p-3 border">Email</th>
                            <th class="p-3 border">Country</th>
                            <th class="p-3 border">Action</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm md:text-base">
                        <tr class="bg-gray-50">
                            <td class="p-3 border text-center">1</td>
                            <td class="p-3 border">John Smith</td>
                            <td class="p-3 border">0987654321</td>
                            <td class="p-3 border">john@example.com</td>
                            <td class="p-3 border">USA</td>
                            <td class="p-3 border flex flex-wrap gap-2 justify-center">
                                <button onclick="viewRow(this)" class="btn">View</button>
                                <button onclick="editRow(this)" class="btn">Edit</button>
                                <button onclick="deleteRow(this)" class="btn">Delete</button>
                                <button onclick="assignRow(this)" class="btn">Assign</button>
                                <button onclick="convertRow(this)" class="btn">Convert</button>
                            </td>
                        </tr>
                        <tr>
                            <td class="p-3 border text-center">2</td>
                            <td class="p-3 border">Emma Watson</td>
                            <td class="p-3 border">9876543210</td>
                            <td class="p-3 border">emma@example.com</td>
                            <td class="p-3 border">UK</td>
                            <td class="p-3 border flex flex-wrap gap-2 justify-center">
                                <button onclick="viewRow(this)" class="btn">View</button>
                                <button onclick="editRow(this)" class="btn">Edit</button>
                                <button onclick="deleteRow(this)" class="btn">Delete</button>
                                <button onclick="assignRow(this)" class="btn">Assign</button>
                                <button onclick="convertRow(this)" class="btn">Convert</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<?php include "footer.php";?>

<script>
    function viewRow(button) {
        let row = button.closest("tr");
        let name = row.cells[1].innerText;
        let phone = row.cells[2].innerText;
        let email = row.cells[3].innerText;
        let country = row.cells[4].innerText;
        alert(`Name: ${name}\nPhone: ${phone}\nEmail: ${email}\nCountry: ${country}`);
    }

    function editRow(button) {
        let row = button.closest("tr");
        let name = prompt("Enter new name:", row.cells[1].innerText);
        let phone = prompt("Enter new phone:", row.cells[2].innerText);
        let email = prompt("Enter new email:", row.cells[3].innerText);
        let country = prompt("Enter new country:", row.cells[4].innerText);

        if (name && phone && email && country) {
            row.cells[1].innerText = name;
            row.cells[2].innerText = phone;
            row.cells[3].innerText = email;
            row.cells[4].innerText = country;
        }
    }

    function deleteRow(button) {
        let row = button.closest("tr");
        if (confirm("Are you sure you want to delete this row?")) {
            row.remove();
        }
    }

    function assignRow(button) {
        let row = button.closest("tr");
        let name = row.cells[1].innerText;

        let teams = ["Sales Team", "Marketing Team", "Support Team", "Development Team"];
        let select = document.createElement("select");
        select.className = "border p-2 rounded";

        teams.forEach(team => {
            let option = document.createElement("option");
            option.value = team;
            option.textContent = team;
            select.appendChild(option);
        });

        let confirmButton = document.createElement("button");
        confirmButton.textContent = "Confirm";
        confirmButton.className = "ml-2 px-3 py-1 bg-blue-500 text-white rounded cursor-pointer";
        confirmButton.onclick = function () {
            let selectedTeam = select.value;
            alert(`${name} has been assigned to ${selectedTeam}`);
            document.body.removeChild(modal);
        };

        let modal = document.createElement("div");
        modal.className = "fixed inset-0 flex items-center justify-center bg-gray-900 bg-opacity-50";
        modal.innerHTML = `
            <div class="bg-white p-6 rounded-lg shadow-lg">
                <h3 class="text-lg font-semibold mb-2">Assign ${name} to:</h3>
            </div>
        `;

        modal.children[0].appendChild(select);
        modal.children[0].appendChild(confirmButton);
        document.body.appendChild(modal);
    }

    function convertRow(button) {
        let row = button.closest("tr");
        let name = row.cells[1].innerText;
        if (confirm(`Convert ${name} to a premium user?`)) {
            alert(`${name} has been converted to a premium user`);
        }
    }
</script>

<style>
    .btn {
        padding: 6px 12px;
        font-size: 14px;
        border-radius: 6px;
        transition: background 0.2s;
    }

    .btn:nth-child(1) { background-color: #E8C9A3; }
    .btn:nth-child(1):hover { background-color: #DFC19A; }

    .btn:nth-child(2) { background-color: #D6B392; }
    .btn:nth-child(2):hover { background-color: #CBAE88; }

    .btn:nth-child(3) { background-color: #E5A07A; }
    .btn:nth-child(3):hover { background-color: #DA9972; }

    .btn:nth-child(4) { background-color: #E5C298; }
    .btn:nth-child(4):hover { background-color: #D9B88E; }

    .btn:nth-child(5) { background-color: #D9A680; }
    .btn:nth-child(5):hover { background-color: #CE9E78; }
</style>

</body>
</html>
