<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transactions</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>
        
        <!-- Main Content -->
      <main class="flex-1 p-6 md:ml-64">
            <div class="container">
                 <h2 class="text-xl font-bold">Transactions</h2>
            <div class="mt-6 bg-white p-4 shadow rounded-lg">
                <table class="w-full border-collapse border border-gray-300">
                    <thead>
                        <tr class="bg-[#CD7F32]">
                            <th class="border p-1">Transaction ID</th>
                            <th class="border p-1">User</th>
                            <th class="border p-1">Amount</th>
                            <th class="border p-1">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $transactions = [
                            ['id' => 101, 'user' => 'John Doe', 'amount' => '$500', 'status' => 'Completed'],
                            ['id' => 102, 'user' => 'Jane Smith', 'amount' => '$1200', 'status' => 'Pending']
                        ];
                        foreach ($transactions as $transaction) {
                            echo "<tr class='text-center'>
                                    <td class='border p-1'>{$transaction['id']}</td>
                                    <td class='border p-1'>{$transaction['user']}</td>
                                    <td class='border p-1'>{$transaction['amount']}</td>
                                    <td class='border p-1'>{$transaction['status']}</td>
                                  </tr>";
                        }
                        ?>
                    </tbody>
                </table><br><br><br>
            </div><?php include "footer.php";?>
        </main>
    </div>
</body>
</html>
